/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.TemplateCategoryMapper;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractSubPaymentNodeEntity;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractSubPaymentNodeService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ImportContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.mapper.SettlePoolMapper;
import com.ejianc.business.contractbase.pool.settlepool.service.IBillUrlDictService;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.util.BeanUtil;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.business.pro.rmat.api.IRentCalculateApi;
import com.ejianc.business.pro.supplier.api.IAbnormalApi;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.pub.commonupdate.param.CommonUpdateParam;
import com.ejianc.business.rent.api.IRentRentalApi;
import com.ejianc.business.rent.vo.RentalSumVo;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.OutFlowVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="contractPoolService")
public class ContractPoolServiceImpl
extends BaseServiceImpl<ContractPoolMapper, ContractPoolEntity>
implements IContractPoolService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContractPoolMapper contractPoolMapper;
    @Autowired
    private IContractSubPaymentNodeService contractSubPaymentNodeService;
    @Autowired
    private IBillUrlDictService billUrlDictService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private SettlePoolMapper settlePoolMapper;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;
    @Autowired
    private ISettlePoolService settleService;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IRentRentalApi rentalApi;
    @Autowired
    private IRentCalculateApi rentCalculateApi;
    private static final String BILL_CODE = "CONTRACT_POOL";
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ICheckSupplierApi checkSupplierApi;
    @Autowired
    private IAbnormalApi abnormalApi;
    @Autowired
    private ITemplateCategoryService categoryService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @Override
    public void deleteBySourceId(Long sourceId) {
        this.contractSubPaymentNodeService.deleteByContractSourceId(sourceId);
        this.contractPoolMapper.deleteBySourceId(sourceId);
    }

    private ContractPoolEntity copyBaseFields(ContractPoolEntity dbEntity, ContractPoolVO contractPoolVO) {
        ContractPoolEntity saveEntity = null;
        if (UpdateLevelEnum.\u5168\u91cf\u8986\u76d6\u66f4\u65b0.getLevelCode().equals(contractPoolVO.getUpdateLevel())) {
            this.logger.info("\u5168\u91cf\u8ddf\u65b0\u5408\u540c\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            saveEntity = (ContractPoolEntity)((Object)BeanMapper.map((Object)contractPoolVO, ContractPoolEntity.class));
        } else {
            saveEntity = (ContractPoolEntity)((Object)BeanMapper.map((Object)((Object)dbEntity), ContractPoolEntity.class));
            String[] updateFields = BeanUtil.getPropertyNames(contractPoolVO, contractPoolVO.getUpdateLevel());
            this.logger.info("\u90e8\u5206\u8ddf\u65b0\u5408\u540c\u6570\u636e-{}, \u672c\u6b21\u66f4\u65b0\u5b57\u6bb5-{}", (Object)JSONObject.toJSONString((Object)contractPoolVO), (Object)updateFields);
            BeanUtils.copyProperties((Object)contractPoolVO, (Object)((Object)saveEntity), (String[])updateFields);
        }
        HashMap sourceIdMap = new HashMap();
        dbEntity.getContractSubPaymentNodeList().stream().forEach(sub -> {
            sub.setRowState("del");
            sourceIdMap.put(sub.getSourceId(), sub);
        });
        ContractSubPaymentNodeEntity tmp = null;
        if (CollectionUtils.isNotEmpty((Collection)contractPoolVO.getContractSubPaymentNodeList())) {
            for (ContractSubPaymentNodeVO sub2 : contractPoolVO.getContractSubPaymentNodeList()) {
                tmp = (ContractSubPaymentNodeEntity)((Object)sourceIdMap.get(sub2.getSourceId()));
                if (null != tmp) {
                    sub2.setRowState("edit");
                    sourceIdMap.remove(sub2.getSourceId());
                    sub2.setVersion(tmp.getVersion());
                    continue;
                }
                sub2.setRowState("add");
            }
            saveEntity.setContractSubPaymentNodeList(BeanMapper.mapList((Iterable)contractPoolVO.getContractSubPaymentNodeList(), ContractSubPaymentNodeEntity.class));
            if (MapUtils.isNotEmpty(sourceIdMap)) {
                saveEntity.setContractSubPaymentNodeList(new ArrayList<ContractSubPaymentNodeEntity>(sourceIdMap.values()));
            }
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u5408\u540c\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)((Object)saveEntity)));
        saveEntity.setId(dbEntity.getId());
        saveEntity.setVersion(dbEntity.getVersion());
        saveEntity.setCreateTime(dbEntity.getCreateTime());
        saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
        saveEntity.setTenantId(dbEntity.getTenantId());
        if (StringUtils.isBlank((CharSequence)saveEntity.getPcCardUrl()) || StringUtils.isBlank((CharSequence)saveEntity.getMobileCardUrl())) {
            this.findDetailUrl(saveEntity);
        }
        return saveEntity;
    }

    @Override
    public ContractPoolVO saveOrUpdateContract(ContractPoolVO contract) {
        ContractTypeEnum ct;
        ContractPoolEntity dbEntity = this.selectBySourceId(contract.getSourceId());
        ContractPoolEntity saveEntity = null;
        if (null != dbEntity) {
            saveEntity = this.copyBaseFields(dbEntity, contract);
        } else {
            if (null == contract.getSourceId()) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540c\u6765\u6e90\u4e1a\u52a1\u5355\u636eid-[sourceId]\u4e3a\u7a7a\uff01");
            }
            if (null != contract.getId() && !contract.getId().equals(contract.getSourceId())) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540cId\u4e0e\u5408\u540csourceId\u4e0d\u4e00\u81f4\uff01");
            }
            if (null == contract.getCategoryId()) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540c\u5206\u7c7bId-[categoryId]\u4e3a\u7a7a");
            }
            if (null == contract.getSourceType()) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540c\u6765\u6e90\u5355\u4e1a\u52a1\u5355\u636e\u7c7b\u578b-[sourceType]\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)contract.getPerformanceStatus())) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540c\u5408\u540c\u5c65\u7ea6\u72b6\u6001-[performanceStatus]\u4e3a\u7a7a");
            }
            if (null == contract.getSupplementFlag()) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540c\u662f\u5426\u4e3a\u8865\u5145\u534f\u8bae\u6807\u8bc6\u4e3a\u7a7a-[supplementFlag]\u4e3a\u7a7a");
            }
            if (null == contract.getContractProperty()) {
                throw new BusinessException("\u540c\u6b65\u5408\u540c\u5931\u8d25\uff0c \u5408\u540c\u5c5e\u6027\u4e3a\u7a7a-[contractProperty]\u4e3a\u7a7a");
            }
            if (null == contract.getHandleType()) {
                contract.setHandleType(Integer.valueOf(0));
            }
            this.deleteBySourceId(contract.getSourceId());
            saveEntity = (ContractPoolEntity)((Object)BeanMapper.map((Object)contract, ContractPoolEntity.class));
            String msg = this.findDetailUrl(saveEntity);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                throw new BusinessException(msg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)saveEntity.getSourceType()) && null != (ct = ContractTypeEnum.getByCode((String)saveEntity.getSourceType()))) {
            saveEntity.setSourceTypeName(ct.getTypeName());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return (ContractPoolVO)BeanMapper.map((Object)((Object)saveEntity), ContractPoolVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ContractPoolVO updatePerformanceStatusByContractId(ContractPoolVO contractPoolVO) {
        ContractPoolEntity dbEntity = null;
        if (null != contractPoolVO.getSourceId()) {
            dbEntity = this.selectBySourceId(contractPoolVO.getSourceId());
        } else if (null != contractPoolVO.getId()) {
            dbEntity = (ContractPoolEntity)((Object)super.selectById((Serializable)contractPoolVO.getId()));
        }
        if (dbEntity == null) {
            throw new BusinessException("\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff0c\u5408\u540c\u6c60\u4e2d\u672a\u627e\u5230\u5339\u914d\u7684\u5408\u540c\u4fe1\u606f\uff01");
        }
        if (contractPoolVO.getSyncWithContractBill().booleanValue()) {
            if (null == dbEntity.getCategoryId()) {
                throw new BusinessException("\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff0c\u5408\u540c\u5206\u7c7b\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            TemplateCategoryEntity category = (TemplateCategoryEntity)((Object)this.categoryService.selectById(dbEntity.getCategoryId()));
            if (null == category) {
                throw new BusinessException("\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5408\u540c\u5206\u7c7b\u4fe1\u606f\uff01");
            }
            CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(category.getBillTypeCode());
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\uff0c\u67e5\u8be2\u5143\u6570\u636e\u7ed3\u679c-{}", (Object)category.getBillTypeCode(), (Object)JSONObject.toJSONString((Object)mdRefResp));
            if (!mdRefResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
            }
            String projectName = ((MdReferVO)mdRefResp.getData()).getProjectName();
            CommonUpdateParam updateParam = new CommonUpdateParam();
            updateParam.setBillId(dbEntity.getId());
            updateParam.setTableName(((MdReferVO)mdRefResp.getData()).getTableName());
            updateParam.setFieldValue((Object)contractPoolVO.getPerformanceStatus());
            if (ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode().equals(category.getCategoryProperty()) || ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode().equals(category.getCategoryProperty())) {
                updateParam.setFieldName("contract_performance_state");
            } else {
                updateParam.setFieldName("performance_status");
            }
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
            this.logger.info("\u83b7\u53d6\u7684\u8bf7\u6c42\u5934 authority\uff1a{}", (Object)request.getHeader("authority"));
            String authority = null;
            if (StringUtils.isNotBlank((CharSequence)request.getHeader("authority"))) {
                authority = request.getHeader("authority");
            }
            String url = this.BaseHost + projectName + "/commonUpdate/updateStatus";
            String response = ((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("authority", authority)).header("content-type", "application/json;charset=UTF-8")).body(JSON.toJSONString((Object)updateParam)).timeout(10000).execute().body();
            this.logger.info("\u66f4\u65b0\u5408\u540c-\u3010id-{}\u3011\u5c65\u7ea6\u72b6\u6001\uff0curl-{}\uff0cparam-{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{dbEntity.getId(), url, JSON.toJSONString((Object)updateParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), response});
            CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u66f4\u65b0\u5408\u540c\u5355\u636e\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff1a{}\uff01", (Object)response);
                throw new BusinessException("\u66f4\u65b0\u5408\u540c\u5355\u636e\u5c65\u7ea6\u72b6\u6001\u5931\u8d25!");
            }
        }
        dbEntity.setPerformanceStatus(contractPoolVO.getPerformanceStatus());
        super.saveOrUpdate((Object)dbEntity, false);
        return (ContractPoolVO)BeanMapper.map((Object)((Object)dbEntity), ContractPoolVO.class);
    }

    @Override
    public List<SubUnitTopVO> querySubUnitTopN(Integer topN, Integer mnyFlag, Integer yearFlag, Long orgId) {
        String year = null;
        String beginQuarterDate = null;
        String endQuarterDate = null;
        String month = null;
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List allOrgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List orgVOList = allOrgVOList.stream().filter(e -> e.getOrgType() == 2 || e.getOrgType() == 3).collect(Collectors.toList());
        List<Long> ordIdsList = allOrgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (yearFlag == 1) {
            beginQuarterDate = DateUtil.formatDate((Date)DateUtil.beginOfQuarter((Date)new Date()).toJdkDate());
            endQuarterDate = DateUtil.formatDate((Date)DateUtil.endOfQuarter((Date)new Date()).toJdkDate());
        } else if (yearFlag == 2) {
            month = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        } else {
            year = String.valueOf(DateUtil.year((Date)new Date()));
        }
        List<Object> list = new ArrayList();
        list = mnyFlag == 0 ? ((ContractPoolMapper)this.baseMapper).queryContractionSubUnitTopN(ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode(), year, beginQuarterDate, endQuarterDate, month, ordIdsList) : this.settlePoolMapper.queryProductSubUnitTopN(SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode(), year, beginQuarterDate, endQuarterDate, month, ordIdsList);
        Map orgIdMap = allOrgVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (k1, k2) -> k2));
        Map innerCodeMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity(), (k1, k2) -> k2));
        HashMap<String, SubUnitTopVO> map = new HashMap<String, SubUnitTopVO>();
        for (SubUnitTopVO subUnitTopVO : list) {
            OrgVO orgVO = (OrgVO)orgIdMap.get(subUnitTopVO.getOrgId());
            String innerCode = orgVO.getInnerCode();
            for (Map.Entry entry : innerCodeMap.entrySet()) {
                SubUnitTopVO topVO;
                if (!innerCode.contains(entry.getKey())) continue;
                OrgVO subOrgVO = (OrgVO)entry.getValue();
                String orgName = subOrgVO.getName();
                BigDecimal money = null;
                if (mnyFlag == 0) {
                    money = subUnitTopVO.getContractTaxMny() == null ? BigDecimal.ZERO : subUnitTopVO.getContractTaxMny().setScale(2, RoundingMode.HALF_DOWN);
                } else {
                    BigDecimal bigDecimal = money = subUnitTopVO.getSettleTaxMny() == null ? BigDecimal.ZERO : subUnitTopVO.getSettleTaxMny().setScale(2, RoundingMode.HALF_DOWN);
                }
                if (map.containsKey(orgName)) {
                    topVO = (SubUnitTopVO)map.get(orgName);
                    topVO.setMoney(ComputeUtil.safeAdd((BigDecimal)topVO.getMoney(), (BigDecimal)money));
                    map.put(orgName, topVO);
                    continue;
                }
                topVO = new SubUnitTopVO();
                topVO.setOrgId(subOrgVO.getId());
                topVO.setOrgCode(subOrgVO.getCode());
                topVO.setOrgName(subOrgVO.getName());
                topVO.setOrgType(subOrgVO.getOrgType());
                topVO.setMoney(money);
                map.put(orgName, topVO);
            }
        }
        ArrayList<SubUnitTopVO> resultList = new ArrayList(map.values());
        resultList = resultList.stream().sorted(Comparator.comparing(SubUnitTopVO::getMoney).reversed()).limit(topN.intValue()).collect(Collectors.toList());
        return resultList;
    }

    @Override
    public List<ContractDTO> getContractList(SupplyVO vo) {
        return this.contractPoolMapper.queryContractList(vo);
    }

    @Override
    public List<ContractDTO> getContractListByHeadUser(HeadUserVO vo) {
        return this.contractPoolMapper.getContractListByHeadUser(vo);
    }

    @Override
    public BigDecimal queryContractHonourMny(ContractPoolVO vo) {
        BigDecimal honourMny = BigDecimal.ZERO;
        switch (vo.getSourceType()) {
            case "contractMaterial": {
                OutFlowVO outFlowVO = new OutFlowVO();
                outFlowVO.setContractId(vo.getContractId());
                outFlowVO.setPartyaFlag(Integer.valueOf(0));
                CommonResponse response = this.storeManageApi.queryInstoreTaxMnyByPurchaseContractId(outFlowVO);
                if (response.isSuccess()) {
                    honourMny = (BigDecimal)response.getData();
                    break;
                }
                this.logger.error(response.getMsg());
                break;
            }
            case "rmat": {
                CommonResponse bigDecimalCommonResponse = this.rentCalculateApi.queryRentMny(vo.getContractId());
                if (bigDecimalCommonResponse.isSuccess()) {
                    honourMny = (BigDecimal)bigDecimalCommonResponse.getData();
                    break;
                }
                this.logger.error(bigDecimalCommonResponse.getMsg());
                break;
            }
            case "equipmentRent": {
                CommonResponse result = this.rentalApi.queryRentalMnyByContractId(vo.getContractId());
                if (result.isSuccess()) {
                    honourMny = ((RentalSumVo)result.getData()).getTotalTaxMny();
                    break;
                }
                this.logger.error(result.getMsg());
                break;
            }
            case "proSub": {
                QueryWrapper queryPro = new QueryWrapper();
                queryPro.eq((Object)"contract_id", (Object)vo.getContractId());
                queryPro.in((Object)"source_type", Arrays.asList(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()));
                queryPro.select(new String[]{"sum(if(source_type = 'pro_final', finish_cur_tax_mny, 0)) as totalFinishSettleTaxMny, sum(if(source_type = 'pro_month', cur_tax_mny, 0)) as totalMonthSettleTaxMny"});
                queryPro.groupBy((Object[])new String[]{"contract_id"});
                Map proSumMap = this.settleService.getMap((Wrapper)queryPro);
                if (!MapUtils.isNotEmpty((Map)proSumMap) || null == proSumMap.get("totalFinishSettleTaxMny") && null == proSumMap.get("totalFinishSettleTaxMny") && !"0".equals(proSumMap.get("totalFinishSettleTaxMny"))) break;
                if (null != proSumMap.get("totalFinishSettleTaxMny") && BigDecimal.ZERO.compareTo(new BigDecimal(proSumMap.get("totalFinishSettleTaxMny").toString())) != 0) {
                    honourMny = honourMny.add(new BigDecimal(proSumMap.get("totalFinishSettleTaxMny").toString()));
                    break;
                }
                if (null == proSumMap.get("totalMonthSettleTaxMny")) break;
                honourMny = honourMny.add(new BigDecimal(proSumMap.get("totalMonthSettleTaxMny").toString()));
                break;
            }
            case "laborSub": {
                QueryWrapper queryLabor = new QueryWrapper();
                queryLabor.eq((Object)"contract_id", (Object)vo.getContractId());
                queryLabor.in((Object)"source_type", Arrays.asList(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()));
                queryLabor.select(new String[]{"sum(if(source_type = 'labor_final', finish_cur_tax_mny, 0)) as totalFinishSettleTaxMny, sum(if(source_type = 'labor_month', cur_tax_mny, 0)) as totalMonthSettleTaxMny"});
                queryLabor.groupBy((Object[])new String[]{"contract_id"});
                Map laborSumMap = this.settleService.getMap((Wrapper)queryLabor);
                if (!MapUtils.isNotEmpty((Map)laborSumMap) || null == laborSumMap.get("totalFinishSettleTaxMny") && null == laborSumMap.get("totalFinishSettleTaxMny") && !"0".equals(laborSumMap.get("totalFinishSettleTaxMny"))) break;
                if (null != laborSumMap.get("totalFinishSettleTaxMny") && BigDecimal.ZERO.compareTo(new BigDecimal(laborSumMap.get("totalFinishSettleTaxMny").toString())) != 0) {
                    honourMny = honourMny.add(new BigDecimal(laborSumMap.get("totalFinishSettleTaxMny").toString()));
                    break;
                }
                if (null == laborSumMap.get("totalMonthSettleTaxMny")) break;
                honourMny = honourMny.add(new BigDecimal(laborSumMap.get("totalMonthSettleTaxMny").toString()));
                break;
            }
            case "equipmentPurchase": {
                QueryParam queryEqu = new QueryParam();
                queryEqu.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
                queryEqu.getParams().put("source_type", new Parameter("eq", (Object)SettleSourceTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97.getCode()));
                queryEqu.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
                List settlePoolEqu = this.settleService.queryList(queryEqu);
                if (!CollectionUtil.isNotEmpty((Collection)settlePoolEqu)) break;
                for (SettlePoolEntity entity : settlePoolEqu) {
                    if (entity.getCurTaxMny() == null) continue;
                    honourMny = honourMny.add(entity.getCurTaxMny());
                }
                break;
            }
            case "tempEquip": {
                QueryParam queryTem = new QueryParam();
                queryTem.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
                queryTem.getParams().put("source_type", new Parameter("eq", (Object)SettleSourceTypeEnum.\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97.getCode()));
                queryTem.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
                List settlePoolTem = this.settleService.queryList(queryTem);
                if (!CollectionUtil.isNotEmpty((Collection)settlePoolTem)) break;
                for (SettlePoolEntity entity : settlePoolTem) {
                    if (entity.getCurTaxMny() == null) continue;
                    honourMny = honourMny.add(entity.getCurTaxMny());
                }
                break;
            }
            case "contractAC": {
                QueryParam queryBig = new QueryParam();
                queryBig.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
                queryBig.getParams().put("source_type", new Parameter("in", Arrays.asList(SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode())));
                queryBig.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
                List settlePoolBig = this.settleService.queryList(queryBig);
                if (!CollectionUtil.isNotEmpty((Collection)settlePoolBig)) break;
                for (SettlePoolEntity entity : settlePoolBig) {
                    if (entity.getCurTaxMny() == null) continue;
                    honourMny = honourMny.add(entity.getCurTaxMny());
                }
                break;
            }
            case "contractOther": {
                QueryParam queryOth = new QueryParam();
                queryOth.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
                queryOth.getParams().put("source_type", new Parameter("in", Arrays.asList(SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode())));
                queryOth.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
                List settlePoolOth = this.settleService.queryList(queryOth);
                if (!CollectionUtil.isNotEmpty((Collection)settlePoolOth)) break;
                for (SettlePoolEntity entity : settlePoolOth) {
                    if (entity.getCurTaxMny() == null) continue;
                    honourMny = honourMny.add(entity.getCurTaxMny());
                }
                break;
            }
            case "contractConcrete": {
                QueryParam conQuery = new QueryParam();
                conQuery.getParams().put("purchase_contract_id", new Parameter("eq", (Object)vo.getContractId()));
                conQuery.getParams().put("in_out_flag", new Parameter("eq", (Object)1));
                conQuery.getParams().put("in_out_type", new Parameter("eq", (Object)30));
                conQuery.getParams().put("source_bill_type_code", new Parameter("eq", (Object)"BT220224000000004"));
                CommonResponse flowResp = this.storeFlowApi.getFlowList(conQuery);
                this.logger.error("\u6839\u636e\u53c2\u6570\u5408\u540cid-{}\uff0cin_out_flag-{}, in_out_type-{}, source_bill_type_code-{}\u67e5\u8be2\u5bf9\u5e94\u7684\u6df7\u51dd\u571f\u9a8c\u6536\u5355\u7ed3\u679c\uff1a{}", new Object[]{vo.getContractId(), 1, 30, "BT220224000000004", JSONObject.toJSONString((Object)flowResp)});
                if (!flowResp.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)flowResp.getData()))) break;
                honourMny = ((List)flowResp.getData()).stream().map(FlowVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                break;
            }
        }
        return honourMny;
    }

    @Override
    public CommonResponse<IPage<SupplierVO>> querySumContract(QueryParam param) {
        Long suplyId;
        this.logger.info("\u5165\u53c2\u6253\u5370_map:" + JSONObject.toJSONString((Object)param));
        int Index = param.getPageIndex();
        int Size = param.getPageSize();
        long pageIndex = Index;
        long pageSize = Size;
        LinkedHashMap orderMap = param.getOrderMap();
        String orderName = "";
        String orderValue = "";
        String order1 = orderMap.get("contractMny") == null ? "" : ((String)orderMap.get("contractMny")).toString();
        String order2 = orderMap.get("lastSignDate") == null ? "" : ((String)orderMap.get("lastSignDate")).toString();
        Long l = suplyId = param.getParams().get("suplyId") == null ? null : (Long)((Parameter)param.getParams().get("suplyId")).getValue();
        if (!StringUtils.isEmpty((CharSequence)order1)) {
            orderName = "contractMny";
            orderValue = order1;
        } else {
            orderName = "lastSignDate";
            orderValue = order2;
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.orgApi.findChildrenByParentId(orgId);
        List<Long> orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        this.logger.info("orgIdList:" + orgIdList);
        Map params = param.getParams();
        Parameter personalParameter = (Parameter)params.get("personal");
        String personal = "";
        if (null != personalParameter) {
            personal = personalParameter.getValue().toString();
        }
        Parameter gradeIdParameter = (Parameter)params.get("grade_id");
        String grade_id = "";
        if (null != gradeIdParameter) {
            grade_id = gradeIdParameter.getValue().toString();
        }
        Parameter supplyTypeParameter = (Parameter)params.get("supply_type");
        ArrayList<String> supply_type = new ArrayList();
        if (null != supplyTypeParameter) {
            String supplyTypeStr = supplyTypeParameter.getValue().toString();
            String[] split = supplyTypeStr.split(",");
            supply_type = Arrays.asList(split);
        }
        Parameter punishTypeParameter = (Parameter)params.get("punish_type");
        String punish_type = "";
        if (null != punishTypeParameter) {
            punish_type = punishTypeParameter.getValue().toString();
        }
        String searchText = param.getSearchText();
        ArrayList<String> searchTexts = new ArrayList<String>();
        searchTexts.add("code");
        searchTexts.add("area");
        searchTexts.add("name");
        searchTexts.add("tax_payer_identifier");
        searchTexts.add("material_content");
        searchTexts.add("equipment_content");
        searchTexts.add("major_content");
        searchTexts.add("labor_content");
        searchTexts.add("sub_content");
        searchTexts.add("other_content");
        searchTexts.add("revolv_material_content");
        Long queryCount = this.contractPoolMapper.queryCount(suplyId, orgIdList, orderName, orderValue, personal, grade_id, supply_type, punish_type, searchText, searchTexts);
        this.logger.info("\u67e5\u8be2\u6761\u6570\u6210\u529f:" + queryCount);
        List<SupplierVO> supplierVOS = this.contractPoolMapper.queryContractInfo(suplyId, orgIdList, orderName, orderValue, personal, grade_id, supply_type, punish_type, searchText, searchTexts, (pageIndex - 1L) * pageSize, pageSize);
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        ArrayList supplierIds = new ArrayList();
        supplierVOS.forEach(item -> supplierIds.add(item.getSuplyId()));
        paramMap.put("suplyIds", supplierIds);
        paramMap.put("orgIds", orgIdList);
        CommonResponse mapCommonResponse = this.paymentApplyApi.querySumMny(paramMap);
        this.logger.info("mapCommonResponse:" + JSONObject.toJSONString((Object)mapCommonResponse));
        CommonResponse mapCommonResponse1 = this.checkSupplierApi.queryTotalBranch(paramMap);
        this.logger.info("mapCommonResponse1:" + JSONObject.toJSONString((Object)mapCommonResponse1));
        if (mapCommonResponse.isSuccess() && mapCommonResponse1.isSuccess()) {
            Map data = (Map)mapCommonResponse.getData();
            Map data1 = (Map)mapCommonResponse1.getData();
            supplierVOS.forEach(item -> {
                item.setActualMny((BigDecimal)data.get(item.getSuplyId()));
                item.setTotalBranch((BigDecimal)data1.get(item.getSuplyId()));
            });
        }
        Page page = new Page(pageIndex, pageSize, queryCount.longValue());
        HashMap abnormalMap = new HashMap();
        CommonResponse listCommonResponse = this.abnormalApi.queryAbnormal();
        if (listCommonResponse.isSuccess() && listCommonResponse.getData() != null) {
            List data = (List)listCommonResponse.getData();
            data.forEach(item -> abnormalMap.put(item.getId(), item.getName()));
        }
        supplierVOS.forEach(item -> {
            String allContent = "";
            if (!StringUtils.isEmpty((CharSequence)item.getMaterialContent())) {
                allContent = allContent + item.getMaterialContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getEquipmentContent())) {
                allContent = allContent + item.getEquipmentContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getMajorContent())) {
                allContent = allContent + item.getMajorContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getLaborContent())) {
                allContent = allContent + item.getLaborContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getSubContent())) {
                allContent = allContent + item.getSubContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getOtherContent())) {
                allContent = allContent + item.getOtherContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getRevolvMaterialContent())) {
                allContent = allContent + item.getRevolvMaterialContent() + ",";
            }
            if (!StringUtils.isEmpty((CharSequence)item.getConsultContent())) {
                allContent = allContent + item.getConsultContent() + ",";
            }
            item.setAllContent(allContent);
            if (null != item.getPunishType()) {
                item.setPunishTypeStr((String)abnormalMap.get(item.getPunishType()));
            }
        });
        page.setRecords(supplierVOS);
        return CommonResponse.success((Object)page);
    }

    private String findDetailUrl(ContractPoolEntity saveEntity) {
        TemplateCategoryEntity category;
        Map<String, String> urlMap;
        ArrayList<String> sourceTypes = new ArrayList<String>();
        sourceTypes.add(saveEntity.getSourceType() + "Pc");
        sourceTypes.add(saveEntity.getSourceType() + "Mobile");
        if (null == saveEntity.getId()) {
            saveEntity.setId(saveEntity.getSourceId());
        }
        if (MapUtils.isNotEmpty(urlMap = this.billUrlDictService.getDictMapBySourceTypes(sourceTypes))) {
            if (StringUtils.isBlank((CharSequence)saveEntity.getPcCardUrl()) && null != urlMap.get(saveEntity.getSourceType() + "Pc")) {
                saveEntity.setPcCardUrl(urlMap.get(saveEntity.getSourceType() + "Pc"));
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getMobileCardUrl()) && null != urlMap.get(saveEntity.getSourceType() + "Mobile")) {
                saveEntity.setMobileCardUrl(urlMap.get(saveEntity.getSourceType() + "Mobile"));
            }
        } else {
            this.logger.info("\u6839\u636e\u5408\u540c\u6765\u6e90\u7c7b\u578b-[{}]\u672a\u83b7\u53d6\u5230\u5408\u540c\u5bf9\u5e94\u7684\u8be6\u60c5\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5b57\u5178\u8868\u914d\u7f6e\uff01\uff01\uff01", (Object)saveEntity.getSourceType());
        }
        if (StringUtils.isBlank((CharSequence)saveEntity.getSourceTypeName())) {
            saveEntity.setSourceTypeName(ContractTypeEnum.getByCode((String)saveEntity.getSourceType()).getTypeName());
        }
        if (null == saveEntity.getAddType()) {
            saveEntity.setAddType(1);
        }
        if (null == (category = (TemplateCategoryEntity)((Object)this.templateCategoryMapper.selectById(saveEntity.getCategoryId())))) {
            this.logger.error("\u5408\u540c-\u3010{}\u3011\u6ca1\u6709\u5339\u914d\u7684\u5408\u540c\u5206\u7c7b\u6570\u636e\uff01", JSONObject.toJSON((Object)((Object)saveEntity)));
            return "\u540c\u6b65\u5408\u540c\u6c60\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5408\u540c\u5206\u7c7b";
        }
        saveEntity.setCategoryName(category.getCategoryName());
        saveEntity.setCategoryProperty(category.getCategoryProperty());
        return null;
    }

    private ContractPoolEntity selectBySourceId(Long sourceId) {
        List<ContractSubPaymentNodeEntity> subList;
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"source_id", (Object)sourceId)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ContractPoolEntity main = (ContractPoolEntity)((Object)super.getOne((Wrapper)query));
        if (null != main && CollectionUtils.isNotEmpty(subList = this.contractSubPaymentNodeService.listByPid(main.getId()))) {
            main.setContractSubPaymentNodeList(subList);
        }
        return main;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        List sucVoList;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        HashMap<String, OrgVO> orgVOMap = new HashMap<String, OrgVO>();
        HashMap<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<String, ProjectPoolSetVO>();
        HashMap<String, TemplateCategoryEntity> categoryMap = new HashMap<String, TemplateCategoryEntity>();
        HashMap<String, ContractPoolEntity> contractPoolVoNoCodeMap = new HashMap<String, ContractPoolEntity>();
        HashMap<String, com.ejianc.foundation.share.vo.SupplierVO> supplierVOMap = new HashMap<String, com.ejianc.foundation.share.vo.SupplierVO>();
        HashMap<String, OrgVO> projectOrgVoMap = new HashMap<String, OrgVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportContractPoolVO> successList = new ArrayList<ImportContractPoolVO>();
        ArrayList<ImportContractPoolVO> errorList = new ArrayList<ImportContractPoolVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 27) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            Map<Object, Object> defMap = new HashMap();
            HashMap<String, Long> defParamMap = new HashMap<String, Long>();
            defParamMap.put("tenantId", tenantid);
            String defCondition = JSONObject.toJSONString(defParamMap);
            CommonResponse defRes = this.defdocApi.queryDetailListByDefdocCode("pricing_type", defCondition);
            if (defRes.isSuccess() && defRes.getData() != null) {
                List defList = (List)defRes.getData();
                defMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
            }
            for (int i = 1; i < result.size(); ++i) {
                OrgVO orgVO;
                CommonResponse orgVORes;
                Object orgIdP = 0L;
                List datas = (List)result.get(i);
                ImportContractPoolVO detailVO = new ImportContractPoolVO();
                String parentOrgNameEx = (String)datas.get(0);
                detailVO.setParentOrgName(parentOrgNameEx);
                String contractCodeEx = (String)datas.get(1);
                detailVO.setContractCode(contractCodeEx);
                String contractNameEx = (String)datas.get(2);
                detailVO.setContractName(contractNameEx);
                String purchaseTypeNameEx = (String)datas.get(3);
                detailVO.setPurchaseTypeName(purchaseTypeNameEx);
                String projectNameEx = (String)datas.get(4);
                detailVO.setProjectName(projectNameEx);
                String contractPropertyNameEx = (String)datas.get(5);
                detailVO.setContractPropertyName(contractPropertyNameEx);
                String categoryBigEx = (String)datas.get(6);
                detailVO.setCategoryProperty(categoryBigEx);
                String categoryNameEx = (String)datas.get(7);
                detailVO.setCategoryName(categoryNameEx);
                String supplementFlagNameEx = (String)datas.get(8);
                detailVO.setSupplementFlagName(supplementFlagNameEx);
                String mainContractNameEx = (String)datas.get(9);
                detailVO.setMainContractName(mainContractNameEx);
                String performanceStatusNameEx = (String)datas.get(10);
                detailVO.setPerformanceStatusName(performanceStatusNameEx);
                String partyaNameEx = (String)datas.get(11);
                detailVO.setPartyaName(partyaNameEx);
                String partybNameEx = (String)datas.get(12);
                detailVO.setPartybName(partybNameEx);
                String partycNameEx = (String)datas.get(13);
                detailVO.setPartycName(partycNameEx);
                String joinPartyNameEx = (String)datas.get(14);
                detailVO.setJoinPartyName(joinPartyNameEx);
                String signDateStrEx = (String)datas.get(15);
                String signPlaceEx = (String)datas.get(16);
                detailVO.setSignPlace(signPlaceEx);
                String taxRateEx = (String)datas.get(17);
                detailVO.setTaxRateStr(taxRateEx);
                String baseTaxMnyEx = (String)datas.get(18);
                detailVO.setBaseTaxMnyStr(baseTaxMnyEx);
                String baseMnyEx = (String)datas.get(19);
                detailVO.setBaseMnyStr(baseMnyEx);
                String contractTaxMnyEx = (String)datas.get(20);
                detailVO.setContractTaxMnyStr(contractTaxMnyEx);
                String contractMnyEx = (String)datas.get(21);
                detailVO.setContractMnyStr(contractMnyEx);
                String pricingTypeNameEx = (String)datas.get(22);
                detailVO.setPricingType(pricingTypeNameEx);
                String taxCalcTypeNameEx = (String)datas.get(23);
                detailVO.setTaxCalcTypeName(taxCalcTypeNameEx);
                String contractStartDateStrEx = (String)datas.get(24);
                String contractFinishDateStrEx = (String)datas.get(25);
                String memoEx = (String)datas.get(26);
                detailVO.setMemo(memoEx);
                if (StringUtils.isBlank((CharSequence)parentOrgNameEx)) {
                    detailVO.setErrorMessage("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgNameEx) == null) {
                    orgVORes = this.orgApi.findByNameAndTenantId(parentOrgNameEx, tenantid);
                    if (orgVORes.isSuccess()) {
                        OrgVO orgVO2 = (OrgVO)orgVORes.getData();
                        if (orgVO2 == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u6240\u5c5e\u7ec4\u7ec7\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            orgVOMap.put(parentOrgNameEx, orgVO2);
                            orgIdP = orgVO2.getId();
                            detailVO.setParentOrgId(orgVO2.getId());
                            detailVO.setParentOrgCode(orgVO2.getCode());
                            detailVO.setParentOrgName(orgVO2.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u6240\u5c5e\u7ec4\u7ec7\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    orgVO = (OrgVO)orgVOMap.get(parentOrgNameEx);
                    detailVO.setParentOrgId(orgVO.getId());
                    detailVO.setParentOrgCode(orgVO.getCode());
                    detailVO.setParentOrgName(orgVO.getName());
                }
                if (StringUtils.isBlank((CharSequence)contractNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    detailVO.setContractName(contractNameEx);
                }
                detailVO.setContractCode(contractCodeEx);
                if (StringUtils.isBlank((CharSequence)purchaseTypeNameEx)) {
                    detailVO.setErrorMessage("\u662f\u5426\u96c6\u91c7\u4e0d\u53ef\u4e3a\u7a7a");
                } else if ("\u662f".equals(purchaseTypeNameEx)) {
                    detailVO.setPurchaseType(Integer.valueOf(2));
                } else if ("\u5426".equals(purchaseTypeNameEx)) {
                    detailVO.setPurchaseType(Integer.valueOf(1));
                } else {
                    detailVO.setErrorMessage("\u662f\u5426\u96c6\u91c7\u586b\u5199\u4e0d\u6b63\u786e");
                }
                if (StringUtils.isBlank((CharSequence)projectNameEx)) {
                    detailVO.setErrorMessage("\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                    CommonResponse projectVOListRes = this.projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                    if (projectVOListRes.isSuccess()) {
                        List projectVOList = (List)projectVOListRes.getData();
                        if (CollectionUtils.isEmpty((Collection)projectVOList)) {
                            detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                        } else if (projectVOList.size() == 1) {
                            ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectVOList.get(0);
                            Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                            if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                CommonResponse orgVOCommonResponse = this.orgApi.detailById(projectDepartmentId);
                                if (orgVOCommonResponse.isSuccess()) {
                                    OrgVO orgVO3 = (OrgVO)orgVOCommonResponse.getData();
                                    if (orgVO3 == null) {
                                        detailVO.setErrorMessage("\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u6240\u5728\u7684\u9879\u76ee\u4e0d\u5728\u6240\u5c5e\u7ec4\u7ec7\u4e0b");
                                    } else {
                                        projectOrgVoMap.put(projectDepartmentId.toString(), orgVO3);
                                        String innerCode = orgVO3.getInnerCode();
                                        if (StringUtils.isEmpty((CharSequence)innerCode)) {
                                            detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u5931\u8d25");
                                        } else {
                                            List innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                            if (!innerCodes.contains(orgIdP)) {
                                                detailVO.setErrorMessage("\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u6240\u5728\u7684\u9879\u76ee\u4e0d\u5728\u6240\u5c5e\u7ec4\u7ec7\u4e0b");
                                            } else {
                                                detailVO.setOrgId(orgVO3.getId());
                                                detailVO.setOrgCode(orgVO3.getCode());
                                                detailVO.setOrgName(orgVO3.getName());
                                            }
                                        }
                                    }
                                } else {
                                    detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u7f16\u7801\u67e5\u8be2\u6240\u5728\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25");
                                }
                            } else {
                                OrgVO orgVO4 = (OrgVO)projectOrgVoMap.get(projectDepartmentId.toString());
                                String innerCode = orgVO4.getInnerCode();
                                if (StringUtils.isEmpty((CharSequence)innerCode)) {
                                    detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u5931\u8d25");
                                } else {
                                    List innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                    if (!innerCodes.contains(orgIdP)) {
                                        detailVO.setErrorMessage("\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u6240\u5728\u7684\u9879\u76ee\u4e0d\u5728\u6240\u5c5e\u7ec4\u7ec7\u4e0b");
                                    } else {
                                        detailVO.setOrgId(orgVO4.getId());
                                        detailVO.setOrgCode(orgVO4.getCode());
                                        detailVO.setOrgName(orgVO4.getName());
                                    }
                                }
                            }
                            projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectCode(projectPoolSetVO.getCode());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u9879\u76ee\u5931\u8d25");
                    }
                } else {
                    ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectPoolVoMap.get(projectNameEx);
                    detailVO.setProjectId(projectPoolSetVO.getId());
                    detailVO.setProjectCode(projectPoolSetVO.getCode());
                    detailVO.setProjectName(projectPoolSetVO.getName());
                }
                if (StringUtils.isBlank((CharSequence)contractPropertyNameEx)) {
                    detailVO.setErrorMessage("\u5c5e\u6027\u7c7b\u522b\u4e0d\u53ef\u4e3a\u7a7a");
                } else if ("\u6536\u5165".equals(contractPropertyNameEx)) {
                    detailVO.setContractProperty(Integer.valueOf(1));
                } else if ("\u652f\u51fa".equals(contractPropertyNameEx)) {
                    detailVO.setContractProperty(Integer.valueOf(0));
                } else {
                    detailVO.setErrorMessage("\u5c5e\u6027\u7c7b\u522b\u586b\u5199\u4e0d\u6b63\u786e");
                }
                if (StringUtils.isBlank((CharSequence)categoryBigEx) || StringUtils.isBlank((CharSequence)categoryNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u5927\u7c7b\u548c\u5408\u540c\u7c7b\u522b\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    String categoryBigCode = this.getCategoryBigCode(categoryBigEx);
                    if (StringUtils.isBlank((CharSequence)categoryBigCode)) {
                        detailVO.setErrorMessage("\u5408\u540c\u5927\u7c7b\u586b\u5199\u4e0d\u6b63\u786e");
                    } else {
                        if ("\u65bd\u5de5\u5408\u540c".equals(categoryBigEx) || "\u5176\u4ed6\u6536\u5165\u5408\u540c".equals(categoryBigEx)) {
                            if ("\u652f\u51fa".equals(contractPropertyNameEx)) {
                                detailVO.setErrorMessage("\u5408\u540c\u5927\u7c7b\u548c\u5408\u540c\u7c7b\u522b\u4e0d\u5339\u914d");
                            }
                        } else if ("\u6536\u5165".equals(contractPropertyNameEx)) {
                            detailVO.setErrorMessage("\u5408\u540c\u5927\u7c7b\u548c\u5408\u540c\u7c7b\u522b\u4e0d\u5339\u914d");
                        }
                        if (MapUtils.isEmpty(categoryMap) || categoryMap.get(categoryBigEx + "&" + categoryNameEx) == null) {
                            QueryWrapper templateCategoryEntityQueryWrapper = new QueryWrapper();
                            ((QueryWrapper)((QueryWrapper)((QueryWrapper)templateCategoryEntityQueryWrapper.eq((Object)"category_name", (Object)categoryNameEx)).eq((Object)"category_property", (Object)categoryBigCode)).eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid);
                            List templateCategoryEntityList = this.templateCategoryMapper.selectList((Wrapper)templateCategoryEntityQueryWrapper);
                            if (CollectionUtils.isEmpty((Collection)templateCategoryEntityList)) {
                                detailVO.setErrorMessage("\u5408\u540c\u5927\u7c7b\u548c\u5408\u540c\u7c7b\u522b\u4e0d\u5339\u914d");
                            } else if (templateCategoryEntityList.size() == 1) {
                                TemplateCategoryEntity templateCategoryEntity = (TemplateCategoryEntity)((Object)templateCategoryEntityList.get(0));
                                categoryMap.put(categoryBigEx + "&" + categoryNameEx, templateCategoryEntity);
                                detailVO.setCategoryId(templateCategoryEntity.getId());
                                detailVO.setCategoryName(templateCategoryEntity.getCategoryName());
                                detailVO.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                            } else {
                                detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u5927\u7c7b\u548c\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e");
                            }
                        } else {
                            TemplateCategoryEntity templateCategoryEntity = (TemplateCategoryEntity)((Object)categoryMap.get(categoryBigEx + "&" + categoryNameEx));
                            detailVO.setCategoryId(templateCategoryEntity.getId());
                            detailVO.setCategoryName(templateCategoryEntity.getCategoryName());
                            detailVO.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)supplementFlagNameEx)) {
                    detailVO.setErrorMessage("\u662f\u5426\u8865\u5145\u534f\u8bae\u4e0d\u53ef\u4e3a\u7a7a");
                } else if ("\u662f".equals(supplementFlagNameEx)) {
                    detailVO.setSupplementFlag(Integer.valueOf(1));
                    if (StringUtils.isBlank((CharSequence)mainContractNameEx)) {
                        detailVO.setErrorMessage("\u4e3b\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                    } else if (MapUtils.isEmpty(contractPoolVoNoCodeMap) || contractPoolVoNoCodeMap.get(mainContractNameEx) == null) {
                        QueryWrapper contractPoolEntityQueryWrapper = new QueryWrapper();
                        ((QueryWrapper)((QueryWrapper)contractPoolEntityQueryWrapper.eq((Object)"contract_name", (Object)mainContractNameEx)).eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid);
                        List contractPoolEntityList = this.contractPoolMapper.selectList((Wrapper)contractPoolEntityQueryWrapper);
                        if (CollectionUtils.isEmpty((Collection)contractPoolEntityList)) {
                            detailVO.setErrorMessage("\u6839\u636e\u4e3b\u5408\u540c\u540d\u79f0\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u5931\u8d25");
                        } else if (contractPoolEntityList.size() == 1) {
                            ContractPoolEntity contractPoolEntity = (ContractPoolEntity)((Object)contractPoolEntityList.get(0));
                            contractPoolVoNoCodeMap.put(mainContractNameEx, contractPoolEntity);
                            detailVO.setMainContractId(contractPoolEntity.getContractId());
                            detailVO.setMainContractCode(contractPoolEntity.getContractCode());
                            detailVO.setMainContractName(contractPoolEntity.getContractName());
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u4e3b\u5408\u540c\u540d\u79f0\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u5931\u8d25");
                        }
                    } else {
                        Object contractPoolEntity = (ContractPoolEntity)((Object)contractPoolVoNoCodeMap.get(mainContractNameEx));
                        detailVO.setMainContractId(((ContractPoolEntity)((Object)contractPoolEntity)).getContractId());
                        detailVO.setMainContractCode(((ContractPoolEntity)((Object)contractPoolEntity)).getContractCode());
                        detailVO.setMainContractName(((ContractPoolEntity)((Object)contractPoolEntity)).getContractName());
                    }
                } else if ("\u5426".equals(supplementFlagNameEx)) {
                    detailVO.setSupplementFlag(Integer.valueOf(0));
                } else {
                    detailVO.setErrorMessage("\u662f\u5426\u8865\u5145\u534f\u8bae\u586b\u5199\u4e0d\u6b63\u786e");
                }
                if (StringUtils.isBlank((CharSequence)performanceStatusNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    switch (performanceStatusNameEx) {
                        case "\u5c65\u7ea6\u4e2d": {
                            detailVO.setPerformanceStatus("2");
                            break;
                        }
                        case "\u5df2\u5c01\u8d26": {
                            detailVO.setPerformanceStatus("3");
                            break;
                        }
                        case "\u5df2\u89e3\u9664": {
                            detailVO.setPerformanceStatus("4");
                            break;
                        }
                        default: {
                            detailVO.setErrorMessage("\u5408\u540c\u72b6\u6001\u586b\u5199\u586b\u4e0d\u6b63\u786e");
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)partyaNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7532\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(partyaNameEx) == null) {
                    orgVORes = this.orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                    if (orgVORes.isSuccess()) {
                        OrgVO orgVO5 = (OrgVO)orgVORes.getData();
                        if (orgVO5 == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            orgVOMap.put(partyaNameEx, orgVO5);
                            detailVO.setPartyaId(orgVO5.getId());
                            detailVO.setPartyaName(orgVO5.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    orgVO = (OrgVO)orgVOMap.get(partyaNameEx);
                    detailVO.setPartyaId(orgVO.getId());
                    detailVO.setPartyaName(orgVO.getName());
                }
                if (StringUtils.isBlank((CharSequence)partybNameEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u4e59\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                    CommonResponse supplierVORes = this.shareSupplierApi.findOneByName(partybNameEx, tenantid);
                    if (supplierVORes.isSuccess()) {
                        com.ejianc.foundation.share.vo.SupplierVO supplierVO = (com.ejianc.foundation.share.vo.SupplierVO)supplierVORes.getData();
                        if (supplierVO == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partybNameEx, supplierVO);
                            detailVO.setPartybId(supplierVO.getId());
                            detailVO.setPartybName(supplierVO.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    com.ejianc.foundation.share.vo.SupplierVO supplierVO = (com.ejianc.foundation.share.vo.SupplierVO)supplierVOMap.get(partybNameEx);
                    detailVO.setPartybId(supplierVO.getId());
                    detailVO.setPartybName(supplierVO.getName());
                }
                detailVO.setPartycName(partycNameEx);
                detailVO.setJoinPartyName(joinPartyNameEx);
                if (StringUtils.isBlank((CharSequence)signDateStrEx)) {
                    detailVO.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO.setSignDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(signDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                detailVO.setSignPlace(signPlaceEx);
                if (StringUtils.isBlank((CharSequence)taxRateEx)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal taxRate = new BigDecimal(taxRateEx);
                        if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setTaxRate(taxRate);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)baseTaxMnyEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal baseTaxMny = new BigDecimal(baseTaxMnyEx);
                        if (baseTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setBaseTaxMny(baseTaxMny);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)baseMnyEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal baseMny = new BigDecimal(baseMnyEx);
                        if (baseMny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setBaseMny(baseMny);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                try {
                    BigDecimal baseTax = new BigDecimal(baseTaxMnyEx).subtract(new BigDecimal(baseMnyEx));
                    if (baseTax.compareTo(BigDecimal.ZERO) < 0) {
                        detailVO.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u65e0\u7a0e\uff09");
                    } else {
                        detailVO.setBaseTax(baseTax);
                    }
                }
                catch (Exception e) {
                    detailVO.setErrorMessage("\u8ba1\u7b97\u5408\u540c\u7b7e\u8ba2\u7a0e\u989d\u5931\u8d25\uff0c\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u548c\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u4e3a\u6570\u5b57");
                }
                if (StringUtils.isBlank((CharSequence)contractTaxMnyEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal contractTaxMny = new BigDecimal(contractTaxMnyEx);
                        if (contractTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setContractTaxMny(contractTaxMny);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)contractMnyEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal contractMny = new BigDecimal(contractMnyEx);
                        if (contractMny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setContractMny(contractMny);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                try {
                    BigDecimal contractTax = new BigDecimal(contractTaxMnyEx).subtract(new BigDecimal(contractMnyEx));
                    if (contractTax.compareTo(BigDecimal.ZERO) < 0) {
                        detailVO.setErrorMessage("\u5408\u540c\u603b\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e\u5408\u540c\u603b\u91d1\u989d\uff08\u65e0\u7a0e\uff09");
                    } else {
                        detailVO.setContractTax(contractTax);
                    }
                }
                catch (Exception e) {
                    detailVO.setErrorMessage("\u8ba1\u7b97\u5408\u540c\u603b\u7a0e\u989d\u5931\u8d25\uff0c\u5408\u540c\u603b\u91d1\u989d\u548c\u5408\u540c\u603b\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u4e3a\u6570\u5b57");
                }
                if (StringUtils.isBlank((CharSequence)pricingTypeNameEx)) {
                    detailVO.setErrorMessage("\u8ba1\u4ef7\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    String pricingTypeIdStr = (String)defMap.get(pricingTypeNameEx);
                    Long pricingTypeId = null;
                    if (StringUtils.isNotBlank((CharSequence)pricingTypeIdStr)) {
                        pricingTypeId = Long.parseLong(pricingTypeIdStr);
                    }
                    switch (pricingTypeNameEx) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            detailVO.setPricingType(pricingTypeNameEx);
                            detailVO.setPricingTypeId(pricingTypeId);
                            break;
                        }
                        case "\u56fa\u5b9a\u603b\u4ef7": {
                            detailVO.setPricingType(pricingTypeNameEx);
                            detailVO.setPricingTypeId(pricingTypeId);
                            break;
                        }
                        case "\u53ef\u8c03\u5355\u4ef7": {
                            detailVO.setPricingType(pricingTypeNameEx);
                            detailVO.setPricingTypeId(pricingTypeId);
                            break;
                        }
                        case "\u8d39\u7387\u5408\u540c": {
                            detailVO.setPricingType(pricingTypeNameEx);
                            detailVO.setPricingTypeId(pricingTypeId);
                            break;
                        }
                        default: {
                            detailVO.setErrorMessage("\u8ba1\u4ef7\u65b9\u5f0f\u586b\u5199\u4e0d\u6b63\u786e");
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)taxCalcTypeNameEx)) {
                    detailVO.setErrorMessage("\u8ba1\u7a0e\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    if (!"\u4e00\u822c\u8ba1\u7a0e".equals(taxCalcTypeNameEx) && !"\u7b80\u6613\u5f81\u6536".equals(taxCalcTypeNameEx)) {
                        detailVO.setErrorMessage("\u8ba1\u7a0e\u65b9\u5f0f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                    detailVO.setTaxCalcTypeName(taxCalcTypeNameEx);
                }
                if (StringUtils.isNotBlank((CharSequence)contractStartDateStrEx)) {
                    try {
                        detailVO.setContractStartDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(contractStartDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5408\u540c\u5f00\u5de5\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)contractFinishDateStrEx)) {
                    try {
                        detailVO.setContractFinishDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(contractStartDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5408\u540c\u7ae3\u5de5\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)memoEx) && memoEx.length() > 100) {
                    detailVO.setErrorMessage("\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u5927\u4e8e100");
                } else {
                    detailVO.setMemo(memoEx);
                }
                if (StringUtils.isBlank((CharSequence)detailVO.getErrorMessage())) {
                    detailVO.setHandleType(Integer.valueOf(1));
                    detailVO.setHandleTypeName("\u662f");
                    successList.add(detailVO);
                    continue;
                }
                errorList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        Date createTime = new Date();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        if (CollectionUtils.isNotEmpty((Collection)(sucVoList = BeanMapper.mapList(successList, ContractPoolVO.class)))) {
            for (ContractPoolVO vo : sucVoList) {
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                long contractId = IdWorker.getId();
                vo.setContractId(Long.valueOf(contractId));
                vo.setSourceId(Long.valueOf(contractId));
                if (!StringUtils.isBlank((CharSequence)vo.getContractCode())) continue;
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)tenantid, (BaseVO)vo);
                CommonResponse billCodeRes = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCodeRes.isSuccess()) {
                    vo.setContractCode((String)billCodeRes.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List sucEntityList = BeanMapper.mapList((Iterable)sucVoList, ContractPoolEntity.class);
            this.saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success((Object)json);
    }

    private String getCategoryBigCode(String categoryName) {
        String categoryCode = "";
        if (StringUtils.isBlank((CharSequence)categoryName)) {
            return categoryCode;
        }
        switch (categoryName) {
            case "\u5468\u8f6c\u6750\u5408\u540c": {
                categoryCode = "rmat";
                break;
            }
            case "\u65bd\u5de5\u5408\u540c": {
                categoryCode = "contraction";
                break;
            }
            case "\u4e13\u4e1a\u5206\u5305\u5408\u540c": {
                categoryCode = "proSub";
                break;
            }
            case "\u52b3\u52a1\u5206\u5305\u5408\u540c": {
                categoryCode = "laborSub";
                break;
            }
            case "\u7269\u8d44\u91c7\u8d2d\u5408\u540c": {
                categoryCode = "contractMaterial";
                break;
            }
            case "\u6df7\u51dd\u571f\u5408\u540c": {
                categoryCode = "contractConcrete";
                break;
            }
            case "\u6536\u5165\u5408\u540c": {
                categoryCode = "contractIn";
                break;
            }
            case "\u652f\u51fa\u5408\u540c": {
                categoryCode = "contractOut";
                break;
            }
            case "\u5176\u4ed6\u6536\u5165\u5408\u540c": {
                categoryCode = "otherIn";
                break;
            }
            case "\u5176\u4ed6\u652f\u51fa\u5408\u540c": {
                categoryCode = "contractOther";
                break;
            }
            case "\u8bbe\u5907\u79df\u8d41\u5408\u540c": {
                categoryCode = "equipmentRent";
                break;
            }
            case "\u8bbe\u5907\u91c7\u8d2d\u5408\u540c": {
                categoryCode = "equipmentPurchase";
                break;
            }
            case "\u4e34\u65f6\u8bbe\u5907\u5408\u540c": {
                categoryCode = "tempEquip";
                break;
            }
            case "\u5b89\u62c6\u5408\u540c": {
                categoryCode = "contractAC";
                break;
            }
            case "\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c": {
                categoryCode = "assistrmat";
                break;
            }
            case "\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c": {
                categoryCode = "assistmaterial";
                break;
            }
        }
        return categoryCode;
    }

    public ContractPoolVO queryContractPool(String param) {
        this.logger.info("ContractPoolServiceImpl--queryContractPool()--\u67e5\u8be2\u5408\u540c\u6c60\u7684\u5408\u540c--begin--\u5165\u53c2\uff1aparam={}", (Object)param);
        List<ContractPoolVO> contractPoolVOList = this.queryContractPoolList(param);
        if (CollectionUtils.isEmpty(contractPoolVOList)) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return new ContractPoolVO();
        }
        if (contractPoolVOList.size() > 1) {
            this.logger.error("\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(contractPoolVOList));
            throw new BusinessException("\u67e5\u8be2\u591a\u6761\u6570\u636e");
        }
        ContractPoolVO contractPoolVO = contractPoolVOList.get(0);
        this.logger.info("ContractPoolServiceImpl--queryContractPool()--\u67e5\u8be2\u5408\u540c\u6c60\u7684\u5408\u540c--end--\u8fd4\u56de\u7ed3\u679c\uff1aresult={}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
        return contractPoolVO;
    }

    public List<ContractPoolVO> queryContractPoolList(String param) {
        this.logger.info("ContractPoolServiceImpl--queryContractPoolList()--\u67e5\u8be2\u5408\u540c\u6c60\u7684\u5408\u540c\u5217\u8868--begin--\u5165\u53c2\uff1aparam={}", (Object)param);
        QueryParam queryParam = this.getQueryParam(param);
        if (queryParam == null) {
            this.logger.info("\u5165\u53c2\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u7ed3\u679c\u96c6");
            return new ArrayList<ContractPoolVO>();
        }
        List contractPoolEntityList = super.queryList(queryParam);
        this.logger.info("ContractPoolServiceImpl--queryContractPoolList()--\u67e5\u8be2\u5408\u540c\u6c60\u7684\u5408\u540c\u5217\u8868--end--\u8fd4\u56de\u7ed3\u679c\uff1aresult={}", (Object)JSONObject.toJSONString((Object)contractPoolEntityList));
        return BeanMapper.mapList((Iterable)contractPoolEntityList, ContractPoolVO.class);
    }

    private QueryParam getQueryParam(String param) {
        String mainContractCodeStr;
        String mainContractNameStr;
        String mainContractIdStr;
        String supplementFlagStr;
        String projectCodeStr;
        String projectNameStr;
        String projectIdStr;
        String performanceStatusStr;
        String sourceTypeStr;
        String contractPropertyStr;
        String contractCodeStr;
        String contractNameStr;
        String contractIdStr;
        String orgIdStr;
        if (StringUtils.isBlank((CharSequence)param)) {
            return null;
        }
        QueryParam queryParam = new QueryParam();
        Map params = queryParam.getParams();
        JSONObject paramJson = JSONObject.parseObject((String)param);
        Long tenantid = InvocationInfoProxy.getTenantid();
        params.put("tenantId", new Parameter("eq", (Object)tenantid));
        String parentOrgIdStr = paramJson.getString("parentOrgId");
        if (StringUtils.isNotBlank((CharSequence)parentOrgIdStr)) {
            if (parentOrgIdStr.contains(",")) {
                List parentOrgIdList = Arrays.stream(parentOrgIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("parentOrgId", new Parameter("in", parentOrgIdList));
            } else {
                params.put("parentOrgId", new Parameter("eq", (Object)Long.parseLong(parentOrgIdStr)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(orgIdStr = paramJson.getString("orgId")))) {
            if (orgIdStr.contains(",")) {
                List orgIdList = Arrays.stream(orgIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("orgId", new Parameter("in", orgIdList));
            } else {
                params.put("orgId", new Parameter("eq", (Object)Long.parseLong(orgIdStr)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(contractIdStr = paramJson.getString("contractId")))) {
            if (contractIdStr.contains(",")) {
                List contractIdList = Arrays.stream(contractIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("contractId", new Parameter("in", contractIdList));
            } else {
                params.put("contractId", new Parameter("eq", (Object)Long.parseLong(contractIdStr)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(contractNameStr = paramJson.getString("contractName")))) {
            if (contractNameStr.contains(",")) {
                params.put("contractId", new Parameter("in", (Object)contractNameStr.split(",")));
            } else {
                params.put("contractId", new Parameter("eq", (Object)contractNameStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(contractCodeStr = paramJson.getString("contractCode")))) {
            if (contractCodeStr.contains(",")) {
                params.put("contractCode", new Parameter("in", (Object)contractCodeStr.split(",")));
            } else {
                params.put("contractCode", new Parameter("eq", (Object)contractCodeStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(contractPropertyStr = paramJson.getString("contractProperty")))) {
            params.put("contractProperty", new Parameter("eq", (Object)Integer.parseInt(contractPropertyStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceTypeStr = paramJson.getString("sourceType")))) {
            if (sourceTypeStr.contains(",")) {
                params.put("sourceType", new Parameter("in", (Object)sourceTypeStr.split(",")));
            } else {
                params.put("sourceType", new Parameter("eq", (Object)sourceTypeStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(performanceStatusStr = paramJson.getString("performanceStatus")))) {
            if (performanceStatusStr.contains(",")) {
                params.put("performanceStatus", new Parameter("in", (Object)performanceStatusStr.split(",")));
            } else {
                params.put("performanceStatus", new Parameter("eq", (Object)performanceStatusStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(projectIdStr = paramJson.getString("projectId")))) {
            if (projectIdStr.contains(",")) {
                List projectIdList = Arrays.stream(projectIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("projectId", new Parameter("in", projectIdList));
            } else {
                params.put("projectId", new Parameter("eq", (Object)projectIdStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(projectNameStr = paramJson.getString("projectName")))) {
            if (projectNameStr.contains(",")) {
                params.put("projectName", new Parameter("in", (Object)projectNameStr.split(",")));
            } else {
                params.put("projectName", new Parameter("eq", (Object)projectNameStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(projectCodeStr = paramJson.getString("projectCode")))) {
            if (projectCodeStr.contains(",")) {
                params.put("projectCode", new Parameter("in", (Object)projectCodeStr.split(",")));
            } else {
                params.put("projectCode", new Parameter("eq", (Object)projectCodeStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(supplementFlagStr = paramJson.getString("supplementFlag")))) {
            params.put("supplementFlag", new Parameter("eq", (Object)Integer.parseInt(supplementFlagStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)(mainContractIdStr = paramJson.getString("mainContractId")))) {
            params.put("mainContractId", new Parameter("eq", (Object)Integer.parseInt(mainContractIdStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)(mainContractNameStr = paramJson.getString("mainContractName")))) {
            params.put("mainContractName", new Parameter("eq", (Object)Integer.parseInt(mainContractNameStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)(mainContractCodeStr = paramJson.getString("mainContractCode")))) {
            params.put("mainContractCode", new Parameter("eq", (Object)Integer.parseInt(mainContractCodeStr)));
        }
        return queryParam;
    }

    @Override
    public BigDecimal queryContractionSubtractProTaxMny(Long projectId) {
        this.logger.info("contractbase---ContractPoolServiceImpl---queryContractionSubtractProTaxMny()---\u5165\u53c2-projectId={}", (Object)projectId);
        BigDecimal contractionTaxMny = BigDecimal.ZERO;
        BigDecimal proTaxMny = BigDecimal.ZERO;
        Long tenantid = InvocationInfoProxy.getTenantid();
        QueryWrapper cpWra = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)cpWra.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).eq((Object)"project_id", (Object)projectId)).eq((Object)"source_type", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode())).orderByDesc((Object)"create_time")).last("limit 1");
        cpWra.select(new String[]{"ifnull(contract_tax_mny, 0) as contractionTaxMny"});
        Map contractionMap = super.getMap((Wrapper)cpWra);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u4e0b\u6700\u65b0\u7684\u65bd\u5de5\u5408\u540c\u7684\u5408\u540c\u542b\u7a0e\u91d1\u989d\uff0c\u67e5\u8be2\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)contractionMap));
        if (MapUtils.isNotEmpty((Map)contractionMap)) {
            contractionTaxMny = contractionMap.get("contractionTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(contractionMap.get("contractionTaxMny").toString());
        }
        cpWra = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)cpWra.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).eq((Object)"project_id", (Object)projectId)).eq((Object)"source_type", (Object)ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
        cpWra.select(new String[]{"sum(ifnull(contract_tax_mny, 0)) as proTaxMny"});
        Map proMap = super.getMap((Wrapper)cpWra);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u9879\u76ee\u4e0b\u6240\u6709\u4e13\u4e1a\u5206\u5305\u5408\u540c\u7684\u5408\u540c\u542b\u7a0e\u91d1\u989d\u7684\u7d2f\u52a0\u503c\uff0c\u67e5\u8be2\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)proMap));
        if (MapUtils.isNotEmpty((Map)proMap)) {
            proTaxMny = proMap.get("proTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(proMap.get("proTaxMny").toString());
        }
        BigDecimal subtract = contractionTaxMny.subtract(proTaxMny);
        this.logger.info("contractbase---ContractPoolServiceImpl---queryContractionSubtractProTaxMny()---\u8fd4\u56de\u7ed3\u679c---\u5f53\u524d\u9879\u76ee\u4e0b(\u65bd\u5de5\u5408\u540c\u542b\u7a0e\u91d1\u989d - \u4e13\u4e1a\u5206\u5305\u5408\u540c\u542b\u7a0e\u91d1\u989d) = {}", (Object)JSONObject.toJSONString((Object)subtract));
        return subtract;
    }

    @Override
    public List<ContractPoolEntity> queryMdmPage(QueryParam param) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Parameter parameter = (Parameter)param.getParams().get("syncTime");
        if (parameter != null) {
            condition.put("syncTime", parameter.getValue());
        }
        if ((parameter = (Parameter)param.getParams().get("contractProperty")) != null) {
            condition.put("contractProperty", parameter.getValue());
        }
        condition.put("pageIndex", (param.getPageIndex() - 1) * 500);
        condition.put("pageSize", param.getPageSize());
        List<ContractPoolEntity> poolEntities = this.contractPoolMapper.queryMdmPage(condition);
        return poolEntities;
    }

    @Override
    public BigDecimal calcTotalMny(QueryParam param) {
        QueryWrapper wrapper = ContractPoolServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(contract_tax_mny) as totalMny"});
        Map result = super.getMap((Wrapper)wrapper);
        return null != result && null != result.get("totalMny") ? (BigDecimal)result.get("totalMny") : BigDecimal.ZERO;
    }
}

