/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.service.impl;

import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.CategoryRelationMapper;
import com.ejianc.business.contractbase.mapper.ClauseSettingMapper;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClauseSettingServiceImpl
extends BaseServiceImpl<ClauseSettingMapper, ClauseSettingEntity>
implements IClauseSettingService {
    @Autowired
    private ICategoryRelationService relationService;
    @Autowired
    private CategoryRelationMapper categoryRelationMapper;

    @Override
    public boolean checkCategory(Long categoryId) {
        boolean check = false;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter("eq", (Object)categoryId));
        List categoryRelationEntities = this.relationService.queryList(queryParam);
        if (!categoryRelationEntities.isEmpty()) {
            for (CategoryRelationEntity c : categoryRelationEntities) {
                ClauseSettingEntity clauseSettingEntity = (ClauseSettingEntity)((Object)this.selectById(c.getClauseId()));
                if (1 != clauseSettingEntity.getEnableStatus()) continue;
                check = true;
                break;
            }
        }
        return check;
    }

    @Override
    public void updateClauseByCategory(TemplateCategoryEntity templateCategoryEntity, Boolean insertFlag, String newCategoryName) {
        QueryParam queryParam = new QueryParam();
        if (insertFlag.booleanValue()) {
            queryParam.getParams().put("enable_type", new Parameter("eq", (Object)1));
        } else {
            queryParam.getParams().put("rangeIds", new Parameter("like", (Object)("%" + templateCategoryEntity.getId() + "%")));
        }
        List clauseList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)clauseList)) {
            for (ClauseSettingEntity clause : clauseList) {
                if (insertFlag.booleanValue()) {
                    clause.setRangeIds(clause.getRangeIds() + "," + templateCategoryEntity.getId());
                    clause.setRangeNames(clause.getRangeNames() + "," + templateCategoryEntity.getCategoryName());
                    continue;
                }
                if (null == newCategoryName || !StringUtils.isNotBlank((CharSequence)newCategoryName)) continue;
                String oldRangeNames = "," + clause.getRangeNames() + ",";
                oldRangeNames = oldRangeNames.replace("," + templateCategoryEntity.getCategoryName() + ",", "," + newCategoryName + ",");
                oldRangeNames = oldRangeNames.substring(1, oldRangeNames.length() - 1);
                clause.setRangeNames(oldRangeNames);
            }
            super.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        this.relationService.addRelationByCategory(templateCategoryEntity, clauseList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelationByClause(List<Long> ids) {
        super.removeByIds(ids, true);
        this.categoryRelationMapper.deleteRelationByClause(ids);
    }

    @Override
    public ClauseSettingVO updateStatus(ClauseSettingVO clauseSettingVO) {
        ClauseSettingEntity clauseSettingEntity = (ClauseSettingEntity)((Object)this.selectById(clauseSettingVO.getId()));
        if (null != clauseSettingVO.getEnableStatus()) {
            clauseSettingEntity.setEnableStatus(clauseSettingVO.getEnableStatus());
        }
        if (null != clauseSettingVO.getNecessaryStatus()) {
            clauseSettingEntity.setNecessaryStatus(clauseSettingVO.getNecessaryStatus());
        }
        this.saveOrUpdate((Object)clauseSettingEntity, false);
        return (ClauseSettingVO)BeanMapper.map((Object)((Object)clauseSettingEntity), ClauseSettingVO.class);
    }
}

