package com.ejianc.business.contractbase.disclose.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.contractbase.disclose.bean.ContractArchiveDetailFileEntity;
/**
 * 合同归档子实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_conbase_contract_archive_detail")
public class ContractArchiveDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_archive_id")
    private Long contractArchiveId; // 合同归档id
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="sign_date")
    private Date signDate; // 合同签订日期
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value="partyb_id")
    private Long partybId; // 乙方id
    @TableField(value="partyb_name")
    private String partybName; // 乙方
    @TableField(value="file_num")
    private Integer fileNum; // 文件数量
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="contractArchiveDetailFileService", pidName = "contractArchiveDetailId")
    private List<ContractArchiveDetailFileEntity> fileList = new ArrayList<>(); // 合同归档子实体附件实体
    

    public Long getContractArchiveId() {
        return contractArchiveId;
    }

    public void setContractArchiveId(Long contractArchiveId) {
        this.contractArchiveId = contractArchiveId;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Long getPartybId() {
        return partybId;
    }

    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }
    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }


    public Integer getFileNum() {
        return fileNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }

    public List<ContractArchiveDetailFileEntity> getFileList() {
        return fileList;
    }

    public void setFileList(List<ContractArchiveDetailFileEntity> fileList) {
        this.fileList = fileList;
    }
}
