package com.ejianc.business.contractbase.disclose.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.contractbase.disclose.bean.ContractArchiveDetailEntity;
/**
 * 合同归档
 * 
 * @author generator
 * 
 */
 @TableName("ejc_conbase_contract_archive")
public class ContractArchiveEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="transfer_date")
    private Date transferDate; // 移交日期
    @TableField(value="disclose_id")
    private Long discloseId; // 交底人
    @TableField(value="disclose_name")
    private String discloseName; // 交底人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="transfer_file_id")
    private Long transferFileId; // 移交档案接收人
    @TableField(value="transfer_file_name")
    private String transferFileName; // 移交档案接收人
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // orgName
    
    @TableField(exist=false)
    @SubEntity(serviceName="contractArchiveDetailService", pidName = "contractArchiveId")
    private List<ContractArchiveDetailEntity> detailList = new ArrayList<>(); // 合同归档子实体

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getTransferDate() {
        return transferDate;
    }

    public void setTransferDate(Date transferDate) {
        this.transferDate = transferDate;
    }
    public Long getDiscloseId() {
        return discloseId;
    }

    public void setDiscloseId(Long discloseId) {
        this.discloseId = discloseId;
    }
    public String getDiscloseName() {
        return discloseName;
    }

    public void setDiscloseName(String discloseName) {
        this.discloseName = discloseName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getTransferFileId() {
        return transferFileId;
    }

    public void setTransferFileId(Long transferFileId) {
        this.transferFileId = transferFileId;
    }
    public String getTransferFileName() {
        return transferFileName;
    }

    public void setTransferFileName(String transferFileName) {
        this.transferFileName = transferFileName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    public List<ContractArchiveDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractArchiveDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
