package com.ejianc.business.contractbase.filing.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.business.contractbase.filing.vo.FilingTypeVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.process.vo.TeamVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("filingType")
public class FilingTypeController {


    private static final String BILL_CODE = "FIL_TYP";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFilingTypeService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FilingTypeVO> saveOrUpdate(@RequestBody FilingTypeVO saveorUpdateVO) {
        FilingTypeEntity entity = BeanMapper.map(saveorUpdateVO, FilingTypeEntity.class);
        if (null == entity.getId()) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络错误 获取编码失败！");
            }
            entity.setBillCode(billCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
        }
        CommonResponse<MdReferVO> billTypeRes = billTypeApi.queryMetadataByBillType(entity.getSourceQueryBillType());
        if(!billTypeRes.isSuccess()) {
            throw new BusinessException("网络错误 获取元数据失败！");
        }
        String tableName = billTypeRes.getData().getTableName();
        String projectName = billTypeRes.getData().getProjectName();
        String databaseName = billTypeRes.getData().getDatabaseName();
        entity.setQueryDatabaseName(databaseName);
        entity.setQueryTableName(tableName);
        entity.setQueryProjectName(billTypeRes.getData().getProjectName());
        entity.setQueryUrl(BaseHost+projectName+"/queryPub/queryBillMap");
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("保存或修改单据成功!",BeanMapper.map(entity, FilingTypeVO.class));
    }


    /**
     * 查询逻辑
     * 全部查询 还是懒查询
     *
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("is_children",new Parameter(QueryParam.EQ,0));
        List<FilingTypeEntity> filingTypeEntities = service.queryList(param);
        List<FilingTypeVO> voList = BeanMapper.mapList(filingTypeEntities, FilingTypeVO.class);
        for (FilingTypeVO entity:voList){
            QueryParam childParam = new QueryParam();
            childParam.getParams().put("is_children",new Parameter(QueryParam.EQ,1));
            childParam.getParams().put("pid",new Parameter(QueryParam.EQ,entity.getId()));
            childParam.getParams().put("dr",new Parameter(QueryParam.EQ,0));
            List<FilingTypeEntity> childrenList = service.queryList(childParam);
            List<FilingTypeVO> voChildList = BeanMapper.mapList(childrenList, FilingTypeVO.class);
            if(CollectionUtil.isNotEmpty(voChildList)){
                for (FilingTypeVO vo:voChildList){
                    vo.setChildren(null);
                }
                entity.setChildren(voChildList);
            }else {
                entity.setChildren(null);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records",voList);
        return CommonResponse.success("查询成功！", jsonObject);
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FilingTypeVO> queryDetail(Long id) {
        FilingTypeEntity entity = service.selectById(id);
        FilingTypeVO vo = BeanMapper.map(entity, FilingTypeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FilingTypeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FilingTypeVO vo : vos) {
            }
        }
        service.removeByIds(vos.stream().map(FilingTypeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @param
     * @return 查询父级参照
     */
    @ResponseBody
    @RequestMapping(value = "queryFilingTypeTop",method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryFilingTypeTop(){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_children",new Parameter(QueryParam.EQ,0));
        List<FilingTypeEntity> filingTypeEntities = service.queryList(queryParam);
        List<FilingTypeVO> voList = BeanMapper.mapList(filingTypeEntities, FilingTypeVO.class);
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list =new ArrayList();
        voList.forEach( vo->{
            JSONObject o = (JSONObject) JSONObject.toJSON(vo);
            o.put("text",vo.getFilingTypeName());
            o.put("value",vo.getId());
            list.add(o);
        });
        jsonObject.put("data",list);
        return CommonResponse.success("查询数据成功！",jsonObject);
    }




    /**
     * @param
     * @return 查询父级参照
     */
    @ResponseBody
    @RequestMapping(value = "queryFilingByType",method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryFilingByType(String innerCode){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_children",new Parameter(QueryParam.EQ,1));
        queryParam.getParams().put("inner_code",new Parameter(QueryParam.EQ,innerCode));

        List<FilingTypeEntity> filingTypeEntities = service.queryList(queryParam);
        List<FilingTypeVO> voList = BeanMapper.mapList(filingTypeEntities, FilingTypeVO.class);
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list =new ArrayList();
        voList.forEach( vo->{
            JSONObject o = (JSONObject) JSONObject.toJSON(vo);
            o.put("text",vo.getFilingTypeName());
            o.put("value",vo.getId());
            list.add(o);
        });
        jsonObject.put("data",list);
        return CommonResponse.success("查询数据成功！",jsonObject);
    }



}
