package com.ejianc.business.contractbase.service.impl;

import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.mapper.TemplateVersionMapper;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author:刘家乐
 * @version: 1
 *  @document:
 */
@Service
public class TemplateVersionServiceImpl
        extends BaseServiceImpl<TemplateVersionMapper, TemplateVersionEntity>
        implements ITemplateVersionService {

    @Autowired
    private ITemplateService templateService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public TemplateVersionVO newTemplateVersion(TemplateVersionVO templateVersionVO) {
        TemplateEntity templateEntity = templateService.selectById(templateVersionVO.getTemplateId());

        TemplateVersionEntity tee = BeanMapper.map(templateVersionVO, TemplateVersionEntity.class);
        tee.setCategoryName(templateEntity.getCategoryName());
        tee.setCategoryId(templateEntity.getCategoryId());
        tee.setTenantId(templateEntity.getTenantId());
        tee.setTemplateName(templateEntity.getTemplateName());
        tee.setBillTypeCode(templateEntity.getBillTypeCode());
        tee.setMetadata(templateEntity.getMetadata());
        super.saveOrUpdate(tee, false);
        //更新模板信息
        templateEntity.setFileId(tee.getFileId());
        templateEntity.setFilePath(tee.getFilePath());
        templateEntity.setFileName(tee.getFileName());
        templateEntity.setFileSize(tee.getFileSize());
        templateEntity.setFileType(tee.getFileType());
        templateEntity.setCurVersionId(tee.getId());
        templateEntity.setCurVersion(tee.getTemplateVersion());
        templateService.saveOrUpdate(templateEntity, false);

        return BeanMapper.map(tee, TemplateVersionVO.class);
    }


    @Override
    public TemplateVersionEntity createVersion(TemplateEntity entity) {
        TemplateVersionEntity map = BeanMapper.map(entity, TemplateVersionEntity.class);
        map.setTemplateId(entity.getId());
        //如何设置版本号 版本号设置为id\
        map.setTemplateVersion(1L);
        map.setId(null);
        this.saveOrUpdate(map);
        return map;
    }

    @Override
    public TemplateVersionEntity updateVersion(TemplateEntity entity){
        TemplateVersionEntity versionEntity = this.selectById(entity.getCurVersionId());
        versionEntity.setFileSize(entity.getFileSize());
        versionEntity.setOnlinePath(entity.getOnlinePath());
        versionEntity.setFileName(entity.getFileName());
        versionEntity.setTemplateName(entity.getTemplateName());
        versionEntity.setFileType(entity.getFileType());
        versionEntity.setCategoryName(entity.getCategoryName());
        versionEntity.setCategoryId(entity.getCategoryId());
        versionEntity.setFileId(entity.getFileId());
        versionEntity.setMetadata(entity.getMetadata());
        this.saveOrUpdate(versionEntity);
        return versionEntity;
    }
}
