package com.ejianc.business.contractbase.pool.contractpool.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 合同池主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_conbase_contract_pool")
public class ContractPoolEntity extends BaseEntity {

    private static final long serialVersionUID = 4399720202282991640L;

    @TableField(value="handle_type")
    private Integer handleType;// 是否手动新增：1-是，0-否
    @TableField(value="contract_id")
    private Long contractId; // 合同Id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="category_id")
    private Long categoryId; // 合同分类Id
    @TableField(value="category_name")
    private String categoryName; // 合同分类名称
    @TableField(value="category_property")
    private String categoryProperty; // 合同分类属性
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同Id
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 项目id
    @TableField(value="org_name")
    private String orgName; // 项目名称
    @TableField(value="org_code")
    private String orgCode; // 项目编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="partya_id")
    private Long partyaId; // 合同甲方Id
    @TableField(value="partya_name")
    private String partyaName; // 合同甲方名称
    @TableField(value="partyb_id")
    private Long partybId; // 合同乙方Id
    @TableField(value="partyb_name")
    private String partybName; // 合同乙方名称
    @TableField(value="partyc_id")
    private Long partycId; // 合同丙方Id
    @TableField(value="partyc_name")
    private String partycName; // 合同丙方名称
    @TableField(value="join_party_id")
    private Long joinPartyId; // 联合体方Id
    @TableField(value="join_party_name")
    private String joinPartyName; // 联合体方名称
    @TableField(value="sign_date")
    private Date signDate; // 签订日期
    @TableField(value="sign_place")
    private String signPlace; // 签订地点
    /**
     * 工程地点
     */
    @TableField("project_address")
    private String projectAddress;
    @TableField(value="pricing_type")
    private String pricingType; // 计价方式：可调单价、固定总价、成本加酬金、费率合同、固定单价
    @TableField("pricing_type_id")
    private Long pricingTypeId;// 计价方式：可调单价、固定总价、成本加酬金、费率合同、固定单价
    @TableField(value="tax_calc_type_name")
    private String taxCalcTypeName; // 计税方式名称:简易计税、一般计税
    @TableField(value="contract_start_date")
    private Date contractStartDate; // 合同开工日期
    @TableField(value="contract_finish_date")
    private Date contractFinishDate; // 合同竣工日期
    @TableField(value="contract_days_limit")
    private Integer contractDaysLimit; // 合同工期:合同工期=同竣工日期-开工日期+1（单位：天）
    @TableField(value="purchase_type")
    private Integer purchaseType; // 采购类型: 1-自采，2-集采
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="base_tax_mny")
    private BigDecimal baseTaxMny; // 合同签订(合同初始)金额（含税）
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 合同签订(合同初始)金额（不含税）
    @TableField(value="base_tax")
    private BigDecimal baseTax; // 合同签订(合同初始)税额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同总金额（含税）
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同总金额（不含税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="total_change_tax_mny")
    private BigDecimal totalChangeTaxMny; // 合同累计变更金额（含税）
    @TableField(value="total_change_mny")
    private BigDecimal totalChangeMny; // 合同累计变更金额（不含税）
    @TableField(value="total_change_tax")
    private BigDecimal totalChangeTax; // 合同累计变更金额税额
    @TableField(value="taotal_change_scale")
    private BigDecimal taotalChangeScale; // 合同累计变更比例
    @TableField(value="total_should_in_out_tax_mny")
    private BigDecimal totalShouldInOutTaxMny; // 累计应收/应付金额（含税）
    @TableField(value="total_should_in_out_mny")
    private BigDecimal totalShouldInOutMny; // 累计应收/应付金额（不含税）
    @TableField(value="total_should_in_out_tax")
    private BigDecimal totalShouldInOutTax; // 累计应收/应付税额
    @TableField(value="total_payment_apply_tax_mny")
    private BigDecimal totalPaymentApplyTaxMny; // 累计付款申请金额（含税）
    @TableField(value="total_payment_apply_mny")
    private BigDecimal totalPaymentApplyMny; // 累计付款申请金额（不含税）
    @TableField(value="total_payment_apply_tax")
    private BigDecimal totalPaymentApplyTax; // 累计付款申请金额税额
    @TableField(value="total_open_invoice_apply_tax_mny")
    private BigDecimal totalOpenInvoiceApplyTaxMny; // 累计开票申请金额（含税）
    @TableField(value="total_open_invoice_apply_mny")
    private BigDecimal totalOpenInvoiceApplyMny; // 累计开票申请金额（不含税）
    @TableField(value="total_open_invoice_apply_tax")
    private BigDecimal totalOpenInvoiceApplyTax; // 累计开票申请金额税额
    @TableField(value="total_open_rec_invoice_tax_mny")
    private BigDecimal totalOpenRecInvoiceTaxMny; // 累计开/收票金额（含税）
    @TableField(value="total_open_rec_invoice_mny")
    private BigDecimal totalOpenRecInvoiceMny; // 累计开/收票金额（不含税）
    @TableField(value="total_open_rec_invoice_tax")
    private BigDecimal totalOpenRecInvoiceTax; // 累计开/收票金额税额
    @TableField(value="total_actual_pay_rec_tax_mny")
    private BigDecimal totalActualPayRecTaxMny; // 累计实收/付金额（含税）
    @TableField(value="total_actual_pay_rec_mny")
    private BigDecimal totalActualPayRecMny; // 累计实收/付金额（不含税）
    @TableField(value="total_actual_pay_rec_tax")
    private BigDecimal totalActualPayRecTax; // 累计实收/付金额税额
    @TableField(value="total_settle_devide_pay_rec_scale")
    private BigDecimal totalSettleDevidePayRecScale; // 累计结算/收付款比例
    @TableField(value="contract_tax_mny_devide_pay_rec_scale")
    private BigDecimal contractTaxMnyDevidePayRecScale; // 合同金额/收付款比例
    @TableField(value="total_invoice_tax_mny_devide_pay_rec_scale")
    private BigDecimal totalInvoiceTaxMnyDevidePayRecScale; // 累计发票金额/收付款比例
    @TableField(value="source_id")
    private Long sourceId; // 来源业务单据Id

    public Long getPricingTypeId() {
        return pricingTypeId;
    }

    public void setPricingTypeId(Long pricingTypeId) {
        this.pricingTypeId = pricingTypeId;
    }

    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    /**
     * 合同属性：1-收入，0支出
     */
    @TableField(value = "contract_property")
    private Integer contractProperty;

    /**
     * 来源单业务单据类型：
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 来源业务单据类型名称
     */
    @TableField(value = "source_type_name")
    private String sourceTypeName;

    /**
     * 单据PC端详情路由地址
     */
    @TableField(value = "pc_card_url")
    private String pcCardUrl;

    /**
     * 单据移动端详情路由地址
     */
    @TableField(value = "mobile_card_url")
    private String mobileCardUrl;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    @TableField(value = "performance_status")
    private String performanceStatus;

    /**
     * 经办人Id
     */
    @TableField(value = "employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField(value = "employee_name")
    private String employeeName;

    /**
     * 经办人电话
     */
    @TableField(value = "employee_phone")
    private String employeePhone;

    /**
     * 经办部门id
     */
    @TableField(value = "department_id")
    private Long departmentId;

    /**
     * 经办部门名称
     */
    @TableField(value = "department_name")
    private String departmentName;

    @TableField(exist=false)
    @SubEntity(serviceName="contractSubPaymentNodeService")
    private List<ContractSubPaymentNodeEntity> contractSubPaymentNodeList = new ArrayList<>(); // 合同付款节点子实体

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 1、郑州一建的算法是：如果是专业分包合同和劳务分包合同，应该取【节点结算】的“本次结算金额”和【竣工结算】“结算差额”
     * 2、云南建投的算法是：如果是专业分包合同和劳务分包合同，应该取【月度结算】的“本次结算金额”和【竣工结算】“结算差额”
     * 3、其他合同取合同下所结算单结本次算金额总和
     *
     * 合同累计结算金额(含税)
     */
    @TableField(value = "total_settle_tax_mny")
    private BigDecimal totalSettleTaxMny;

    /**
     * 合同累计结算金额(无税)
     */
    @TableField(value = "total_settle_mny")
    private BigDecimal totalSettleMny;

    /**
     * 合同累计结算税额
     */
    @TableField(value = "total_settle_tax")
    private BigDecimal totalSettleTax;

    /**
     * 数据来源：1-业务系统数据推送，2-手工录入
     */
    @TableField(value = "add_type")
    private Integer addType;

    @TableField(value="supplier_project_manager_id")
    private Long supplierProjectManagerId;// 乙方项目经理id
    /**
     * 乙方负责人/乙方项目经理名称
     */
    @TableField("supplier_project_manager_name")
    private String supplierProjectManagerName;

    /**
     * 乙方负责人/乙方项目经理联系电话
     */
    @TableField("supplier_project_manager_link")
    private String supplierProjectManagerLink;

    /**
     * 完工结算单生效日期
     */
    @TableField(value = "finish_settle_date")
    private Date finishSettleDate;

    /**
     * 二次经营申请金额含税
     */
    @TableField(value = "total_claim_tax_mny")
    private BigDecimal totalClaimTaxMny;

    /**
     * 二次经营申请金额无税
     */
    @TableField(value = "total_claim_mny")
    private BigDecimal totalClaimMny;

    /**
     * 二次经营申请金额税额
     */
    @TableField(value = "total_claim_tax")
    private BigDecimal totalClaimTax;

    /**
     * 二次经营批复金额含税
     */
    @TableField(value = "total_reply_tax_mny")
    private BigDecimal totalTeplyTaxMny;

    /**
     * 二次经营批复金额无税
     */
    @TableField(value = "total_reply_mny")
    private BigDecimal totalTeplyMny;

    /**
     * 二次经营批复金额税额
     */
    @TableField(value = "total_reply_tax")
    private BigDecimal totalTeplyTax;

    @TableField(value = "is_estimation")
    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    @TableField(value = "provisional_mny")
    private BigDecimal provisionalMny; // 暂列金额
    @TableField(value = "not_include_provisional_mny")
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)
    @TableField(value = "total_cost_adjust_tax_mny")
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    @TableField(value = "total_cost_adjust_mny")
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    @TableField(value = "total_cost_adjust_tax")
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额

    @TableField(value = "filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否
    @TableField(value = "filing_ref")
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否
    @TableField(value="estimation_tax_mny")
    private BigDecimal estimationTaxMny; // 含税暂估金额
    @TableField(value="area_name")
    private String areaName; // 所在地区
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="engineering_type")
    private String engineeringType; // 工程类别

    @TableField(exist = false)
    private BigDecimal signTaxMny; // 签订金额
    @TableField(exist = false)
    private Integer signNum; // 签订数量
    @TableField(value="cw_project_code")
    private String cwProjectCode;// 财务账套编号
    @TableField(value="purchase_method")
    private Integer purchaseMethod;// 采购方式（1：直采2：代采）


    public Integer getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(Integer purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getCwProjectCode() {
        return cwProjectCode;
    }

    public void setCwProjectCode(String cwProjectCode) {
        this.cwProjectCode = cwProjectCode;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public BigDecimal getTotalClaimTaxMny() {
        return totalClaimTaxMny;
    }

    public void setTotalClaimTaxMny(BigDecimal totalClaimTaxMny) {
        this.totalClaimTaxMny = totalClaimTaxMny;
    }

    public BigDecimal getTotalClaimMny() {
        return totalClaimMny;
    }

    public void setTotalClaimMny(BigDecimal totalClaimMny) {
        this.totalClaimMny = totalClaimMny;
    }

    public BigDecimal getTotalClaimTax() {
        return totalClaimTax;
    }

    public void setTotalClaimTax(BigDecimal totalClaimTax) {
        this.totalClaimTax = totalClaimTax;
    }

    public BigDecimal getTotalTeplyTaxMny() {
        return totalTeplyTaxMny;
    }

    public void setTotalTeplyTaxMny(BigDecimal totalTeplyTaxMny) {
        this.totalTeplyTaxMny = totalTeplyTaxMny;
    }

    public BigDecimal getTotalTeplyMny() {
        return totalTeplyMny;
    }

    public void setTotalTeplyMny(BigDecimal totalTeplyMny) {
        this.totalTeplyMny = totalTeplyMny;
    }

    public BigDecimal getTotalTeplyTax() {
        return totalTeplyTax;
    }

    public void setTotalTeplyTax(BigDecimal totalTeplyTax) {
        this.totalTeplyTax = totalTeplyTax;
    }

    public Date getFinishSettleDate() {
        return finishSettleDate;
    }

    public void setFinishSettleDate(Date finishSettleDate) {
        this.finishSettleDate = finishSettleDate;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getPcCardUrl() {
        return pcCardUrl;
    }

    public void setPcCardUrl(String pcCardUrl) {
        this.pcCardUrl = pcCardUrl;
    }

    public String getMobileCardUrl() {
        return mobileCardUrl;
    }

    public void setMobileCardUrl(String mobileCardUrl) {
        this.mobileCardUrl = mobileCardUrl;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getCategoryProperty() {
        return categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getPartyaId() {
        return partyaId;
    }

    public void setPartyaId(Long partyaId) {
        this.partyaId = partyaId;
    }
    public String getPartyaName() {
        return partyaName;
    }

    public void setPartyaName(String partyaName) {
        this.partyaName = partyaName;
    }
    public Long getPartybId() {
        return partybId;
    }

    public void setPartybId(Long partybId) {
        this.partybId = partybId;
    }
    public String getPartybName() {
        return partybName;
    }

    public void setPartybName(String partybName) {
        this.partybName = partybName;
    }
    public Long getPartycId() {
        return partycId;
    }

    public void setPartycId(Long partycId) {
        this.partycId = partycId;
    }
    public String getPartycName() {
        return partycName;
    }

    public void setPartycName(String partycName) {
        this.partycName = partycName;
    }
    public Long getJoinPartyId() {
        return joinPartyId;
    }

    public void setJoinPartyId(Long joinPartyId) {
        this.joinPartyId = joinPartyId;
    }
    public String getJoinPartyName() {
        return joinPartyName;
    }

    public void setJoinPartyName(String joinPartyName) {
        this.joinPartyName = joinPartyName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    public String getTaxCalcTypeName() {
        return taxCalcTypeName;
    }

    public void setTaxCalcTypeName(String taxCalcTypeName) {
        this.taxCalcTypeName = taxCalcTypeName;
    }
    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }
    public Date getContractFinishDate() {
        return contractFinishDate;
    }

    public void setContractFinishDate(Date contractFinishDate) {
        this.contractFinishDate = contractFinishDate;
    }
    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTotalChangeTaxMny() {
        return totalChangeTaxMny;
    }

    public void setTotalChangeTaxMny(BigDecimal totalChangeTaxMny) {
        this.totalChangeTaxMny = totalChangeTaxMny;
    }
    public BigDecimal getTotalChangeMny() {
        return totalChangeMny;
    }

    public void setTotalChangeMny(BigDecimal totalChangeMny) {
        this.totalChangeMny = totalChangeMny;
    }
    public BigDecimal getTotalChangeTax() {
        return totalChangeTax;
    }

    public void setTotalChangeTax(BigDecimal totalChangeTax) {
        this.totalChangeTax = totalChangeTax;
    }
    public BigDecimal getTaotalChangeScale() {
        return taotalChangeScale;
    }

    public void setTaotalChangeScale(BigDecimal taotalChangeScale) {
        this.taotalChangeScale = taotalChangeScale;
    }
    public BigDecimal getTotalShouldInOutTaxMny() {
        return totalShouldInOutTaxMny;
    }

    public void setTotalShouldInOutTaxMny(BigDecimal totalShouldInOutTaxMny) {
        this.totalShouldInOutTaxMny = totalShouldInOutTaxMny;
    }
    public BigDecimal getTotalShouldInOutMny() {
        return totalShouldInOutMny;
    }

    public void setTotalShouldInOutMny(BigDecimal totalShouldInOutMny) {
        this.totalShouldInOutMny = totalShouldInOutMny;
    }
    public BigDecimal getTotalShouldInOutTax() {
        return totalShouldInOutTax;
    }

    public void setTotalShouldInOutTax(BigDecimal totalShouldInOutTax) {
        this.totalShouldInOutTax = totalShouldInOutTax;
    }
    public BigDecimal getTotalPaymentApplyTaxMny() {
        return totalPaymentApplyTaxMny;
    }

    public void setTotalPaymentApplyTaxMny(BigDecimal totalPaymentApplyTaxMny) {
        this.totalPaymentApplyTaxMny = totalPaymentApplyTaxMny;
    }
    public BigDecimal getTotalPaymentApplyMny() {
        return totalPaymentApplyMny;
    }

    public void setTotalPaymentApplyMny(BigDecimal totalPaymentApplyMny) {
        this.totalPaymentApplyMny = totalPaymentApplyMny;
    }
    public BigDecimal getTotalPaymentApplyTax() {
        return totalPaymentApplyTax;
    }

    public void setTotalPaymentApplyTax(BigDecimal totalPaymentApplyTax) {
        this.totalPaymentApplyTax = totalPaymentApplyTax;
    }
    public BigDecimal getTotalOpenInvoiceApplyTaxMny() {
        return totalOpenInvoiceApplyTaxMny;
    }

    public void setTotalOpenInvoiceApplyTaxMny(BigDecimal totalOpenInvoiceApplyTaxMny) {
        this.totalOpenInvoiceApplyTaxMny = totalOpenInvoiceApplyTaxMny;
    }
    public BigDecimal getTotalOpenInvoiceApplyMny() {
        return totalOpenInvoiceApplyMny;
    }

    public void setTotalOpenInvoiceApplyMny(BigDecimal totalOpenInvoiceApplyMny) {
        this.totalOpenInvoiceApplyMny = totalOpenInvoiceApplyMny;
    }
    public BigDecimal getTotalOpenRecInvoiceTaxMny() {
        return totalOpenRecInvoiceTaxMny;
    }

    public void setTotalOpenRecInvoiceTaxMny(BigDecimal totalOpenRecInvoiceTaxMny) {
        this.totalOpenRecInvoiceTaxMny = totalOpenRecInvoiceTaxMny;
    }
    public BigDecimal getTotalOpenRecInvoiceMny() {
        return totalOpenRecInvoiceMny;
    }

    public void setTotalOpenRecInvoiceMny(BigDecimal totalOpenRecInvoiceMny) {
        this.totalOpenRecInvoiceMny = totalOpenRecInvoiceMny;
    }
    public BigDecimal getTotalOpenRecInvoiceTax() {
        return totalOpenRecInvoiceTax;
    }

    public void setTotalOpenRecInvoiceTax(BigDecimal totalOpenRecInvoiceTax) {
        this.totalOpenRecInvoiceTax = totalOpenRecInvoiceTax;
    }
    public BigDecimal getTotalActualPayRecTaxMny() {
        return totalActualPayRecTaxMny;
    }

    public void setTotalActualPayRecTaxMny(BigDecimal totalActualPayRecTaxMny) {
        this.totalActualPayRecTaxMny = totalActualPayRecTaxMny;
    }

    public BigDecimal getTotalOpenInvoiceApplyTax() {
        return totalOpenInvoiceApplyTax;
    }

    public void setTotalOpenInvoiceApplyTax(BigDecimal totalOpenInvoiceApplyTax) {
        this.totalOpenInvoiceApplyTax = totalOpenInvoiceApplyTax;
    }

    public BigDecimal getTotalActualPayRecMny() {
        return totalActualPayRecMny;
    }

    public void setTotalActualPayRecMny(BigDecimal totalActualPayRecMny) {
        this.totalActualPayRecMny = totalActualPayRecMny;
    }

    public BigDecimal getTotalActualPayRecTax() {
        return totalActualPayRecTax;
    }

    public void setTotalActualPayRecTax(BigDecimal totalActualPayRecTax) {
        this.totalActualPayRecTax = totalActualPayRecTax;
    }

    public BigDecimal getTotalSettleDevidePayRecScale() {
        return totalSettleDevidePayRecScale;
    }

    public void setTotalSettleDevidePayRecScale(BigDecimal totalSettleDevidePayRecScale) {
        this.totalSettleDevidePayRecScale = totalSettleDevidePayRecScale;
    }
    public BigDecimal getContractTaxMnyDevidePayRecScale() {
        return contractTaxMnyDevidePayRecScale;
    }

    public void setContractTaxMnyDevidePayRecScale(BigDecimal contractTaxMnyDevidePayRecScale) {
        this.contractTaxMnyDevidePayRecScale = contractTaxMnyDevidePayRecScale;
    }
    public BigDecimal getTotalInvoiceTaxMnyDevidePayRecScale() {
        return totalInvoiceTaxMnyDevidePayRecScale;
    }

    public void setTotalInvoiceTaxMnyDevidePayRecScale(BigDecimal totalInvoiceTaxMnyDevidePayRecScale) {
        this.totalInvoiceTaxMnyDevidePayRecScale = totalInvoiceTaxMnyDevidePayRecScale;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    

    public List<ContractSubPaymentNodeEntity> getContractSubPaymentNodeList() {
        return contractSubPaymentNodeList;
    }

    public void setContractSubPaymentNodeList(List<ContractSubPaymentNodeEntity> contractSubPaymentNodeList) {
        this.contractSubPaymentNodeList = contractSubPaymentNodeList;
    }

    public Integer getContractProperty() {
        return contractProperty;
    }

    public void setContractProperty(Integer contractProperty) {
        this.contractProperty = contractProperty;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }


    public BigDecimal getEstimationTaxMny() {
        return estimationTaxMny;
    }

    public void setEstimationTaxMny(BigDecimal estimationTaxMny) {
        this.estimationTaxMny = estimationTaxMny;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(String engineeringType) {
        this.engineeringType = engineeringType;
    }

    public BigDecimal getSignTaxMny() {
        return signTaxMny;
    }

    public void setSignTaxMny(BigDecimal signTaxMny) {
        this.signTaxMny = signTaxMny;
    }

    public Integer getSignNum() {
        return signNum;
    }

    public void setSignNum(Integer signNum) {
        this.signNum = signNum;
    }
}
