package com.ejianc.business.contractbase.pool.contractpool.mapper;

import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 合同池主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractPoolMapper extends BaseCrudMapper<ContractPoolEntity> {

    void deleteBySourceId(@Param(value = "sourceId") Long sourceId);

    List<ContractDTO> queryContractList(SupplyVO vo);

    List<ContractDTO> getContractListByHeadUser(HeadUserVO vo);

    List<SubUnitTopVO> queryContractionSubUnitTopN(@Param("sourceType") String sourceType
            , @Param("year") String year, @Param("beginQuarterDate") String beginQuarterDate, @Param("endQuarterDate") String endQuarterDate
            , @Param("month") String month, @Param("ordIdsList") List<Long> ordIdsList);

    List<SupplierVO> queryContractInfo(@Param("suplyId") Long suplyId, @Param("orgIds") List<Long> orgIds
            , @Param("orderName") String orderName, @Param("orderValue") String orderValue
            , @Param("personal") String personal,@Param("grade_id") String grade_id,@Param("supply_type") List<String> supply_type
            , @Param("punish_type") String punish_type, @Param("searchText") String searchText
            , @Param("searchTexts") List<String> searchTexts,@Param("pageIndex") Long pageIndex,@Param("pageSize") Long pageSize);

    Long queryCount(@Param("suplyId") Long suplyId, @Param("orgIds") List<Long> orgIds
            , @Param("orderName") String orderName, @Param("orderValue") String orderValue
            , @Param("personal") String personal,@Param("grade_id") String grade_id,@Param("supply_type") List<String> supply_type
            , @Param("punish_type") String punish_type, @Param("searchText") String searchText
            , @Param("searchTexts") List<String> searchTexts);

    List<Long> getSupplierIds(@Param("orgIds") List<Long> orgIds);

    List<ContractPoolEntity> queryMdmPage(Map<String, Object> condition);

    List<Map<String, Object>> getProjectAreaContractMny(@Param("paramMap") Map<String, Object> param);

    List<Map<String, Object>> getMolecularUnitRange(@Param("paramMap") Map<String, Object> param);

    /**
     * 查询项目的设备合同金额
     */
    BigDecimal queryEquipmentContractMnyByProjectId(@Param("projectId") Long projectId);

    /**
     * 查询项目的设备合同金额
     */
    BigDecimal queryMaterialContractMnyByProjectId(@Param("projectId") Long projectId);

    /**
     * 查询项目的设备合同金额
     */
    BigDecimal queryProsubContractMnyByProjectId(@Param("projectId") Long projectId);

    /**
     * 查询项目的设备合同金额
     */
    BigDecimal queryLabsubContractMnyByProjectId(@Param("projectId") Long projectId);

    /**
     * 查询本年已签合同的供应商个数
     */
    Integer queryContractionSupplierNum();
}
