package com.ejianc.business.contractbase.service.impl;

import com.ejianc.business.contractbase.entity.TemplDetailExportSettingEntity;
import com.ejianc.business.contractbase.mapper.TemplDetailExportSettingMapper;
import com.ejianc.business.contractbase.service.ITemplDetailExportSettingService;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/8 10:54
 */
@Service(value = "templDetailExportSettingService")
public class TemplDetailExportSettingServiceImpl extends BaseServiceImpl<TemplDetailExportSettingMapper, TemplDetailExportSettingEntity> implements ITemplDetailExportSettingService {

    @Autowired
    private TemplDetailExportSettingMapper templDetailExportSettingMapper;

    @Override
    public void saveOrUpdateVos(List<TemplDetailExportSettingVO> vos) {
        for(TemplDetailExportSettingVO vo : vos) {
            super.saveOrUpdate(BeanMapper.map(vo, TemplDetailExportSettingEntity.class));
        }
    }

    @Override
    public List<TemplDetailExportSettingEntity> findExportDetailByCategoryId(Long categoryId, Long parentCategoryId) {
        return templDetailExportSettingMapper.findExportDetailByCategoryId(categoryId, parentCategoryId);
    }

    @Override
    public Map<String, String> getTemplExportMode(List<Long> templIdList) {
        Map<String, String> result = new HashMap<>();
        List<Map<Long, String>> rs = templDetailExportSettingMapper.getTemplExportMode(templIdList);
        for(Map<Long, String> map : rs) {
            result.put(String.valueOf(map.get("id")), map.get("exportMode").toString());
        }
        return result;
    }

    @Override
    public void delByTemplateId(Long templateId) {
        templDetailExportSettingMapper.delByTemplateId(templateId);
    }
}
