package com.ejianc.business.contractbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.TemplateCategoryMapper;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */
@Service
public class TemplateCategoryServiceImpl
        extends BaseServiceImpl<TemplateCategoryMapper, TemplateCategoryEntity>
        implements ITemplateCategoryService {


    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IClauseSettingService clauseSettingService;
    @Autowired
    private ICategoryRelationService categoryRelationService;
    @Autowired
    private ITemplateCategoryService templateCategoryService;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public CommonResponse<List<TemplateCategoryVO>> queryTree() {
        QueryParam param = new QueryParam();
        param.getParams().put("is_top",new Parameter("eq","0"));
        param.getParams().put("sequence",new Parameter("desc",""));
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<TemplateCategoryEntity> ejcConbaseContractTemplateCategoryEntities = this.queryList(param, false);
        List<TemplateCategoryVO> categoryVos = BeanMapper.mapList(ejcConbaseContractTemplateCategoryEntities, TemplateCategoryVO.class);
        List<TemplateCategoryVO> ejcConbaseContractTemplateCategoryVoList =new  ArrayList();
        for (TemplateCategoryVO e:categoryVos){
            QueryParam queryParam = new QueryParam();
            //这里没有启用 就不展示
            queryParam.getParams().put("pid",new Parameter("eq",e.getId()));
            queryParam.getParams().put("enable_status",new Parameter("eq","1"));
            List<TemplateCategoryEntity> entityLists = this.queryList(queryParam);
            List<TemplateCategoryVO> categoryVoList =
                    BeanMapper.mapList(entityLists, TemplateCategoryVO.class);
            e.setChildren(categoryVoList);
        }
        return CommonResponse.success(categoryVos);
    }
    @Override
    public CommonResponse<IPage<TemplateCategoryVO>> getCategoryParent(QueryParam param) {
        param.getParams().put("is_top",new Parameter("eq","0"));
        IPage<TemplateCategoryEntity> page = this.queryPage(param, false);
        List<TemplateCategoryVO> categoryVoList =
                BeanMapper.mapList(page.getRecords(), TemplateCategoryVO.class);
        IPage<TemplateCategoryVO> categoryVoPage = new Page<>();
        categoryVoPage.setCurrent(page.getCurrent());
        categoryVoPage.setRecords(categoryVoList);
        categoryVoPage.setSize(page.getSize());
        categoryVoPage.setTotal(page.getTotal());
        categoryVoPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", categoryVoPage);
    }

    @Override
    public boolean checkProperty(String categoryProperty){
        List<TemplateCategoryEntity> category = this.list(new QueryWrapper<TemplateCategoryEntity>().eq("category_property", categoryProperty).eq("tenant_id", InvocationInfoProxy.getTenantid()));
        return CollectionUtils.isEmpty(category);
    }


    @Override
    public CommonResponse<List<TemplateCategoryVO>> querySameLevel(String id){
        return querySameLevel(id, null);
    }

    /**
     * updateEnableStatus
     */
    @Override
    public CommonResponse<TemplateCategoryVO> updateEnableStatus(TemplateCategoryVO categoryVO){
        TemplateCategoryEntity templateCategoryEntity = this.selectById(categoryVO.getId());
        templateCategoryEntity.setEnableStatus(categoryVO.getEnableStatus());
        this.saveOrUpdate(templateCategoryEntity,false);
        TemplateCategoryVO map = BeanMapper.map(templateCategoryEntity, TemplateCategoryVO.class);
        return CommonResponse.success(map);
    }

    @Override
    public CommonResponse<String> deleteOrCheck(List<TemplateCategoryVO> vos) {
        //根据当前分类id查询 是否有模板
        //根据当前分类id查询 是否有条款
        this.removeByIds(vos.stream().map(TemplateCategoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 1.删除分类
     * 2.物理删除分类条款关系表 关于该分类的所有信息
     * 3.更新条款表中关于分类的信息
     * @param vos
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void removeRelationByCategory(List<TemplateCategoryVO> vos) {
        List<Long> categoryIds = vos.stream().map(TemplateCategoryVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(categoryIds)){
            //1.删除分类
            super.removeByIds(categoryIds,true);
            //2.物理删除分类条款相关信息
            categoryRelationService.deleteRelationByCategory(categoryIds);
            //3.更新条款表中关于分类的信息
            //当前分类只有单个删除，所以外层循环只会进行一次
            for (TemplateCategoryVO category : vos) {
                TemplateCategoryEntity templateCategory = templateCategoryService.selectById(category.getId());
                String categoryName = null != templateCategory ? templateCategory.getCategoryName() : "";

                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("range_ids", new Parameter(QueryParam.LIKE, "%" + category.getId() + "%"));
                List<ClauseSettingEntity> clauseSettingList = clauseSettingService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(clauseSettingList)){
                    for (ClauseSettingEntity clauseSettingEntity : clauseSettingList) {
                        //将所有包含该分类的条款的 分类id、名称字段 中的分类id、名称去掉
                        String oldRangeIds = "," + clauseSettingEntity.getRangeIds() + ",";
                        oldRangeIds = oldRangeIds.replace("," + category.getId() + ",", ",");
                        if (oldRangeIds.length() > 1){
                            oldRangeIds = oldRangeIds.substring(1, oldRangeIds.length() - 1);
                            clauseSettingEntity.setRangeIds(oldRangeIds);
                        }else {
                            clauseSettingEntity.setRangeIds(null);
                        }

                        if (StringUtils.isNotBlank(categoryName)){
                            String oldRangeNames = "," + clauseSettingEntity.getRangeNames() + ",";
                            oldRangeNames = oldRangeNames.replace("," + categoryName + ",", ",");
                            if (oldRangeNames.length() > 1){
                                oldRangeNames = oldRangeNames.substring(1, oldRangeNames.length() - 1);
                                clauseSettingEntity.setRangeNames(oldRangeNames);
                            }else {
                                clauseSettingEntity.setRangeNames(null);
                            }
                        }
                    }
                    clauseSettingService.saveOrUpdateBatch(clauseSettingList, clauseSettingList.size(), false);
                }
            }
        }
    }

    @Override
    public CommonResponse<List<TemplateCategoryVO>> querySameLevel(String categoryId, String range) {
        TemplateCategoryEntity templateCategoryEntity = this.selectById(categoryId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid",new Parameter("eq",templateCategoryEntity.getPid()));
        queryParam.getParams().put("enable_status",new Parameter("eq",1));

        if(StringUtils.isNotBlank(range)) {
            switch (range) {
                case "selfOrg":
                    //本级
                    queryParam.getParams().put("belong_org_id",new Parameter("eq",InvocationInfoProxy.getOrgId()));
                    break;
                case "selfAndBelow":
                    //本下
                    if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                        queryParam.getParams().put("belong_org_id",new Parameter("eq",InvocationInfoProxy.getOrgId()));
                    } else {
                        CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                        if(!orgVOListResp.isSuccess()) {
                            throw new BusinessException("查询失败，获取组织信息失败！");
                        }
                        queryParam.getParams().put("belong_org_id",new Parameter("in", orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                    }
                    break;
                case "parents":
                    //父级
                    CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                    if(!orgVOListResp.isSuccess()) {
                        throw new BusinessException("查询失败，获取组织信息失败！");
                    }
                    queryParam.getParams().put("belong_org_id",new Parameter("in", orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                    break;
                default: ;
            }
        }

        List<TemplateCategoryEntity> categoryEntityList = this.queryList(queryParam);
        List<TemplateCategoryVO> categoryVOList = BeanMapper.mapList(categoryEntityList, TemplateCategoryVO.class);
        return CommonResponse.success(categoryVOList);
    }

    @Override
    public TemplateCategoryEntity getOneByTemplateId(Long templateId) {
        return templateCategoryMapper.getOneByTemplateId(templateId);
    }


}
