/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.cooperative.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.cooperative.bean.CooperativeCollectEntity;
import com.ejianc.business.contractbase.cooperative.service.ICooperativeCollectService;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeCollectVO;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeRatioVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"cooperativeCollect"})
public class CooperativeCollectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICooperativeCollectService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CooperativeCollectVO> saveOrUpdate(@RequestBody CooperativeCollectVO saveOrUpdateVO) {
        CooperativeCollectEntity entity = (CooperativeCollectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CooperativeCollectEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CooperativeCollectVO vo = (CooperativeCollectVO)BeanMapper.map((Object)((Object)entity), CooperativeCollectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CooperativeCollectVO> queryDetail(Long id) {
        CooperativeCollectEntity entity = (CooperativeCollectEntity)((Object)this.service.selectById(id));
        CooperativeCollectVO vo = (CooperativeCollectVO)BeanMapper.map((Object)((Object)entity), CooperativeCollectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CooperativeCollectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CooperativeCollectVO cooperativeCollectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CooperativeCollectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CooperativeCollectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CooperativeCollect-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCooperativeCollectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CooperativeCollectVO>> refCooperativeCollectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CooperativeCollectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/initCooperativeCollect"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> initCooperativeCollect(HttpServletRequest request) {
        this.service.initCooperativeCollect();
        return CommonResponse.success((String)"\u534f\u540c\u7387\u6570\u636e\u521d\u59cb\u5316\u6210\u529f");
    }

    @RequestMapping(value={"/getProjectCooperativeRatio"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CooperativeRatioVO>> getProjectCooperativeRatio(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u534f\u540c\u7387\u6570\u636e\u6210\u529f\uff01", this.service.getProjectCooperativeRatio(param));
    }

    @RequestMapping(value={"/getSupplierCooperativeRatio"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CooperativeRatioVO>> getSupplierCooperativeRatio(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u534f\u540c\u7387\u6570\u636e\u6210\u529f\uff01", this.service.getSupplierCooperativeRatio(param));
    }

    @GetMapping(value={"/getCooperativeList"})
    public CommonResponse<List<JSONObject>> getCooperativeList(@RequestParam Long id, @RequestParam String groupField, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) Long orgId) {
        QueryParam queryParam = new QueryParam();
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        if ("projectId".equals(groupField)) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)id));
            queryParam.getOrderMap().put("projectId", "asc");
        } else {
            queryParam.getParams().put("supplierId", new Parameter("eq", (Object)id));
            queryParam.getOrderMap().put("supplierId", "asc");
        }
        queryParam.getParams().put("cooperativeFlag", new Parameter("eq", (Object)1));
        if (null != startDate && StringUtils.isNotBlank((CharSequence)startDate) && null != endDate && StringUtils.isNotBlank((CharSequence)endDate)) {
            queryParam.getParams().put("billCreateDate", new Parameter("between", (Object)(startDate + "," + endDate)));
        }
        List dataList = BeanMapper.mapList((Iterable)this.service.queryList(queryParam), CooperativeCollectVO.class);
        this.logger.info("groupId-{}, groupFields-{},\u67e5\u8be2\u51fa\u534f\u540c\u5217\u8868\u6570\u636e:{}\u6761", new Object[]{id, groupField, dataList.size()});
        Map<String, List<CooperativeCollectVO>> groupData = dataList.stream().collect(Collectors.groupingBy(item -> ("projectId".equals(groupField) ? item.getSupplierId().toString() : item.getProjectId().toString()) + item.getBillTypeName()));
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        JSONObject tmp = null;
        CooperativeCollectVO cooperativeCollectVO = null;
        for (String key : groupData.keySet()) {
            tmp = new JSONObject();
            cooperativeCollectVO = groupData.get(key).get(0);
            tmp.put("billType", (Object)cooperativeCollectVO.getBillTypeName());
            tmp.put("supplierName", (Object)cooperativeCollectVO.getSupplierName());
            tmp.put("projectName", (Object)cooperativeCollectVO.getProjectName());
            tmp.put("ratioBillNum", (Object)groupData.get(key).size());
            tmp.put("list", groupData.get(key));
            resp.add(tmp);
        }
        resp.sort(Comparator.comparing(obj -> obj.getString("ratioBillNum")));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }
}

