/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.report.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.service.ISubLeaderService;
import com.ejianc.business.contractbase.pool.contractpool.vo.SubLeaderReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subLeaderReport/"})
public class SubLeaderReportController {
    @Autowired
    private ISubLeaderService subLeaderService;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"queryList"})
    public CommonResponse<IPage<SubLeaderReportVO>> queryList(@RequestBody QueryParam queryParam) {
        Map pageParamMap;
        SubLeaderReportVO queryParams = new SubLeaderReportVO();
        queryParams.getSearchTexts().add("b.code");
        queryParams.getSearchTexts().add("c.name");
        queryParams.getSearchTexts().add("c.id_num");
        queryParams.getSearchTexts().add("b.material_content");
        queryParams.getSearchTexts().add("b.equipment_content");
        queryParams.getSearchTexts().add("b.major_content");
        queryParams.getSearchTexts().add("b.labor_content");
        queryParams.getSearchTexts().add("b.sub_content");
        queryParams.getSearchTexts().add("b.other_content");
        queryParams.getSearchTexts().add("b.revolv_material_content");
        queryParams.getSearchTexts().add("b.consult_content");
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            queryParams.setSearchText(queryParam.getSearchText());
        }
        if ((pageParamMap = queryParam.getParams()).containsKey("createTime")) {
            String[] dates = ((Parameter)pageParamMap.get("createTime")).getValue().toString().split(",");
            queryParams.setStartDate(dates[0]);
            queryParams.setEndDate(dates[1]);
        }
        if (pageParamMap.containsKey("grade")) {
            queryParams.setGrades(((Parameter)pageParamMap.get("grade")).getValue().toString().split(","));
        }
        queryParams.setOrderName("createTime");
        if (queryParam.getOrderMap().containsKey("createTime")) {
            queryParams.setOrderValue((String)queryParam.getOrderMap().get("createTime"));
        } else {
            queryParams.setOrderValue("desc");
        }
        queryParams.setPageSize(Integer.valueOf(queryParam.getPageSize()));
        Integer startLine = (queryParam.getPageIndex() - 1 < 0 ? 0 : queryParam.getPageIndex() - 1) * queryParam.getPageSize();
        queryParams.setStartLine(startLine);
        Page pageData = new Page();
        pageData.setSize((long)queryParam.getPageSize());
        if (InvocationInfoProxy.getOrgType().equals(OrgVO.ORG_TYPE_DEPARTMENT)) {
            queryParams.setOrgId(InvocationInfoProxy.getOrgId());
        } else {
            CommonResponse orgVOListResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgVOListResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            queryParams.setParentOrgId(((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        Long totalSubLeaders = this.subLeaderService.countSubLeader(queryParams);
        pageData.setTotal(totalSubLeaders.longValue());
        pageData.setCurrent((long)queryParam.getPageIndex());
        if (totalSubLeaders > 0L) {
            List<SubLeaderReportVO> pageList = this.subLeaderService.pageList(queryParams);
            pageList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getSupplierContent()) && item.getSupplierContent().endsWith(",")) {
                    item.setSupplierContent(item.getSupplierContent().substring(0, item.getSupplierContent().length() - 1).replaceAll(",,", ","));
                }
            });
            pageData.setRecords(pageList);
        } else {
            pageData.setTotal(0L);
            pageData.setRecords(new ArrayList());
            pageData.setPages(0L);
        }
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        Map pageParamMap;
        HashMap beans = new HashMap();
        queryParam.setPageSize(-1);
        SubLeaderReportVO queryParams = new SubLeaderReportVO();
        queryParams.getSearchTexts().add("b.code");
        queryParams.getSearchTexts().add("c.name");
        queryParams.getSearchTexts().add("c.id_num");
        queryParams.getSearchTexts().add("b.material_content");
        queryParams.getSearchTexts().add("b.equipment_content");
        queryParams.getSearchTexts().add("b.major_content");
        queryParams.getSearchTexts().add("b.labor_content");
        queryParams.getSearchTexts().add("b.sub_content");
        queryParams.getSearchTexts().add("b.other_content");
        queryParams.getSearchTexts().add("b.revolv_material_content");
        queryParams.getSearchTexts().add("b.consult_content");
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            queryParams.setSearchText(queryParam.getSearchText());
        }
        if ((pageParamMap = queryParam.getParams()).containsKey("createTime")) {
            String[] dates = ((Parameter)pageParamMap.get("createTime")).toString().split(",");
            queryParams.setStartDate(dates[0]);
            queryParams.setStartDate(dates[1]);
        }
        queryParams.setOrderName("createTime");
        if (queryParam.getOrderMap().containsKey("createTime")) {
            queryParams.setOrderValue((String)queryParam.getOrderMap().get("createTime"));
        } else {
            queryParams.setOrderValue("desc");
        }
        Page pageData = new Page();
        pageData.setSize((long)queryParam.getPageSize());
        Long totalSubLeaders = this.subLeaderService.countSubLeader(queryParams);
        List<Object> vos = new ArrayList();
        if (totalSubLeaders > 0L) {
            vos = this.subLeaderService.pageList(queryParams);
            vos.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getSupplierContent()) && item.getSupplierContent().endsWith(",")) {
                    item.setSupplierContent(item.getSupplierContent().substring(0, item.getSupplierContent().length() - 1).replaceAll(",,", ","));
                }
            });
        }
        beans.put("records", vos);
        ExcelExport.getInstance().export("SubLeaderReport-export.xlsx", beans, response);
    }
}

