/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.TemplateCategoryMapper;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateCategoryServiceImpl
extends BaseServiceImpl<TemplateCategoryMapper, TemplateCategoryEntity>
implements ITemplateCategoryService {
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IClauseSettingService clauseSettingService;
    @Autowired
    private ICategoryRelationService categoryRelationService;
    @Autowired
    private ITemplateCategoryService templateCategoryService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<List<TemplateCategoryVO>> queryTree() {
        QueryParam param = new QueryParam();
        param.getParams().put("is_top", new Parameter("eq", (Object)"0"));
        param.getParams().put("sequence", new Parameter("desc", (Object)""));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List ejcConbaseContractTemplateCategoryEntities = this.queryList(param, false);
        List categoryVos = BeanMapper.mapList((Iterable)ejcConbaseContractTemplateCategoryEntities, TemplateCategoryVO.class);
        ArrayList ejcConbaseContractTemplateCategoryVoList = new ArrayList();
        for (TemplateCategoryVO e : categoryVos) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid", new Parameter("eq", (Object)e.getId()));
            queryParam.getParams().put("enable_status", new Parameter("eq", (Object)"1"));
            List entityLists = this.queryList(queryParam);
            List categoryVoList = BeanMapper.mapList((Iterable)entityLists, TemplateCategoryVO.class);
            e.setChildren(categoryVoList);
        }
        return CommonResponse.success((Object)categoryVos);
    }

    @Override
    public CommonResponse<IPage<TemplateCategoryVO>> getCategoryParent(QueryParam param) {
        param.getParams().put("is_top", new Parameter("eq", (Object)"0"));
        IPage page = this.queryPage(param, false);
        List categoryVoList = BeanMapper.mapList((Iterable)page.getRecords(), TemplateCategoryVO.class);
        Page categoryVoPage = new Page();
        categoryVoPage.setCurrent(page.getCurrent());
        categoryVoPage.setRecords(categoryVoList);
        categoryVoPage.setSize(page.getSize());
        categoryVoPage.setTotal(page.getTotal());
        categoryVoPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)categoryVoPage);
    }

    @Override
    public boolean checkProperty(String categoryProperty) {
        List category = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"category_property", (Object)categoryProperty)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid()));
        return CollectionUtils.isEmpty((Collection)category);
    }

    @Override
    public CommonResponse<List<TemplateCategoryVO>> querySameLevel(String id) {
        return this.querySameLevel(id, null);
    }

    @Override
    public CommonResponse<TemplateCategoryVO> updateEnableStatus(TemplateCategoryVO categoryVO) {
        TemplateCategoryEntity templateCategoryEntity = (TemplateCategoryEntity)((Object)this.selectById(categoryVO.getId()));
        templateCategoryEntity.setEnableStatus(categoryVO.getEnableStatus());
        this.saveOrUpdate((Object)templateCategoryEntity, false);
        TemplateCategoryVO map = (TemplateCategoryVO)BeanMapper.map((Object)((Object)templateCategoryEntity), TemplateCategoryVO.class);
        return CommonResponse.success((Object)map);
    }

    @Override
    public CommonResponse<String> deleteOrCheck(List<TemplateCategoryVO> vos) {
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelationByCategory(List<TemplateCategoryVO> vos) {
        List<Long> categoryIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            super.removeByIds(categoryIds, true);
            this.categoryRelationService.deleteRelationByCategory(categoryIds);
            for (TemplateCategoryVO category : vos) {
                TemplateCategoryEntity templateCategory = (TemplateCategoryEntity)((Object)this.templateCategoryService.selectById(category.getId()));
                String categoryName = null != templateCategory ? templateCategory.getCategoryName() : "";
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("range_ids", new Parameter("like", (Object)("%" + category.getId() + "%")));
                List clauseSettingList = this.clauseSettingService.queryList(queryParam);
                if (!CollectionUtils.isNotEmpty((Collection)clauseSettingList)) continue;
                for (ClauseSettingEntity clauseSettingEntity : clauseSettingList) {
                    String oldRangeIds = "," + clauseSettingEntity.getRangeIds() + ",";
                    if ((oldRangeIds = oldRangeIds.replace("," + category.getId() + ",", ",")).length() > 1) {
                        oldRangeIds = oldRangeIds.substring(1, oldRangeIds.length() - 1);
                        clauseSettingEntity.setRangeIds(oldRangeIds);
                    } else {
                        clauseSettingEntity.setRangeIds(null);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)categoryName)) continue;
                    String oldRangeNames = "," + clauseSettingEntity.getRangeNames() + ",";
                    if ((oldRangeNames = oldRangeNames.replace("," + categoryName + ",", ",")).length() > 1) {
                        oldRangeNames = oldRangeNames.substring(1, oldRangeNames.length() - 1);
                        clauseSettingEntity.setRangeNames(oldRangeNames);
                        continue;
                    }
                    clauseSettingEntity.setRangeNames(null);
                }
                this.clauseSettingService.saveOrUpdateBatch(clauseSettingList, clauseSettingList.size(), false);
            }
        }
    }

    @Override
    public CommonResponse<List<TemplateCategoryVO>> querySameLevel(String categoryId, String range) {
        TemplateCategoryEntity templateCategoryEntity = (TemplateCategoryEntity)((Object)this.selectById((Serializable)((Object)categoryId)));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)templateCategoryEntity.getPid()));
        queryParam.getParams().put("enable_status", new Parameter("eq", (Object)1));
        if (StringUtils.isNotBlank((CharSequence)range)) {
            switch (range) {
                case "selfOrg": {
                    queryParam.getParams().put("belong_org_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                    break;
                }
                case "selfAndBelow": {
                    if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                        queryParam.getParams().put("belong_org_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                        break;
                    }
                    CommonResponse orgVOListResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                    if (!orgVOListResp.isSuccess()) {
                        throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    queryParam.getParams().put("belong_org_id", new Parameter("in", ((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                    break;
                }
                case "parents": {
                    CommonResponse orgVOListResp = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                    if (!orgVOListResp.isSuccess()) {
                        throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    queryParam.getParams().put("belong_org_id", new Parameter("in", ((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                    break;
                }
            }
        }
        List categoryEntityList = this.queryList(queryParam);
        List categoryVOList = BeanMapper.mapList((Iterable)categoryEntityList, TemplateCategoryVO.class);
        return CommonResponse.success((Object)categoryVOList);
    }

    @Override
    public TemplateCategoryEntity getOneByTemplateId(Long templateId) {
        return this.templateCategoryMapper.getOneByTemplateId(templateId);
    }
}

