/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
    public static final String MONTH = "yyyy-MM";
    public static final String DATE = "yyyy-MM-dd";
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME = "HHmmss";
    public static final String TIME_WITHOUT_SECOND = "HH:mm";
    public static final String DATE_TIME_WITHOUT_SECONDS = "yyyy-MM-dd HH:mm";

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        System.out.println("\u5224\u65adday2 - day1 : " + (day2 - day1));
        return day2 - day1;
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static int getMonthOfDay() {
        LocalTime localTime = LocalTime.now();
        return localTime.get(ChronoField.DAY_OF_MONTH);
    }

    public static String format(Date date, String pattern) {
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static Date parse(String dateStr, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date addMinutes(Date date, Long plusMinutes) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusMinutes(plusMinutes);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addHour(Date date, Long hour) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime localDateTime = dateTime.plusHours(hour);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartTime() {
        LocalDateTime now = LocalDateTime.now().withHour(0).withMinute(0).withSecond(0);
        return DateUtil.localDateTime2Date(now);
    }

    public static Date getEndTime() {
        LocalDateTime now = LocalDateTime.now().withHour(23).withMinute(59).withSecond(59).withNano(999);
        return DateUtil.localDateTime2Date(now);
    }

    public static Date minusMonths(long monthsToSubtract) {
        LocalDate localDate = LocalDate.now().minusMonths(monthsToSubtract);
        return DateUtil.localDate2Date(localDate);
    }

    public static Date localDate2Date(LocalDate localDate) {
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String getFirstDayOfCurrentYear(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now().withMonth(1).withDayOfMonth(1);
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyyMMdd";
        }
        return DateUtil.format(DateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getLastMonthFirstDayOfPreviousYear(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now().minusYears(1L).withMonth(12).withDayOfMonth(1);
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyyMMdd";
        }
        return DateUtil.format(DateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getLastMonthLastDayOfPreviousYear(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now().minusYears(1L).with(TemporalAdjusters.lastDayOfYear());
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyyMMdd";
        }
        return DateUtil.format(DateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getCurrentDay(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now();
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = DATE;
        }
        return DateUtil.format(DateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getPrevMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return String.valueOf(year) + month;
    }

    public static String addDay(Date date, int num) {
        SimpleDateFormat df = new SimpleDateFormat(DATE);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(7, num);
        String format = df.format(cal.getTime());
        System.out.println(format);
        return format;
    }

    public static Date monthAdd(Date m, Integer len) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(m);
        cal.add(2, len);
        return cal.getTime();
    }

    public static void main(String[] args) {
        DateUtil.addDay(new Date(), -15);
    }
}

