/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class TemplateApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private ITemplateVersionService templateVersionService;

    @GetMapping(value={"/api/template/getByCategoryId"})
    public CommonResponse<TemplateVO> getByCategoryId(@RequestParam(value="categoryId") Long categoryId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"category_id", (Object)categoryId);
        query.eq((Object)"enable_status", (Object)1);
        List eList = this.templateService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)eList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f", null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map(eList.get(0), TemplateVO.class));
    }

    @GetMapping(value={"/api/template/queryDetailById"})
    public CommonResponse<TemplateVO> queryDetailById(@RequestParam(value="id") Long id) {
        TemplateVO resp = null;
        TemplateEntity tmpl = (TemplateEntity)((Object)this.templateService.selectById(id));
        if (null != tmpl) {
            resp = (TemplateVO)BeanMapper.map((Object)((Object)tmpl), TemplateVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @GetMapping(value={"/api/template/getTemplateVersionInfo"})
    public CommonResponse<TemplateVersionVO> getTemplateVersionInfo(@RequestParam(value="templateId") Long templateId, @RequestParam(value="version", required=false) Long version) {
        TemplateVersionEntity tmp = null;
        if (null == version) {
            TemplateEntity e = (TemplateEntity)((Object)this.templateService.selectById(templateId));
            if (null == e) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u503c\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff01");
            }
            tmp = (TemplateVersionEntity)((Object)this.templateVersionService.selectById(e.getCurVersionId()));
        } else {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"template_id", (Object)templateId);
            query.eq((Object)"template_version", (Object)version);
            List vList = this.templateVersionService.list((Wrapper)query);
            if (CollectionUtils.isEmpty((Collection)vList)) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff01");
            }
            tmp = (TemplateVersionEntity)((Object)vList.get(0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)tmp), TemplateVersionVO.class));
    }

    @PostMapping(value={"/api/template/createNewTmplVersion"})
    public CommonResponse<TemplateVersionVO> createNewTmplVersion(@RequestBody TemplateVersionVO templateVersionVO) {
        TemplateVersionVO resp = this.templateVersionService.newTemplateVersion(templateVersionVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/api/template/getHisListByTemplateId"})
    public CommonResponse<List<TemplateVersionVO>> getHisListByTemplateId(@RequestParam String templateId, @RequestParam Integer start, @RequestParam Integer size) {
        List list;
        List resp = new ArrayList();
        if (null != start) {
            QueryWrapper countQuery = new QueryWrapper();
            countQuery.eq((Object)"template_id", (Object)templateId);
            countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            countQuery.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            int hisCount = this.templateVersionService.count((Wrapper)countQuery);
            if (hisCount < start) {
                return CommonResponse.success(resp);
            }
            if (hisCount < start + size) {
                size = hisCount - start;
            }
        }
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"template_id", (Object)templateId);
        listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        listQuery.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        listQuery.orderByDesc((Object)"template_version");
        if (null != start) {
            listQuery.last("limit " + start + "," + size);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.templateVersionService.list((Wrapper)listQuery)))) {
            resp = BeanMapper.mapList((Iterable)list, TemplateVersionVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }
}

