/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.cooperative.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.cooperative.bean.CooperativeAdjustEntity;
import com.ejianc.business.contractbase.cooperative.service.ICooperativeAdjustService;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeAdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"cooperativeAdjust"})
public class CooperativeAdjustController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICooperativeAdjustService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CooperativeAdjustVO> saveOrUpdate(@RequestBody CooperativeAdjustVO saveOrUpdateVO) {
        List entities;
        LambdaQueryWrapper lambda;
        if (null != saveOrUpdateVO.getCooperativeAdjustType() && 0 == saveOrUpdateVO.getCooperativeAdjustType()) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(CooperativeAdjustEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
            if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0L) {
                lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)(entities = this.service.list((Wrapper)lambda)))) {
                throw new BusinessException("\u540c\u4e00\u4e2a\u9879\u76ee\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u6761\u6570\u636e!");
            }
        }
        if (null != saveOrUpdateVO.getCooperativeAdjustType() && 1 == saveOrUpdateVO.getCooperativeAdjustType()) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(CooperativeAdjustEntity::getSupplierId, (Object)saveOrUpdateVO.getSupplierId());
            if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0L) {
                lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)(entities = this.service.list((Wrapper)lambda)))) {
                throw new BusinessException("\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u6761\u6570\u636e!");
            }
        }
        if (null != saveOrUpdateVO.getId()) {
            saveOrUpdateVO.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
        } else {
            saveOrUpdateVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        }
        CooperativeAdjustEntity entity = (CooperativeAdjustEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CooperativeAdjustEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CooperativeAdjustVO vo = (CooperativeAdjustVO)BeanMapper.map((Object)((Object)entity), CooperativeAdjustVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CooperativeAdjustVO> queryDetail(Long id) {
        CooperativeAdjustEntity entity = (CooperativeAdjustEntity)((Object)this.service.selectById(id));
        CooperativeAdjustVO vo = (CooperativeAdjustVO)BeanMapper.map((Object)((Object)entity), CooperativeAdjustVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CooperativeAdjustVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CooperativeAdjustVO cooperativeAdjustVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CooperativeAdjustVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter cooperativeAdjustType = (Parameter)param.getParams().get("cooperativeAdjustType");
        if (null != cooperativeAdjustType && "0".equals(cooperativeAdjustType.getValue())) {
            List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CooperativeAdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("cooperativeAdjust-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refcooperativeAdjustData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CooperativeAdjustVO>> refcooperativeAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CooperativeAdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

