/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.cooperative.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.cooperative.bean.CooperativeCollectEntity;
import com.ejianc.business.contractbase.cooperative.mapper.CooperativeCollectMapper;
import com.ejianc.business.contractbase.cooperative.service.ICooperativeCollectService;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeRatioVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cooperativeCollectService")
public class CooperativeCollectServiceImpl
extends BaseServiceImpl<CooperativeCollectMapper, CooperativeCollectEntity>
implements ICooperativeCollectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void initCooperativeCollect() {
        this.logger.info("---\u534f\u540c\u7387\u6570\u636e\u521d\u59cb\u5316\u5f00\u59cb---");
        this.logger.info("---\u6570\u636e\u5168\u5220\u9664\u64cd\u4f5c\u5f00\u59cb---");
        ((CooperativeCollectMapper)this.baseMapper).delCooperativeCollectAll();
        this.logger.info("---\u6570\u636e\u67e5\u8be2\u64cd\u4f5c\u5f00\u59cb---");
        List<CooperativeCollectEntity> cooperativeCollectEntityList = ((CooperativeCollectMapper)this.baseMapper).getAllCooperativeData();
        this.logger.info("---\u67e5\u5230\u6240\u6709\u534f\u540c\u6570\u636e\u4fe1\u606f--->{}", (Object)JSONObject.toJSONString(cooperativeCollectEntityList));
        super.saveOrUpdateBatch(cooperativeCollectEntityList, cooperativeCollectEntityList.size());
        this.logger.info("---\u534f\u540c\u7387\u6570\u636e\u521d\u59cb\u5316\u7ed3\u675f\uff0c\u63d2\u5165\u6570\u636e\uff1a{}\u6761", (Object)cooperativeCollectEntityList.size());
    }

    @Override
    public IPage<CooperativeRatioVO> getProjectCooperativeRatio(QueryParam param) {
        String orderValue;
        this.logger.info("\u67e5\u8be2\u534f\u540c\u7387\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        Long orgId = !paramMap.containsKey("orgId") ? InvocationInfoProxy.getOrgId() : Long.valueOf(((Parameter)paramMap.get("orgId")).getValue().toString());
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        String startDate = paramMap.containsKey("startDate") ? ((Parameter)paramMap.get("startDate")).getValue().toString() : null;
        String endDate = paramMap.containsKey("endDate") ? ((Parameter)paramMap.get("endDate")).getValue().toString() : null;
        String projectName = paramMap.containsKey("projectName") ? ((Parameter)paramMap.get("projectName")).getValue().toString() : null;
        String minRatio = paramMap.containsKey("minRatio") ? ((Parameter)paramMap.get("minRatio")).getValue().toString() : null;
        String maxRatio = paramMap.containsKey("maxRatio") ? ((Parameter)paramMap.get("maxRatio")).getValue().toString() : null;
        LinkedHashMap orderMap = param.getOrderMap();
        String string = orderValue = orderMap.get("orderValue") != null ? ((String)orderMap.get("orderValue")).toString() : "";
        if (!paramMap.containsKey("queryType")) {
            throw new BusinessException("\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String queryType = ((Parameter)paramMap.get("queryType")).getValue().toString();
        List<Object> cooperativeCollectVOList = new ArrayList();
        cooperativeCollectVOList = "supplier".equals(queryType) ? ((CooperativeCollectMapper)this.baseMapper).queryProjectCooperativeRatioBySupplier(orgIds, startDate, endDate, projectName, minRatio, maxRatio, orderValue) : ((CooperativeCollectMapper)this.baseMapper).queryProjectCooperativeRatioByBill(orgIds, startDate, endDate, projectName, minRatio, maxRatio, orderValue);
        this.logger.info("\u67e5\u51fa\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(cooperativeCollectVOList));
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)cooperativeCollectVOList.size());
        pageDate.setRecords(cooperativeCollectVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public IPage<CooperativeRatioVO> getSupplierCooperativeRatio(QueryParam param) {
        String orderValue;
        this.logger.info("\u67e5\u8be2\u534f\u540c\u7387\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        Long orgId = !paramMap.containsKey("orgId") ? InvocationInfoProxy.getOrgId() : Long.valueOf(((Parameter)paramMap.get("orgId")).getValue().toString());
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        String startDate = paramMap.containsKey("startDate") ? ((Parameter)paramMap.get("startDate")).getValue().toString() : null;
        String endDate = paramMap.containsKey("endDate") ? ((Parameter)paramMap.get("endDate")).getValue().toString() : null;
        String supplierName = paramMap.containsKey("projectName") ? ((Parameter)paramMap.get("projectName")).getValue().toString() : null;
        String minRatio = paramMap.containsKey("minRatio") ? ((Parameter)paramMap.get("minRatio")).getValue().toString() : null;
        String maxRatio = paramMap.containsKey("maxRatio") ? ((Parameter)paramMap.get("maxRatio")).getValue().toString() : null;
        LinkedHashMap orderMap = param.getOrderMap();
        String string = orderValue = orderMap.get("orderValue") != null ? ((String)orderMap.get("orderValue")).toString() : "";
        if (!paramMap.containsKey("queryType")) {
            throw new BusinessException("\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String queryType = ((Parameter)paramMap.get("queryType")).getValue().toString();
        List<Object> cooperativeCollectVOList = new ArrayList();
        cooperativeCollectVOList = "project".equals(queryType) ? ((CooperativeCollectMapper)this.baseMapper).querySupplierCooperativeRatioByProject(orgIds, startDate, endDate, supplierName, minRatio, maxRatio, orderValue) : ((CooperativeCollectMapper)this.baseMapper).querySupplierCooperativeRatioByBill(orgIds, startDate, endDate, supplierName, minRatio, maxRatio, orderValue);
        this.logger.info("\u67e5\u51fa\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(cooperativeCollectVOList));
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)cooperativeCollectVOList.size());
        pageDate.setRecords(cooperativeCollectVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }
}

