/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.settlepool.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class SettlePoolApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "SETTLE_POOL_TEMP";
    private static final String BILL_CODE_NO_CONTRACT = "SETTLE_POOL_NO_CONTRACT_TEMP";

    @PostMapping(value={"/api/settlePool/saveOrUpdateSettle"})
    public CommonResponse<SettlePoolVO> saveOrUpdate(@RequestBody SettlePoolVO saveOrUpdateVO) {
        this.logger.info("\u63a5\u6536\u5230\u7ed3\u7b97\u5355\u540c\u6b65\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        SettlePoolVO vo = this.service.saveOrUpdateSettle(saveOrUpdateVO);
        return CommonResponse.success((String)"\u7ed3\u7b97\u5355\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/api/settlePool/queryTotalMny"}, method={RequestMethod.POST})
    public CommonResponse<SettlePoolVO> queryTotalMny(@RequestBody SettlePoolVO settlePoolVO) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.queryTotalMny(settlePoolVO));
    }

    @RequestMapping(value={"/api/settlePool/queryContractsTotalSettleMny"}, method={RequestMethod.POST})
    public CommonResponse<Map<String, BigDecimal>> queryContractsTotalSettleMny(@RequestBody QueryParam queryParam) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", this.service.queryContractsTotalSettleMny(queryParam));
    }

    @RequestMapping(value={"/api/settlePool/queryNoContractTotalMny"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> queryNoContractTotalMny(@RequestBody SettlePoolVO settlePoolVO) {
        return this.service.queryNoContractTotalMny(settlePoolVO);
    }

    @PostMapping(value={"/api/settlePool/saveOrUpdateBatch"})
    public CommonResponse<List<SettlePoolVO>> saveOrUpdateBatch(@RequestBody List<SettlePoolVO> saveOrUpdateVOs) {
        this.logger.info("\u63a5\u6536\u5230\u7ed3\u7b97\u5355\u540c\u6b65\u6570\u636e-{}", (Object)JSONObject.toJSONString(saveOrUpdateVOs));
        List<SettlePoolVO> vos = this.service.saveOrUpdateSettleBatch(saveOrUpdateVOs);
        return CommonResponse.success((String)"\u7ed3\u7b97\u5355\u4fdd\u5b58\u6210\u529f\uff01", vos);
    }

    @PostMapping(value={"/api/settlePool/saveOrUpdateBatchGlobal"})
    public CommonResponse<List<SettlePoolVO>> saveOrUpdateBatchGlobal(@RequestBody List<SettlePoolVO> saveOrUpdateVOs) {
        return this.saveOrUpdateBatch(saveOrUpdateVOs);
    }

    @GetMapping(value={"/api/settlePool/getBySourceId"})
    public CommonResponse<SettlePoolVO> getBySourceId(@RequestParam(value="sourceId") Long sourceId) {
        SettlePoolVO vo = this.service.getBySourceId(sourceId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/api/settlePool/getBySourceIds"})
    public CommonResponse<List<SettlePoolVO>> getBySourceIds(@RequestBody List<Long> sourceIds) {
        List<SettlePoolVO> vos = this.service.getBySourceIds(sourceIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @PostMapping(value={"/api/settlePool/deleteSettle"})
    public CommonResponse<SettlePoolVO> delete(@RequestBody SettlePoolVO vo) {
        this.logger.info("\u63a5\u6536\u5230\u901a\u77e5\u5220\u9664\u7ed3\u7b97\u5355\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)vo));
        SettlePoolEntity settle = null;
        if (null != vo.getSourceId()) {
            settle = (SettlePoolEntity)((Object)this.service.selectById(vo.getSourceId()));
        }
        if (null == settle && null != vo.getId()) {
            settle = (SettlePoolEntity)((Object)this.service.selectById(vo.getId()));
        }
        if (null == settle) {
            this.logger.info("\u7ed3\u7b97\u5355-\u3010{}\u3011\u5220\u9664\u64cd\u4f5c\u7ed3\u675f\uff0c\u5728\u7ed3\u7b97\u6c60\u4e2d\u65e0\u5339\u914d\u7684\u6570\u636e\uff01", (Object)JSONObject.toJSONString((Object)vo));
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(null != settle.getContractId() ? "EJCBT202205000007" : "EJCBT202205000006", settle.getId());
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5\uff1a{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)("\u7ed3\u7b97\u5355[" + settle.getBillCode() + "]\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        this.service.delBySourceId(settle.getId());
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/api/settlePool/queryList"})
    public CommonResponse<List<SettlePoolVO>> queryList(@RequestBody QueryParam QueryParam2) {
        List resp = new ArrayList();
        List entityList = this.service.queryList(QueryParam2);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            resp = BeanMapper.mapList((Iterable)entityList, SettlePoolVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"/api/settlePool/fetchTotalProductValueTaxMny"})
    public CommonResponse<BigDecimal> fetchTotalProductValueTaxMny(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.fetchTotalProductValueTaxMny(projectId));
    }

    @PostMapping(value={"/api/settlePool/fetchTotalSettleTaxMny"})
    public CommonResponse<Map<String, Object>> fetchTotalSettleTaxMny(@RequestBody Collection<Long> contractIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.service.fetchTotalSettleTaxMny(contractIds));
    }
}

