/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.report.vo.SupplierSettleVO;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplierReport"})
public class SupplierReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private ISettlePoolService service;

    @RequestMapping(value={"/settleList"}, method={RequestMethod.GET})
    public CommonResponse<List<SupplierSettleVO>> settleList(@RequestParam(value="supplierId", required=false) Long supplierId, @RequestParam(defaultValue="near6Mon") String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        Long _orgId;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(supplierId != null, (Object)"partyb_id", (Object)supplierId);
        Long l = _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            wrapper.eq((Object)"org_id", (Object)_orgId);
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(_orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List ids = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.in((Object)"parent_org_id", ids);
        }
        String startMonth = null;
        String endMonth = null;
        if ("thisYear".equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01";
            endMonth = EJCDateUtil.getYear() + "-12";
        } else if ("near3Mon".equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-2);
            endMonth = EJCDateUtil.getMonth((int)0);
        } else if ("near6Mon".equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-5);
            endMonth = EJCDateUtil.getMonth((int)0);
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01";
            endMonth = EJCDateUtil.getLastYear() + "-12";
        }
        wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.select(new String[]{"DATE_FORMAT(settle_date,'%Y-%m') ext1", "SUM( IF( source_type = 'labor_final' OR source_type = 'pro_final', total_process_tax_difference, cur_tax_mny ) ) cur_tax_mny"});
        wrapper.ge((Object)"DATE_FORMAT(settle_date,'%Y-%m')", (Object)startMonth);
        wrapper.le((Object)"DATE_FORMAT(settle_date,'%Y-%m')", (Object)endMonth);
        wrapper.notIn((Object)"source_type", Arrays.asList("labor_node", "pro_node"));
        wrapper.groupBy(new Object[]{"DATE_FORMAT(settle_date,'%Y-%m')"});
        List list = this.service.list((Wrapper)wrapper);
        List monthData = EJCDateUtil.getMonthBetween((String)startMonth, (String)endMonth);
        Map<Object, Object> dataMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            dataMap = list.stream().collect(Collectors.toMap(SettlePoolEntity::getExt1, SettlePoolEntity::getCurTaxMny));
        }
        ArrayList<SupplierSettleVO> dataList = new ArrayList<SupplierSettleVO>();
        for (String mon : monthData) {
            SupplierSettleVO supplierSettleVO = new SupplierSettleVO();
            supplierSettleVO.setSettleDate(mon);
            supplierSettleVO.setSumTaxMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.nullToZero((BigDecimal)((BigDecimal)dataMap.get(mon)))));
            dataList.add(supplierSettleVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5c65\u7ea6\u5206\u6790\u6570\u636e\u6210\u529f\uff01", dataList);
    }

    @GetMapping(value={"/getSynergyList"})
    public CommonResponse<List<JSONObject>> getSynergyList(@RequestParam Long id, @RequestParam String groupField, @RequestParam(required=false, defaultValue="all") String rage) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (!"all".equals(rage)) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                orgIds.add(InvocationInfoProxy.getOrgId());
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                orgIds.addAll(((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            }
        }
        List<JSONObject> dataList = this.service.getSynergyList(id, orgIds, groupField);
        this.logger.info("groupId-{}, groupFields-{},\u67e5\u8be2\u51fa\u534f\u540c\u5217\u8868\u6570\u636e:{}\u6761", new Object[]{id, groupField, dataList.size()});
        Map<String, List<JSONObject>> groupData = dataList.stream().collect(Collectors.groupingBy(item -> item.getString("projectId".equals(groupField) ? "supplierId" : "projectId") + item.getString("billType")));
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        JSONObject tmp = null;
        JSONObject billData = null;
        for (String key : groupData.keySet()) {
            tmp = new JSONObject();
            billData = groupData.get(key).get(0);
            tmp.put("billType", (Object)billData.getString("billType"));
            tmp.put("supplierName", billData.get((Object)"supplierName"));
            tmp.put("projectName", (Object)billData.getString("projectName"));
            tmp.put("billNum", (Object)groupData.get(key).size());
            tmp.put("list", groupData.get(key));
            resp.add(tmp);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @GetMapping(value={"/getReportCommonQueryParam"})
    public CommonResponse<QueryParam> getReportCommonQueryParam(HttpServletRequest req) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String filterFields = req.getParameter("filterFields");
        List ids = null;
        String[] stringArray = filterFields.split(",");
        int n = stringArray.length;
        block11: for (int i = 0; i < n; ++i) {
            String filterField;
            switch (filterField = stringArray[i]) {
                case "projectId": {
                    CommonResponse projectIds = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), null, null);
                    if (!projectIds.isSuccess()) {
                        return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u672c\u4e0b\u6240\u6709\u9879\u76ee\u4fe1\u606f\u5931\u8d25\u3002");
                    }
                    ids = (List)projectIds.getData();
                    if (CollectionUtils.isEmpty((Collection)ids)) {
                        ids.add(-10L);
                    }
                    queryParam.getParams().put(filterField, new Parameter("in", ids));
                    continue block11;
                }
                case "orgId": 
                case "parentOrgId": {
                    CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                    if (!orgListResp.isSuccess()) {
                        return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                    }
                    List orgList = (List)orgListResp.getData();
                    ids = orgList.stream().map(BaseVO::getId).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(ids)) {
                        ids.add(-10L);
                    }
                    queryParam.getParams().put(filterField, new Parameter("in", ids));
                    continue block11;
                }
                case "noTenantId": {
                    queryParam.getParams().remove("tenantId");
                }
            }
        }
        return CommonResponse.success((Object)queryParam);
    }
}

