/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.home.service.IHomePortalService;
import com.ejianc.business.contractbase.home.vo.FinanceCountVO;
import com.ejianc.business.contractbase.home.vo.FinanceUseResVO;
import com.ejianc.business.contractbase.home.vo.ProjectInOutVO;
import com.ejianc.business.contractbase.vo.ContractMnyAndNumRatioVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/homePortal"})
public class HomePortalController {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IHomePortalService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @RequestMapping(value={"/capitalCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> capitalCount(@RequestParam(value="range", required=false) String range, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.capitalCount(range, dateIn, orgId);
    }

    @RequestMapping(value={"/queryFinanceUse"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUse(@RequestParam String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryFinanceUse(dateIn, orgId);
    }

    @RequestMapping(value={"/capitalCountLeader"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> capitalCountLeader(@RequestParam(value="range", required=false) String range, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.capitalCountLeader(range, dateIn, orgId);
    }

    @RequestMapping(value={"/capitalCountOrgLeader"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinanceCountVO>> capitalCountOrgLeader(@RequestBody QueryParam param) {
        IPage<FinanceCountVO> page = this.service.capitalCountOrgLeader(param);
        return CommonResponse.success(page);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("excel", new Parameter("eq", (Object)"excel"));
        IPage<FinanceCountVO> list = this.service.capitalCountOrgLeader(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list.getRecords());
        ExcelExport.getInstance().export("FinanceCount-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryFinanceUseLeader"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUseLeader(@RequestParam String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryFinanceUseLeader(dateIn, orgId);
    }

    @RequestMapping(value={"/proPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> proPageList(@RequestBody(required=false) Map<String, Object> params) {
        JSONObject resp = new JSONObject();
        IPage<ProjectInOutVO> page = this.service.proPageList(params);
        resp.put("data", page);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/thisProductMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BigDecimal> thisProductMny() {
        return CommonResponse.success((Object)this.service.thisProductMny());
    }

    @RequestMapping(value={"/costSquareChart"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> costSquareChart(@RequestParam(value="projectId", required=false) Long projectId, @RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        CommonResponse resp = this.projectPoolApi.queryProjectListByProjectDepartmentId(projectDepartmentId);
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            return CommonResponse.success((Object)this.service.costSquareChart(((ProjectPoolSetVO)((List)resp.getData()).get(0)).getId()));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u5f02\u5e38\uff01");
    }

    @RequestMapping(value={"/proPageOrgList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> proPageOrgList(@RequestBody(required=false) Map<String, Object> params) {
        JSONObject resp = new JSONObject();
        IPage<ProjectInOutVO> page = this.service.proPageOrgList(params);
        resp.put("data", page);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/queryFinanceUseByYear"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUseByYear(@RequestParam String year, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryFinanceUseByYear(year, orgId);
    }

    @RequestMapping(value={"/queryContractMnyByYear"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractMnyByYear(@RequestParam String year, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryContractMnyByYear(year, orgId);
    }

    @RequestMapping(value={"/queryContractProjectMnyByYear"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractProjectMnyByYear(@RequestParam String year, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryContractProjectMnyByYear(year, orgId);
    }

    @RequestMapping(value={"/querySubUnitTopByYear"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubUnitTopVO>> querySubUnitTopByYear(@RequestParam String year, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.querySubUnitTopByYear(year, orgId);
    }
}

