/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractReportVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contractReport"})
public class ContractReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolService service;
    @Autowired
    private ISettlePoolService settlePoolService;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ContractReportVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("parentOrgName");
        List orgIdList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        if (!param.getParams().containsKey("sourceType")) {
            param.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode(), ContractTypeEnum.\u652f\u51fa\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode(), ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractReportVO.class));
        for (ContractReportVO vo : pageData.getRecords()) {
            Object partybId;
            long supplierId;
            CommonResponse response;
            String performanceStatus;
            if (vo == null) continue;
            Integer contractProperty = vo.getContractProperty();
            if (contractProperty != null) {
                if (1 == contractProperty) {
                    vo.setContractPropertyName("\u6536\u5165");
                } else {
                    vo.setContractPropertyName("\u652f\u51fa");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(performanceStatus = vo.getPerformanceStatus()))) {
                ContractPerformanceStateEnum performanceStateEnum = ContractPerformanceStateEnum.getByStateCode((String)performanceStatus);
                vo.setPerformanceStatusName(performanceStateEnum != null ? performanceStateEnum.getStateName() : "");
            }
            Long orgId = vo.getParentOrgId();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                orgId = vo.getOrgId();
            }
            if (!orgIdList.contains(orgId)) {
                vo.setContractTaxMnyStr("******");
                vo.setTotalPaymentApplyTaxMnyStr("******");
                vo.setTotalSettleTaxMnyStr("******");
                vo.setClickable(Boolean.valueOf(false));
                continue;
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"partyb_id", (Object)vo.getPartybId());
            wrapper.eq((Object)"contract_id", (Object)vo.getContractId());
            wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            wrapper.select(new String[]{"SUM( IF( source_type = 'labor_final' OR source_type = 'pro_final', total_process_tax_difference, cur_tax_mny ) ) cur_tax_mny"});
            wrapper.notIn((Object)"source_type", Arrays.asList("labor_node", "pro_node"));
            List settleList = this.settlePoolService.list((Wrapper)wrapper);
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            if (settleList.get(0) != null) {
                totalSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if ((response = this.paymentApplyApi.querySumApplyMny(Long.valueOf(supplierId = Long.valueOf(String.valueOf(partybId = ((Parameter)param.getParams().get("partybId")).getValue())).longValue()), vo.getContractId())).isSuccess()) {
                Object sumApplyMny = ((JSONObject)response.getData()).get((Object)"sumApplyMny");
                vo.setTotalPaymentApplyTaxMnyStr(String.valueOf(sumApplyMny));
            } else {
                vo.setTotalPaymentApplyTaxMnyStr("0");
            }
            vo.setContractTaxMnyStr(vo.getContractTaxMny() != null && vo.getContractTaxMny() != BigDecimal.ZERO ? String.valueOf(vo.getContractTaxMny().setScale(2, 4)) : "0");
            vo.setTotalSettleTaxMnyStr(totalSettleTaxMny != null && totalSettleTaxMny != BigDecimal.ZERO ? String.valueOf(totalSettleTaxMny.setScale(2, 4)) : "0");
            vo.setClickable(Boolean.valueOf(true));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("parentOrgName");
        List orgIdList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        if (!param.getParams().containsKey("sourceType")) {
            param.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode(), ContractTypeEnum.\u652f\u51fa\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode(), ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode())));
        }
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, ContractReportVO.class);
            for (ContractReportVO vo : voList) {
                Object partybId;
                long supplierId;
                CommonResponse res;
                String performanceStatus;
                if (vo == null) continue;
                Integer contractProperty = vo.getContractProperty();
                if (contractProperty != null) {
                    if (1 == contractProperty) {
                        vo.setContractPropertyName("\u6536\u5165");
                    } else {
                        vo.setContractPropertyName("\u652f\u51fa");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(performanceStatus = vo.getPerformanceStatus()))) {
                    ContractPerformanceStateEnum performanceStateEnum = ContractPerformanceStateEnum.getByStateCode((String)performanceStatus);
                    vo.setPerformanceStatusName(performanceStateEnum != null ? performanceStateEnum.getStateName() : "");
                }
                Long orgId = vo.getParentOrgId();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                    orgId = vo.getOrgId();
                }
                if (!orgIdList.contains(orgId)) {
                    vo.setContractTaxMnyStr("******");
                    vo.setTotalPaymentApplyTaxMnyStr("******");
                    vo.setTotalSettleTaxMnyStr("******");
                    continue;
                }
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                wrapper.eq((Object)"partyb_id", (Object)vo.getPartybId());
                wrapper.eq((Object)"contract_id", (Object)vo.getContractId());
                wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                wrapper.select(new String[]{"SUM( IF( source_type = 'labor_final' OR source_type = 'pro_final', total_process_tax_difference, cur_tax_mny ) ) cur_tax_mny"});
                wrapper.notIn((Object)"source_type", Arrays.asList("labor_node", "pro_node"));
                List settleList = this.settlePoolService.list((Wrapper)wrapper);
                BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
                if (settleList.get(0) != null) {
                    totalSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if ((res = this.paymentApplyApi.querySumApplyMny(Long.valueOf(supplierId = Long.valueOf(String.valueOf(partybId = ((Parameter)param.getParams().get("partybId")).getValue())).longValue()), vo.getContractId())).isSuccess()) {
                    Object sumApplyMny = ((JSONObject)res.getData()).get((Object)"sumApplyMny");
                    vo.setTotalPaymentApplyTaxMnyStr(String.valueOf(sumApplyMny));
                } else {
                    vo.setTotalPaymentApplyTaxMnyStr("0");
                }
                vo.setContractTaxMnyStr(vo.getContractTaxMny() != null && vo.getContractTaxMny() != BigDecimal.ZERO ? String.valueOf(vo.getContractTaxMny().setScale(2, 4)) : "0");
                vo.setTotalSettleTaxMnyStr(totalSettleTaxMny != null && totalSettleTaxMny != BigDecimal.ZERO ? String.valueOf(totalSettleTaxMny.setScale(2, 4)) : "0");
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("ContractReport-export.xlsx", beans, response);
    }
}

