package com.ejianc.business.contractbase.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.TemplDetailExportSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ITemplDetailExportSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/9 14:40
 */
@RestController
@RequestMapping(value = "/api/templDetail/")
public class TemplDetailApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITemplDetailExportSettingService templDetailExportSettingService;

    @Autowired
    private ITemplateCategoryService templateCategoryService;

    @GetMapping(value = "findExportDetailByCategoryId")
    CommonResponse<List<TemplDetailExportSettingVO>> findExportDetailByCategoryId(@RequestParam(required = false) Long categoryId,
                                                                                  @RequestParam(required = false)  Long templateId) {
        List<TemplDetailExportSettingEntity> entityList = null;
        TemplateCategoryEntity category = null;
        if(null == categoryId && null == templateId) {
            return CommonResponse.error("请传入合同分类Id或模板Id不能同时为空！");
        }
        if(null != templateId) {

            QueryWrapper<TemplDetailExportSettingEntity> query = new QueryWrapper<>();
            query.eq("template_id", templateId);
            query.eq("dr", BaseVO.DR_UNDELETE);
            entityList = templDetailExportSettingService.list(query);
            logger.info("根据模板[Id-{}]查询对匹配的清单设置列表：{}", templateId, JSONObject.toJSONString(entityList));
            if(CollectionUtils.isEmpty(entityList)) {
                //该模板未设置清单列表，根据模板分类进行获取导出设置
                category = templateCategoryService.getOneByTemplateId(templateId);
            } else {
                entityList = entityList.stream().filter(item -> item.getDetailStatus() && (null != item.getSysFileId() || null != item.getCustomFileId())).collect(Collectors.toList());
            }
        } else {
            category = templateCategoryService.selectById(categoryId);
        }
        if(null != category) {
            entityList = templDetailExportSettingService.findExportDetailByCategoryId(category.getId(), category.getPid());
        }

        return CommonResponse.success(BeanMapper.mapList(entityList, TemplDetailExportSettingVO.class));
    }

}
