package com.ejianc.business.contractbase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.CategoryRelationMapper;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/9
 * @document:
 */
@Service
public class CategoryRelationServiceImpl
        extends BaseServiceImpl<CategoryRelationMapper, CategoryRelationEntity>
        implements ICategoryRelationService {
    @Autowired
    private ITemplateCategoryService categoryService;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private CategoryRelationMapper categoryRelationMapper;


    /**
     * 条款和分类表添加维护关系
     * @param entity 当前条款
     * @param ids 分类id字符串
     * @return
     */
    @Override
    public int saveCategoryRelation(ClauseSettingEntity entity, String ids){
        int sum = 0 ;
        //查询到当前条款所属分类的集合
        List<String> categoryIdList = Arrays.asList(ids.split(","));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, categoryIdList));
        List<TemplateCategoryEntity> templateCategoryList = categoryService.queryList(param);

        //对该条款所属的类型，在关系表中的数据全删全加（防止关系表数据过多，进行物理删除）
        List<Long> clauseIds = new ArrayList();
        clauseIds.add(entity.getId());
        this.deleteRelationByClause(clauseIds);

        //全部新增数据
        List<CategoryRelationEntity> insertList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(templateCategoryList)){
            for (TemplateCategoryEntity templateCategoryEntity : templateCategoryList) {
                CategoryRelationEntity relationEntity = new CategoryRelationEntity();
                if (0 == templateCategoryEntity.getIsTop()){
                    sum++;
                }
                relationEntity.setClauseId(entity.getId());
                relationEntity.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                relationEntity.setCategoryInnerCode(templateCategoryEntity.getInnerCode());
                relationEntity.setCategoryId(templateCategoryEntity.getId());
                relationEntity.setCreateUserCode(UserContext.getUserContext().getUserCode());
                relationEntity.setTenantId(InvocationInfoProxy.getTenantid());
                insertList.add(relationEntity);
            }
        }
        logger.info("分类条款关系表本次新增" + insertList.size() + "条数据！");
        this.saveOrUpdateBatch(insertList, insertList.size(),false);
        return sum;
    }

    @Override
    public void addRelationByCategory(TemplateCategoryEntity templateCategoryEntity, List<ClauseSettingEntity> clauseList) {
        List<CategoryRelationEntity> insertList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(clauseList)){
            for (ClauseSettingEntity clauseEntity : clauseList) {
                CategoryRelationEntity relationEntity = new CategoryRelationEntity();
                relationEntity.setClauseId(clauseEntity.getId());
                relationEntity.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                relationEntity.setCategoryInnerCode(templateCategoryEntity.getInnerCode());
                relationEntity.setCategoryId(templateCategoryEntity.getId());
                relationEntity.setCreateUserCode(UserContext.getUserContext().getUserCode());
                relationEntity.setTenantId(InvocationInfoProxy.getTenantid());
                insertList.add(relationEntity);
            }
            this.saveOrUpdateBatch(insertList, insertList.size(), false);
            logger.info("分类条款关系表本次新增" + insertList.size() + "条数据！");
        }
    }

    @Override
    public void deleteRelationByCategory(List<Long> categoryIds) {
        categoryRelationMapper.deleteRelationByCategory(categoryIds);
    }

    @Override
    public void deleteRelationByClause(List<Long> clauseIds) {
        categoryRelationMapper.deleteRelationByClause(clauseIds);
    }


}
