/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.dto.CostDesktopDTO;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractSubPaymentNodeService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupHisPerformanceVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplierInfoVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.vo.ContractMnyAndNumRatioVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ContractPoolApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractPoolService contractPoolService;
    @Autowired
    private IContractSubPaymentNodeService nodeService;
    @Autowired
    private ISettlePoolService settleService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    private static final String BILL_CODE = "CONTRACT_POOL";
    @Autowired
    private ContractPoolMapper mapper;

    @PostMapping(value={"/api/contractpool/updatePerformanceStatusByContractId"})
    public CommonResponse<ContractPoolVO> updatePerformanceStatusByContractId(@RequestBody ContractPoolVO contractPoolVO) {
        this.logger.info("\u63a5\u6536\u5408\u540c\u540c\u6b65\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
        ContractPoolVO resp = this.contractPoolService.updatePerformanceStatusByContractId(contractPoolVO);
        return CommonResponse.success((String)"\u66f4\u65b0\u5408\u540c\u6c60\u4e2d\u5408\u540c\u7684\u5c65\u7ea6\u72b6\u6001\u6210\u529f", (Object)resp);
    }

    @PostMapping(value={"/api/contractpool/updatePerformanceStatusById"})
    public CommonResponse<ContractPoolVO> updatePerformanceStatusById(@RequestBody ContractPoolVO contractPoolVO) {
        return this.updatePerformanceStatusByContractId(contractPoolVO);
    }

    @PostMapping(value={"/api/contractpool/saveOrUpdateContract"})
    public CommonResponse<ContractPoolVO> saveOrUpdateContract(@RequestBody ContractPoolVO contract) {
        this.logger.info("\u63a5\u6536\u5408\u540c\u540c\u6b65\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contract));
        ContractPoolVO resp = this.contractPoolService.saveOrUpdateContract(contract);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/api/contractpool/deleteContract"})
    public CommonResponse<String> deleteContract(@RequestBody ContractPoolVO contract) {
        this.logger.info("\u63a5\u6536\u5408\u540c-{}\u5220\u9664\u8bf7\u6c42", (Object)JSONObject.toJSONString((Object)contract));
        ContractPoolEntity contractEntity = null;
        if (null != contract.getSourceId()) {
            contractEntity = (ContractPoolEntity)((Object)this.contractPoolService.selectById(contract.getSourceId()));
        }
        if (null == contractEntity && null != contract.getId()) {
            contractEntity = (ContractPoolEntity)((Object)this.contractPoolService.selectById(contract.getId()));
        }
        if (null == contractEntity) {
            this.logger.info("\u5408\u540c-\u3010{}\u3011\u5220\u9664\u64cd\u4f5c\u7ed3\u675f\uff0c\u5728\u5408\u540c\u6c60\u4e2d\u65e0\u5339\u914d\u7684\u6570\u636e\uff01", (Object)JSONObject.toJSONString((Object)contract));
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote("EJCBT202204000016", contractEntity.getId());
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.contractPoolService.removeById(contractEntity.getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryPayment"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractSubPaymentNodeVO>> queryPayment(@RequestParam(value="contractId") String contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)contractId));
        List contractSubPaymentNodeEntities = this.nodeService.queryList(queryParam);
        List contractSubPaymentNodeVOS = BeanMapper.mapList((Iterable)contractSubPaymentNodeEntities, ContractSubPaymentNodeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractSubPaymentNodeVOS);
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryContractByCode"}, method={RequestMethod.GET})
    public CommonResponse<ContractPoolVO> queryContractByCode(@RequestParam(value="contractCode") String contractCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractCode", new Parameter("eq", (Object)contractCode));
        List contractPoolVOList = this.contractPoolService.queryList(queryParam);
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        if (CollectionUtils.isNotEmpty((Collection)contractPoolVOList) && contractPoolVOList.get(0) != null) {
            contractPoolVO = (ContractPoolVO)BeanMapper.map(contractPoolVOList.get(0), ContractPoolVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractPoolVO);
    }

    @PostMapping(value={"/api/contractpool/queryList"})
    public CommonResponse<List<ContractPoolVO>> queryList(@RequestBody QueryParam queryParam) {
        List resp = new ArrayList();
        List entityList = this.contractPoolService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            resp = BeanMapper.mapList((Iterable)entityList, ContractPoolVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"/api/contractpool/querySupplierList"})
    public CommonResponse<List<Long>> querySupplierList(@RequestBody QueryParam queryParam) {
        ArrayList resp = new ArrayList();
        List entityList = this.contractPoolService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            List collect = entityList.stream().map(ContractPoolEntity::getPartybId).distinct().collect(Collectors.toList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", collect);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01\uff01");
    }

    @PostMapping(value={"/api/contractpool/queryContractMny"})
    public CommonResponse<BigDecimal> queryContractMny(@RequestBody QueryParam queryParam) {
        Parameter project_id;
        Parameter projectId = (Parameter)queryParam.getParams().get("projectId");
        if (null != projectId && "in".equals(projectId.getType().toLowerCase()) && CollectionUtils.isEmpty((Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)projectId.getValue())))) {
            queryParam.getParams().remove("projectId");
        }
        if (null != (project_id = (Parameter)queryParam.getParams().get("project_id")) && "in".equals(project_id.getType().toLowerCase()) && CollectionUtils.isEmpty((Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)project_id.getValue())))) {
            queryParam.getParams().remove("project_id");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny"});
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)wrapper));
        QueryWrapper objectQueryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        objectQueryWrapper.select(new String[]{"IFNULL(SUM(total_reply_tax_mny),0) as totalTeplyTaxMny"});
        ContractPoolEntity one = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)objectQueryWrapper));
        BigDecimal contractTaxMny = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)one.getTotalTeplyTaxMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractTaxMny);
    }

    @PostMapping(value={"/api/contractpool/querySumContractMny"})
    public CommonResponse<BigDecimal> querySumContractMny(@RequestBody QueryParam queryParam) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny"});
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)wrapper));
        BigDecimal contractTaxMny = entity.getContractTaxMny();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractTaxMny);
    }

    @PostMapping(value={"/api/contractpool/getContractList"})
    public CommonResponse<JSONArray> getContractList(@RequestBody SupplyVO vo) {
        this.logger.info("\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)vo));
        List<ContractDTO> contractList = this.contractPoolService.getContractList(vo);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c:" + JSONObject.toJSONString(contractList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)JSONObject.parseArray((String)JSONObject.toJSONString(contractList)));
    }

    @PostMapping(value={"/api/contractpool/getContractListByHeadUser"})
    public CommonResponse<JSONArray> getContractListByHeadUser(@RequestBody HeadUserVO vo) {
        this.logger.info("\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)vo));
        List<ContractDTO> contractList = this.contractPoolService.getContractListByHeadUser(vo);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c:" + JSONObject.toJSONString(contractList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)JSONObject.parseArray((String)JSONObject.toJSONString(contractList)));
    }

    @GetMapping(value={"/api/contractpool/supHisPerformanceList"})
    public CommonResponse<List<SupHisPerformanceVO>> supHisPerformanceList(@RequestParam Long supplierId) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"if(source_type = 'laborSub', supplier_project_manager_name, '') as headUserName, project_name as engineeringName, project_address as engineeringAddress,  partya_name as cooperationOrg, source_type_name as cooperationContent, contract_tax_mny as contractMny, contract_name as contractName, category_name as contractCategoryName,  supplier_project_manager_name as supplierManagerName, supplier_project_manager_link as supplierManagerLink, source_type as contractCategoryProperty, sign_date as startDay, finish_settle_date as endDay, employee_name as contacts, employee_phone as contactsPhone, partyb_id as supplierId"});
        query.eq((Object)"partyb_id", (Object)supplierId);
        List mapList = this.contractPoolService.listMaps((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)mapList)) {
            resp = BeanMapper.mapList((Iterable)mapList, SupHisPerformanceVO.class);
        }
        return CommonResponse.success(resp);
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryById"}, method={RequestMethod.GET})
    public CommonResponse<ContractPoolVO> queryById(@RequestParam(value="contractId") Long contractId) {
        ContractPoolEntity contractPoolEntity = (ContractPoolEntity)((Object)this.contractPoolService.selectById(contractId));
        if (contractPoolEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01\u6839\u636eid\u672a\u67e5\u8be2\u5230\u5408\u540c");
        }
        ContractPoolVO vo = (ContractPoolVO)BeanMapper.map((Object)((Object)contractPoolEntity), ContractPoolVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryContractHonourMny"}, method={RequestMethod.POST})
    public CommonResponse<BigDecimal> queryContractHonourMny(@RequestBody ContractPoolVO vo) {
        BigDecimal bigDecimal = this.contractPoolService.queryContractHonourMny(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)bigDecimal);
    }

    @GetMapping(value={"/api/contractpool/queryContractionSubtractProTaxMny"})
    public CommonResponse<BigDecimal> queryContractionSubtractProTaxMny(@RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.contractPoolService.queryContractionSubtractProTaxMny(projectId));
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryContractSettleTaxMny"}, method={RequestMethod.POST})
    public CommonResponse<List<SupplierInfoVO>> queryContractSettleTaxMny(@RequestBody SupplierInfoVO vo) {
        ArrayList<SupplierInfoVO> vos = new ArrayList<SupplierInfoVO>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny,partyb_id"});
        wrapper.in((Object)"partyb_id", (Collection)vo.getSupplierIds());
        wrapper.in((Object)"org_id", (Collection)vo.getOrgIds());
        wrapper.groupBy((Object[])new String[]{"partyb_id"});
        List list = this.contractPoolService.list((Wrapper)wrapper);
        QueryWrapper settleWrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(SUM(cur_tax_mny),0) as curTaxMny,partyb_id"});
        settleWrapper.in((Object)"partyb_id", (Collection)vo.getSupplierIds());
        settleWrapper.in((Object)"org_id", (Collection)vo.getOrgIds());
        settleWrapper.groupBy((Object[])new String[]{"partyb_id"});
        List settleList = this.settleService.list((Wrapper)settleWrapper);
        Map<Long, SettlePoolEntity> settlePoolMap = settleList.stream().collect(Collectors.toMap(k -> k.getPartybId(), k -> k));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ContractPoolEntity entity : list) {
                SupplierInfoVO supplierInfoVO = new SupplierInfoVO();
                supplierInfoVO.setContractTaxMny(entity.getContractTaxMny());
                if (settlePoolMap.containsKey(entity.getPartybId())) {
                    supplierInfoVO.setSettleTaxMny(settlePoolMap.get(entity.getPartybId()).getCurTaxMny());
                }
                supplierInfoVO.setSupplierId(entity.getPartybId());
                vos.add(supplierInfoVO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", vos);
    }

    @GetMapping(value={"/api/contractpool/queryThisYearContractMny"})
    public CommonResponse<BigDecimal> queryThisYearContractMny(@RequestParam(value="sourceType", required=false) String sourceType, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(SUM(total_reply_tax_mny),0) as totalTeplyTaxMny"});
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)dateIn), (Object)"DATE_FORMAT(sign_date,\"%Y\")", (Object)dateIn);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)sourceType), (Object)"source_type", (Object)sourceType);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny"});
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)dateIn), (Object)"DATE_FORMAT(sign_date,\"%Y\")", (Object)dateIn);
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)sourceType), (Object)"source_type", (Object)sourceType);
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            wrapper.in((Object)"parent_org_id", commonOrgIds);
            queryWrapper.in((Object)"parent_org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            wrapper.in((Object)"org_id", departmentIds);
            queryWrapper.in((Object)"org_id", departmentIds);
        }
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)wrapper));
        ContractPoolEntity one = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)queryWrapper));
        BigDecimal contractTaxMny = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)one.getTotalTeplyTaxMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractTaxMny);
    }

    @GetMapping(value={"/api/contractpool/updateActualPayRecMny"})
    public CommonResponse<String> updateActualPayRecMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="taxMny") BigDecimal taxMny, @RequestParam(value="mny") BigDecimal mny, @RequestParam(value="flag") boolean flag) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(ContractPoolEntity::getContractId, (Object)contractId);
        if (flag) {
            query.setSql("total_actual_pay_rec_tax_mny = IFNULL(total_actual_pay_rec_tax_mny,0) + IFNULL(" + taxMny + ",0),total_actual_pay_rec_mny = IFNULL(total_actual_pay_rec_mny,0) + IFNULL(" + mny + ",0)");
        } else {
            query.setSql("total_actual_pay_rec_tax_mny = IFNULL(total_actual_pay_rec_tax_mny,0) - IFNULL(" + taxMny + ",0),total_actual_pay_rec_mny = IFNULL(total_actual_pay_rec_mny,0) - IFNULL(" + mny + ",0)");
        }
        this.contractPoolService.update((Wrapper)query);
        return CommonResponse.success((String)"\u56de\u5199\u6210\u529f");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/api/contractpool/getProjectAreaContractMny"})
    public CommonResponse<List<Map<String, Object>>> getProjectAreaContractMny(@RequestParam Long orgId, @RequestParam Integer topNum, @RequestParam(value="contractTypes", required=false) String contractTypes, @RequestParam(required=false) String dateIn) {
        CommonResponse prjResp = this.projectPoolApi.queryProjectsByOrgId(orgId);
        if (!prjResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-[{}]\u83b7\u53d6\u5728\u5efa\u9879\u76ee\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)orgId, (Object)prjResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectList = (List)prjResp.getData();
        if (CollectionUtils.isEmpty((Collection)projectList)) {
            this.logger.info("\u5728\u5efa\u9879\u76ee\u91d1\u989d\u533a\u4f4d\u6392\u540d \u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7-\u3010{}\u3011\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a\uff01", (Object)orgId);
            return CommonResponse.success(new ArrayList());
        }
        ArrayList<JSONObject> projectProvinceMap = new ArrayList<JSONObject>();
        JSONObject tmp = null;
        for (ProjectVO project : projectList) {
            tmp = new JSONObject();
            if (StringUtils.isBlank((CharSequence)project.getArea())) {
                tmp.put("provinceName", (Object)"\u672a\u77e5");
            } else {
                tmp.put("provinceName", (Object)project.getAreaName().split("/")[0]);
            }
            tmp.put("projectId", (Object)project.getId());
            projectProvinceMap.add(tmp);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("projectProvinceMap", projectProvinceMap);
        param.put("topNum", topNum);
        if (StringUtils.isNotBlank((CharSequence)contractTypes)) {
            param.put("contractTypes", Arrays.asList(contractTypes.split(",")));
        } else {
            param.put("contractTypes", Arrays.asList(ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)dateIn)) {
            param.put("signDateYear", dateIn);
        }
        List<Map<String, Object>> projectContractMny = this.contractPoolService.getProjectAreaContractMny(param);
        return CommonResponse.success(projectContractMny);
    }

    @GetMapping(value={"/api/contractpool/getMolecularUnitRange"})
    public CommonResponse<List<Map<String, Object>>> getMolecularUnitRange(@RequestParam Long orgId, @RequestParam Integer topNum, @RequestParam(value="contractTypes", required=false) String contractTypes) {
        CommonResponse orgResp = this.iOrgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(), Arrays.asList(2, 3), null, orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u53c2\u6570tenantId-{}, orgTypes-{}, orgId-{}\u67e5\u8be2\u672c\u4e0b\u7ec4\u7ec7\u5217\u8868\u5931\u8d25\uff0c{}", new Object[]{InvocationInfoProxy.getTenantid(), JSONObject.toJSONString(Arrays.asList(2, 3)), orgId, orgResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgList = (List)orgResp.getData();
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            this.logger.info("\u6839\u636e\u53c2\u6570tenantId-{}, orgTypes-{}, orgId-{}\u67e5\u8be2\u672c\u4e0b\u7ec4\u7ec7\u5217\u8868\u4e3a\u7a7a\uff01", new Object[]{InvocationInfoProxy.getTenantid(), JSONObject.toJSONString(Arrays.asList(2, 3)), orgId});
            return CommonResponse.success(new ArrayList());
        }
        List orgIds = orgList.stream().map(BaseVO::getId).collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("parentOrgIds", orgIds);
        if (StringUtils.isNotBlank((CharSequence)contractTypes)) {
            param.put("contractTypes", Arrays.asList(contractTypes.split(",")));
        } else {
            param.put("contractTypes", Arrays.asList(ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        }
        param.put("topNum", topNum);
        List<Map<String, Object>> data = this.contractPoolService.getMolecularUnitRange(param);
        return CommonResponse.success(data);
    }

    @GetMapping(value={"/api/contractpool/getPayContractRatio"})
    public CommonResponse<List<ContractMnyAndNumRatioVO>> getPayContractRatio(@RequestParam Long orgId, @RequestParam(value="year", required=false) String year) {
        CopyOnWriteArrayList<ContractMnyAndNumRatioVO> returnList = new CopyOnWriteArrayList<ContractMnyAndNumRatioVO>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        wrapper.in((Object)"org_id", orgIds);
        wrapper.eq((Object)"contract_property", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
        wrapper.select(new String[]{"source_type", "source_type_name", "SUM(contract_tax_mny) as signTaxMny", "count(*) as signNum"});
        wrapper.eq((Object)"DATE_FORMAT(sign_date,'%Y')", (Object)year);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.groupBy(new Object[]{"source_type"});
        List list = this.contractPoolService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ContractPoolEntity contractPoolEntity : list) {
                ContractMnyAndNumRatioVO vo = new ContractMnyAndNumRatioVO();
                vo.setContractType(contractPoolEntity.getSourceType());
                vo.setContractTypeName(contractPoolEntity.getSourceTypeName());
                vo.setSignTaxMny(contractPoolEntity.getSignTaxMny());
                vo.setSignNum(contractPoolEntity.getSignNum());
                returnList.add(vo);
            }
        }
        ArrayList<String> contractTypes = new ArrayList<String>();
        contractTypes.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
        returnList.sort(Comparator.comparingInt(item -> contractTypes.indexOf(item.getContractType())));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", returnList);
    }

    @GetMapping(value={"/api/contractpool/queryContractionTaxMny"})
    public CommonResponse<BigDecimal> queryContractionTaxMny(@RequestParam Long projectId) {
        LambdaQueryWrapper incomeQueryWrapper = new LambdaQueryWrapper();
        incomeQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
        incomeQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        incomeQueryWrapper.eq(ContractPoolEntity::getSourceType, (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
        incomeQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List listContractPool = this.contractPoolService.list((Wrapper)incomeQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)listContractPool)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)BigDecimal.ZERO);
        }
        List zsht = listContractPool.stream().filter(x -> x.getIsEstimation() == null || x.getIsEstimation() == 0).collect(Collectors.toList());
        List zght = listContractPool.stream().filter(x -> null != x.getIsEstimation() && 1 == x.getIsEstimation()).collect(Collectors.toList());
        BigDecimal sumIncomeContractTaxMny = CollectionUtil.isNotEmpty(zsht) ? zsht.stream().map(item -> ComputeUtil.safeAdd((BigDecimal)item.getNotIncludeProvisionalMny(), (BigDecimal)item.getTotalCostAdjustTaxMny())).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO) : zght.stream().map(item -> ComputeUtil.safeAdd((BigDecimal)item.getNotIncludeProvisionalMny(), (BigDecimal)item.getTotalCostAdjustTaxMny())).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.logger.info("\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)sumIncomeContractTaxMny.toString());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)sumIncomeContractTaxMny);
    }

    @GetMapping(value={"/api/contractpool/queryContractionSupplierNum"})
    public CommonResponse<Integer> queryContractionSupplierNum() {
        Integer integer = this.contractPoolService.queryContractionSupplierNum(new QueryParam());
        this.logger.info("\u672c\u5e74\u5df2\u7b7e\u5408\u540c\u7684\u4f9b\u5e94\u5546\u4e2a\u6570\uff1a{}", (Object)integer);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)integer);
    }

    @GetMapping(value={"/api/contractpool/queryContractionSupplierNumDesktop"})
    public CommonResponse<List<CostDesktopDTO>> queryContractionSupplierNumDesktop() {
        List<CostDesktopDTO> costDesktopDTOS = this.mapper.queryContractionSupplierNumDasktop();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", costDesktopDTOS);
    }
}

