package com.ejianc.business.contractbase.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.home.service.IHomePortalService;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.business.market.api.IWorkReportApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author:姜轶凯
 * @version: 1
 * @date:2022/5/24
 * @document:
 */
@RestController
@RequestMapping("projectInfo")
public class ProjectInfoController {
    @Autowired
    private IHomePortalService homePortalService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IWorkReportApi workReportApi;
    @Autowired
    private IContractPoolService contractPoolService;
    /**
     * @param projectDepartmentId
     * @Description queryProjectDetail
     */
    @RequestMapping(value = "/queryProjectDetail", method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryProjectDetail(Long projectDepartmentId) {

        CommonResponse<List<ProjectPoolSetVO>> commonResponse = projectPoolApi.queryProjectListByProjectDepartmentId(projectDepartmentId);
        //今天日期
        JSONObject jsonObject=new JSONObject();
        String today = EJCDateUtil.format(new Date(), "yyyy-MM-dd");
        if (commonResponse.isSuccess()) {
            List<ProjectPoolSetVO> list = commonResponse.getData();
            if (CollectionUtils.isNotEmpty(list)) {
                ProjectPoolSetVO vo = list.get(0);
                Long projectId = vo.getProjectId();
                jsonObject = homePortalService.queryOutputScale(vo.getId());
                jsonObject.put("projectId",vo.getId());
                jsonObject.put("projectName", vo.getName());
                jsonObject.put("constructName", vo.getConstructName());
                jsonObject.put("designer", vo.getDesigner());
                jsonObject.put("supervisor", vo.getSupervisor());
                jsonObject.put("buildUnitName", vo.getBuildUnitName());
                jsonObject.put("engineeringTypeId", vo.getEngineeringTypeId());//工程类别
                jsonObject.put("costAdapter", vo.getCostAdapter());//成本对接人
                jsonObject.put("costAdapterName", vo.getCostAdapterName());//成本对接人
                //项目经理电话
                jsonObject.put("projectManagementPhone",vo.getProjectManagementPhone());
                //立项日期
                String projectDate = null;
                if (vo.getProjectDate()!=null){
                    projectDate = EJCDateUtil.format(vo.getProjectDate(), "yyyy-MM-dd");
                }
                jsonObject.put("projectDate", projectDate);
                // 计划开工日期
                String ProjectPlanStartDate =null;
                if (vo.getPlanStartDate()!=null){
                    ProjectPlanStartDate = EJCDateUtil.format(vo.getPlanStartDate(), "yyyy-MM-dd");
                }
                jsonObject.put("planStartDate",ProjectPlanStartDate);
                // 计划竣工日期
                String ProjectPlanEndDate =null;
                if (vo.getPlanEndDate()!=null){
                    ProjectPlanEndDate = EJCDateUtil.format(vo.getPlanEndDate(), "yyyy-MM-dd");
                }
                jsonObject.put("planEndDate",ProjectPlanEndDate);
                //地区
                jsonObject.put("areaName",vo.getAreaName());
                //地址
                jsonObject.put("address",vo.getAddress());
                //业务状态
                jsonObject.put("businessStatus",vo.getBusinessStatus());
                //间隔天数
                Integer surpluday = null;
                if (vo.getPlanEndDate() != null) {
                    String planEndDate = EJCDateUtil.format(vo.getPlanEndDate(), "yyyy-MM-dd");
                    surpluday = EJCDateUtil.getDayBetween(today, planEndDate).size();
                }
                jsonObject.put("surpluday", surpluday);
                //工期进度
                BigDecimal workDateProgress = null;
                if (vo.getPlanDateNum() != null && null!=vo.getPlanStartDate()) {
                    //开工天数
                    String planStartDate = EJCDateUtil.format(vo.getPlanStartDate(), "yyyy-MM-dd");
                    BigDecimal planDateNum = new BigDecimal(vo.getPlanDateNum());
                    BigDecimal startDateNum = new BigDecimal(EJCDateUtil.getDayBetween(planStartDate, today).size());
                    workDateProgress = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(startDateNum,planDateNum), new BigDecimal(100));
                } else {
                    workDateProgress = BigDecimal.ZERO;
                }
                jsonObject.put("workDateProgress",workDateProgress);

                CommonResponse<JSONObject> projectInfoResp = workReportApi.getProjectInfo(vo.getId());
                if(!projectInfoResp.isSuccess()) {
                    return CommonResponse.error("获取项目状态信息失败！");
                }
                JSONObject projectStatusInfo = projectInfoResp.getData();
                jsonObject.put("projectStatusName", null != projectStatusInfo.get("projectStatusName") ? projectStatusInfo.get("projectStatusName").toString() : null);
                jsonObject.put("businessStatusName", null != projectStatusInfo.get("businessStatusName") ? projectStatusInfo.get("businessStatusName").toString() : null);
                jsonObject.put("settleStatusName", null != projectStatusInfo.get("settleStatusName") ? projectStatusInfo.get("settleStatusName").toString() : null);
                jsonObject.put("capitalStatusName", null != projectStatusInfo.get("capitalStatusName") ? projectStatusInfo.get("capitalStatusName").toString() : null);
                jsonObject.put("archiveStatusName", null != projectStatusInfo.get("archiveStatusName") ? projectStatusInfo.get("archiveStatusName").toString() : null);
                jsonObject.put("daysBeforeCostClose", Integer.valueOf(projectStatusInfo.get("daysBeforeCostClose").toString()));
            }
        }
        return CommonResponse.success("查询详情数据成功！", jsonObject);
    }


    /**
     * @param projectId
     * @Description 查询项目的设备合同金额
     */
    @RequestMapping(value = "/queryEquipmentContractMnyByProjectId", method = RequestMethod.GET)
    public CommonResponse<BigDecimal> queryEquipmentContractMnyByProjectId(Long projectId) {
        BigDecimal bigDecimal = contractPoolService.queryEquipmentContractMnyByProjectId(projectId);
        return CommonResponse.success("查询详情数据成功！", bigDecimal);
    }


    /**
     * @param projectId
     * @Description 查询项目的物资合同金额
     */
    @RequestMapping(value = "/queryMaterialContractMnyByProjectId", method = RequestMethod.GET)
    public CommonResponse<BigDecimal> queryMaterialContractMnyByProjectId(Long projectId) {
        BigDecimal bigDecimal = contractPoolService.queryMaterialContractMnyByProjectId(projectId);
        return CommonResponse.success("查询详情数据成功！", bigDecimal);
    }


    /**
     * @param projectId
     * @Description 查询项目的专业合同金额
     */
    @RequestMapping(value = "/queryProsubContractMnyByProjectId", method = RequestMethod.GET)
    public CommonResponse<BigDecimal> queryProsubContractMnyByProjectId(Long projectId) {
        BigDecimal bigDecimal = contractPoolService.queryProsubContractMnyByProjectId(projectId);
        return CommonResponse.success("查询详情数据成功！", bigDecimal);
    }


    /**
     * @param projectId
     * @Description 查询项目的劳务合同金额
     */
    @RequestMapping(value = "/queryLabsubContractMnyByProjectId", method = RequestMethod.GET)
    public CommonResponse<BigDecimal> queryLabsubContractMnyByProjectId(Long projectId) {
        BigDecimal bigDecimal = contractPoolService.queryLabsubContractMnyByProjectId(projectId);
        return CommonResponse.success("查询详情数据成功！", bigDecimal);
    }

}
