package com.ejianc.business.contractbase.pool.settlepool.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.settlepool.bean.BillUrlDictEntity;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 结算池主实体
 *
 * @author generator
 */
public interface ISettlePoolService extends IBaseService<SettlePoolEntity> {

    // 数据导入
    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    /**
     * 查询穿透URL中间表所有数据
     *
     * @param paramList
     * @return
     */
    List<BillUrlDictEntity> queryDetailUrlList(List<String> paramList);

    /**
     * 根据source_id删除数据
     *
     * @param sourceId
     */
    void delBySourceId(Long sourceId);

    /**
     * 结算单保存更新
     *
     * @param saveOrUpdateVO
     * @return
     */
    SettlePoolVO saveOrUpdateSettle(SettlePoolVO saveOrUpdateVO);

    /**
     * 结算单批量保存更新
     *
     * @param saveOrUpdateVOs
     * @return
     */
    List<SettlePoolVO> saveOrUpdateSettleBatch(List<SettlePoolVO> saveOrUpdateVOs);

    /**
     * 查询单个结算单详情
     *
     * @param sourceIds
     * @return
     */
    SettlePoolVO getBySourceId(Long sourceIds);

    /**
     * 查询多个结算单详情
     *
     * @param sourceIds
     * @return
     */
    List<SettlePoolVO> getBySourceIds(List<Long> sourceIds);

    // 根据合同ID，来源类型查询数据，工人工资支付申请卡片页面查询累计月度结算和累计节点结算数据使用
    Map<String, BigDecimal> queryLaborMny(Long contractId);

    /**
     * 查询结算金额合计
     *
     * @param param
     * @return
     */
    BigDecimal calcTotalMny(QueryParam param);

    /**
     *  获取当前 合同下的累计结算金额
     * @param settlePoolVO
     * @return
     */
    SettlePoolVO queryTotalMny(SettlePoolVO settlePoolVO);

    /**
     * 获取当前 无同下的累计结算金额
     * @param settlePoolVO
     * @return
     */
    CommonResponse<JSONObject> queryNoContractTotalMny(SettlePoolVO settlePoolVO);

    /**
     * 根据项目id查询结算池中结算类型为产值报量的累计产值金额
     *
     * @param projectId 项目id
     *
     * @return 累计产值金额 = “本期结算金额(含税)”之和
     */
    BigDecimal fetchTotalProductValueTaxMny(Long projectId);

    /**
     * 根据合同id查询该合同的所有【结算池】数据，汇总“本期结算金额”之和
     *
     * @param contractIds 合同id集合
     *
     * @return 累计结算金额
     */
    Map<String, Object> fetchTotalSettleTaxMny(Collection<Long> contractIds);

    /**
     * 获取当前 匹配合同下的累计结算金额
     *
     * @param queryParam
     * @return
     */
    Map<String, BigDecimal> queryContractsTotalSettleMny(QueryParam queryParam);

    List<JSONObject> getSynergyList(Long groupId, List<Long> orgIds, String groupField);
}
