package com.ejianc.business.contractbase.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.service.ISubLeaderService;
import com.ejianc.business.contractbase.pool.contractpool.vo.SubLeaderReportVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.models.auth.In;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/12/1 16:19
 */
@RestController
@RequestMapping("/subLeaderReport/")
public class SubLeaderReportController {

    @Autowired
    private ISubLeaderService subLeaderService;

    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value = "queryList")
    public CommonResponse<IPage<SubLeaderReportVO>> queryList(@RequestBody QueryParam queryParam) {
        SubLeaderReportVO queryParams = new SubLeaderReportVO();
        queryParams.getSearchTexts().add("b.code"); //供应商编码
        queryParams.getSearchTexts().add("c.name"); //分包负责人名称
        queryParams.getSearchTexts().add("c.id_num"); //分包负责人身份证号码
        //供货内容
        queryParams.getSearchTexts().add("b.material_content"); //物资供货内容名称
        queryParams.getSearchTexts().add("b.equipment_content"); //设备供货内容
        queryParams.getSearchTexts().add("b.major_content"); //专业分包供货内容
        queryParams.getSearchTexts().add("b.labor_content"); //劳务分包供货内容
        queryParams.getSearchTexts().add("b.sub_content"); //分包班组供货内容
        queryParams.getSearchTexts().add("b.other_content"); //其他供货内容
        queryParams.getSearchTexts().add("b.revolv_material_content"); //周转材供货内容
        queryParams.getSearchTexts().add("b.consult_content"); //咨询供货内容

        if(StringUtils.isNotBlank(queryParam.getSearchText())) {
            queryParams.setSearchText(queryParam.getSearchText());
        }
        Map<String, Parameter> pageParamMap = queryParam.getParams();
        if(pageParamMap.containsKey("createTime")) {
            String[] dates = pageParamMap.get("createTime").getValue().toString().split(",");
            queryParams.setStartDate(dates[0]);
            queryParams.setEndDate(dates[1]);
        }
        if(pageParamMap.containsKey("grade")) {
            queryParams.setGrades(pageParamMap.get("grade").getValue().toString().split(","));
        }

        queryParams.setOrderName("createTime");
        if(queryParam.getOrderMap().containsKey("createTime")) {
            queryParams.setOrderValue(queryParam.getOrderMap().get("createTime"));
        } else {
            queryParams.setOrderValue(QueryParam.DESC);
        }
        queryParams.setPageSize(queryParam.getPageSize());
        Integer startLine = (queryParam.getPageIndex() - 1 < 0 ? 0 : queryParam.getPageIndex() - 1) * queryParam.getPageSize();
        queryParams.setStartLine(startLine);

        Page<SubLeaderReportVO> pageData = new Page<SubLeaderReportVO>();
        pageData.setSize(queryParam.getPageSize());

        if(InvocationInfoProxy.getOrgType().equals(OrgVO.ORG_TYPE_DEPARTMENT)) {
            //项目部
            queryParams.setOrgId(InvocationInfoProxy.getOrgId());
        } else {
            //非项目部组织
            CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if(!orgVOListResp.isSuccess()) {
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            queryParams.setParentOrgId(orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }

        Long totalSubLeaders = subLeaderService.countSubLeader(queryParams);
        pageData.setTotal(totalSubLeaders);
        pageData.setCurrent(queryParam.getPageIndex());

        if(totalSubLeaders > 0) {
            List<SubLeaderReportVO> pageList = subLeaderService.pageList(queryParams);
            pageList.forEach(item->{
               if(StringUtils.isNotBlank(item.getSupplierContent()) && item.getSupplierContent().endsWith(",")) {
                   item.setSupplierContent(item.getSupplierContent().substring(0,item.getSupplierContent().length()-1).replaceAll(",,", ","));
               }
            });
            pageData.setRecords(pageList);
        } else {
            pageData.setTotal(0);
            pageData.setRecords(new ArrayList<>());
            pageData.setPages(0);
        }

        return CommonResponse.success(pageData);
    }


    /**
     * @Description 导出
     *
     * @param queryParam
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        queryParam.setPageSize(-1);

        SubLeaderReportVO queryParams = new SubLeaderReportVO();
        queryParams.getSearchTexts().add("b.code"); //供应商编码
        queryParams.getSearchTexts().add("c.name"); //分包负责人名称
        queryParams.getSearchTexts().add("c.id_num"); //分包负责人身份证号码
        //供货内容
        queryParams.getSearchTexts().add("b.material_content"); //物资供货内容名称
        queryParams.getSearchTexts().add("b.equipment_content"); //设备供货内容
        queryParams.getSearchTexts().add("b.major_content"); //专业分包供货内容
        queryParams.getSearchTexts().add("b.labor_content"); //劳务分包供货内容
        queryParams.getSearchTexts().add("b.sub_content"); //分包班组供货内容
        queryParams.getSearchTexts().add("b.other_content"); //其他供货内容
        queryParams.getSearchTexts().add("b.revolv_material_content"); //周转材供货内容
        queryParams.getSearchTexts().add("b.consult_content"); //咨询供货内容

        if(StringUtils.isNotBlank(queryParam.getSearchText())) {
            queryParams.setSearchText(queryParam.getSearchText());
        }
        Map<String, Parameter> pageParamMap = queryParam.getParams();
        if(pageParamMap.containsKey("createTime")) {
            String[] dates = pageParamMap.get("createTime").toString().split(",");
            queryParams.setStartDate(dates[0]);
            queryParams.setStartDate(dates[1]);
        }

        queryParams.setOrderName("createTime");
        if(queryParam.getOrderMap().containsKey("createTime")) {
            queryParams.setOrderValue(queryParam.getOrderMap().get("createTime"));
        } else {
            queryParams.setOrderValue(QueryParam.DESC);
        }

        Page<SubLeaderReportVO> pageData = new Page<SubLeaderReportVO>();
        pageData.setSize(queryParam.getPageSize());

        Long totalSubLeaders = subLeaderService.countSubLeader(queryParams);
        List<SubLeaderReportVO> vos = new ArrayList<>();
        if(totalSubLeaders > 0) {
            vos = subLeaderService.pageList(queryParams);
            vos.forEach(item->{
                if(StringUtils.isNotBlank(item.getSupplierContent()) && item.getSupplierContent().endsWith(",")) {
                    item.setSupplierContent(item.getSupplierContent().substring(0,item.getSupplierContent().length()-1).replaceAll(",,", ","));
                }
            });
        }
        beans.put("records", vos);
        ExcelExport.getInstance().export("SubLeaderReport-export.xlsx", beans, response);
    }

}
