package com.ejianc.business.contractbase.service;

import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * @author:刘家乐
 * @version:
 * @date:2021/11/9
 * @document:
 */
public interface IClauseSettingService extends IBaseService<ClauseSettingEntity> {

    /**
     * 校验当前 分类 是否可以删除 和停用
     * true 代表 有关联 不能停用或删除
     * @param categoryId 分类id
     * @return 是否可以删除
     */
    boolean checkCategory(Long categoryId);

    /**
     * 更新全部分类可选的条款数据
     * @param templateCategoryEntity 新增的分类
     */
    void updateClauseByCategory(TemplateCategoryEntity templateCategoryEntity, Boolean insertFlag, String newCategoryName);

    /**
     * 根据条款 删除分类和条款相关信息
     * @param ids
     */
    void removeRelationByClause(List<Long> ids);

    /**
     * 更新条款停启用状态
     *
     * @param clauseSettingVO
     */
    ClauseSettingVO updateStatus(ClauseSettingVO clauseSettingVO);
}
