/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateSignatoryRectEntity;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateSignatoryRectService;
import com.ejianc.business.contractbase.vo.TemplateSignatoryRectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/signatoryRect"})
public class SignatoryRectController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IBillCodeApi billCodeApi;
    @Autowired
    private ITemplateSignatoryRectService service;
    @Autowired
    private ITemplateService templateService;

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<List<TemplateSignatoryRectVO>> saveOrUpdate(@Validated @RequestBody List<TemplateSignatoryRectVO> templateSignatoryRectVOS) {
        Long templateId = templateSignatoryRectVOS.get(0).getTemplateId();
        this.service.batchRemove(templateSignatoryRectVOS.stream().map(TemplateSignatoryRectVO::getTemplateId).distinct().collect(Collectors.toList()));
        List saveVos = templateSignatoryRectVOS.stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saveVos)) {
            this.service.saveOrUpdateBatch(BeanMapper.mapList(saveVos, TemplateSignatoryRectEntity.class));
        }
        List data = this.service.list((Wrapper)new LambdaQueryWrapper().eq(TemplateSignatoryRectEntity::getTemplateId, (Object)templateId));
        return CommonResponse.success((String)"\u7b7e\u7ae0\u5b9a\u4f4d\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)data, TemplateSignatoryRectVO.class));
    }

    @GetMapping(value={"/queryList"})
    public CommonResponse<List<TemplateSignatoryRectVO>> queryList(@RequestParam(value="templateId") Long templateId) {
        Assert.notNull((Object)templateId, (String)"\u5408\u540c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(TemplateSignatoryRectEntity::getTemplateId, (Object)templateId);
        queryWrapper.orderByAsc(TemplateSignatoryRectEntity::getPartyCode);
        List entityList = this.service.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u7b7e\u7ae0\u5b9a\u4f4d\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)entityList, TemplateSignatoryRectVO.class));
    }

    @GetMapping(value={"/fetchSignatoryRect"})
    public CommonResponse<List<TemplateSignatoryRectVO>> fetchSignatoryRect(@RequestParam(value="categoryId") Long categoryId) {
        Assert.notNull((Object)categoryId, (String)"\u5408\u540c\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(TemplateEntity::getEnableStatus, (Object)1);
        wrapper.eq(TemplateEntity::getCategoryId, (Object)categoryId);
        TemplateEntity template = (TemplateEntity)((Object)this.templateService.getOne((Wrapper)wrapper));
        if (template == null) {
            return CommonResponse.error((String)"\u6839\u636e\u5408\u540c\u5206\u7c7b\u67e5\u8be2\u5408\u540c\u6a21\u7248\u5931\u8d25\uff01");
        }
        Assert.notNull((Object)template.getId(), (String)"\u5408\u540c\u6a21\u7248id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(TemplateSignatoryRectEntity::getTemplateId, (Object)template.getId());
        queryWrapper.orderByAsc(TemplateSignatoryRectEntity::getPartyCode);
        List entityList = this.service.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u5408\u540c\u6a21\u7248\u7b7e\u7ae0\u5b9a\u4f4d\u4fe1\u606f\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)entityList, TemplateSignatoryRectVO.class));
    }
}

