# 结算池--穿透URL中间表
/*

结算单类型/合同类型 --> 每个类型都对应一个URL
甲方/乙方/项目 --> 每个都对应一个URL

结算单类型：
    product_value-产值报量,
    product_value_first-对甲报量,
    settle_verify-结算报审,
    project_decide-工程定案,
    material_week_rent_out-周转材租出结算,
    material_week_rent_in-周转材租入结算,
    equip_rent_out-设备租出结算,
    equip_rent_in-设备租入结算,
    labor_month-劳务分包月度结算,
    labor_node-劳务分包节点结算,
    labor_final-劳务分包最终结算,
    pro_month-专业分包月度结算,
    pro_node-专业分包节点结算,
    pro_final-专业分包最终结算,
    material_buy_in-物资采购结算,
    equip_buy_in-设备采购结算,
    beton_buy_in-混凝土采购结算,
    temp_equip-临时设备结算,
    big_equip_install_uninstall-大型设备安拆结算,
    law_cost-诉讼费结算,
    other_in-其他收入结算,
    other_out-其他支出结算,
    other_out_contract_month-其他支出合同过程结算,
    material_week_rent_out_company-周转材租出结算（公司）,
    material_week_rent_in_company-周转材租入结算（公司）,
    material_week_buy_in_company-周转材采购结算（公司）,
    equip_rent_out_company-设备组出结算（公司）,
    equip_rent_in_company-设备组出入结算（公司）,
    other_out_contract_final-其他支出合同最终结算。

合同类型：
    contraction-施工合同，
    prosub-专业分包合同，
    laborsub-劳务分包合同，
    materialPurchase-物资采购合同，
    concrete-混凝土合同，
    otherInContract-其他收入合同，
    otherOutContract-其他支出合同，
    equipmentPurchase-设备采购合同，
    equipmentRent-设备租赁合同，
    promat-周转材合同
    contractIn-收入合同
    contractOut-支出合同

甲方：
    partya

乙方：
    partyb

项目：
    project

*/
CREATE TABLE `ejc_conbase_bill_url_dict`
(
    `id`                bigint(20) NOT NULL COMMENT '主键ID',
    `create_user_code`  varchar(64)  DEFAULT NULL COMMENT '创建者账号',
    `create_user_name`  varchar(64)  DEFAULT NULL COMMENT '创建者名称',
    `create_time`       datetime     DEFAULT NULL COMMENT '创建时间',
    `update_user_code`  varchar(64)  DEFAULT NULL COMMENT '修改者账号',
    `update_user_name`  varchar(64)  DEFAULT NULL COMMENT '修改者名称',
    `update_time`       datetime     DEFAULT NULL COMMENT '修改时间',
    `dr`                tinyint(4)   DEFAULT NULL COMMENT '逻辑删除标识',
    `tenant_id`         bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `sync_es_flag`      tinyint(4)   DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
    `version`           int(11)      DEFAULT NULL COMMENT '乐观锁',
    `source_detail_url` varchar(512) DEFAULT NULL COMMENT '结算单来源',
    `source_type`       varchar(64)  DEFAULT NULL COMMENT '结算单类型/合同类型每个类型都对应一个URL。结算单类型：product_value-产值报量,product_value_first-对甲报量,settle_verify-结算报审,project_decide-工程定案,material_week_rent_out-周转材租出结算,material_week_rent_in-周转材租入结算,equip_rent_out-设备租出结算,equip_rent_in-设备租入结算,labor_month-劳务分包月度结算,labor_node-劳务分包节点结算,labor_final-劳务分包最终结算,pro_month-专业分包月度结算,pro_node-专业分包节点结算,pro_final-专业分包最终结算,material_buy_in-物资采购结算,equip_buy_in-设备采购结算,beton_buy_in-混凝土采购结算,temp_equip-临时设备结算,big_equip_install_uninstall-大型设备安拆结算,law_cost-诉讼费结算,other_in-其他收入结算,other_out-其他支出结算。合同类型：contraction-施工合同，prosub-专业分包合同，laborsub-劳务分包合同，materialPurchase-物资采购合同，concrete-混凝土合同，otherInContract-其他收入合同，otherOutContract-其他支出合同，equipmentPurchase-设备采购合同，equipmentRent-设备租赁合同，promat-周转材合同。甲方/乙方/项目每个都对应一个URL。',
    `ext1`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext2`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext3`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext4`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext5`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext6`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext7`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext8`              varchar(255) DEFAULT NULL COMMENT '扩展字段',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 COMMENT ='结算池-穿透URL中间表';

