create table ejc_conbase_contract_template_signatory_rect
(
    id                 bigint                            not null comment '主键ID'
        primary key,
    create_user_code   varchar(64)                       null comment '创建者账号',
    create_time        datetime                          null comment '创建时间',
    update_user_code   varchar(64)                       null comment '修改者账号',
    update_time        datetime                          null comment '修改时间',
    dr                 tinyint                           null comment '删除标识',
    tenant_id          bigint                            null comment '租户ID',
    sync_es_flag       tinyint                           null comment '是否同步es(1:是，0：否)',
    version            int                               null comment '乐观锁',
    party_name         varchar(64)                       not null comment '合同方名称',
    party_code         int(2)                            null comment '合同方编码',
    org_id             bigint                            null comment '签署方组织id(平台内,外部单位为空)',
    org_name           varchar(128)                      null comment '签署方组织名称',
    org_code           varchar(64)                       null comment '签署方组织编码',
    signature_type     tinyint                           null comment '签署方单位类型 0-内部单位，1-外部单位',
    seal_type          varchar(8)                        null comment '印章类型,COMPANY("企业公章"),LP("法定代表人章"),PERSONAL("个人签字")',
    keywords           varchar(64)                       null comment '定位关键字',
    timestamp_flag     tinyint(1)                        null comment '是否启用时间戳，0-否，1-是',
    timestamp_keywords varchar(64)                       null comment '时间戳关键字',
    across_flag        tinyint(1)                        null comment '是否开启骑缝章，0-否，1-是',
    across_setting     varchar(15) default 'ACROSS_PAGE' null comment '骑缝章设置，ACROSS_PAGE-添加至全部页；ACROSS_PAGE_ODD-添加至奇数页；默认全页',
    template_id        bigint                            null comment '模版id'
)
    comment '合同模板签章定位';