package com.ejianc.framework.core.util;

import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.config.RequestConfig.Builder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;
import java.util.Map.Entry;

/**
 * httpclient包装类,通用处理http,https协议
 * 
 * @author guominga 2018-02-13
 *
 */
@SuppressWarnings("deprecation")
public class HttpTookit {

	public static final int connTimeout = 10000;
	public static final int readTimeout = 10000;
	public static final String charset = "UTF-8";
	private static HttpClient client = null;

	static {
		PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
		cm.setMaxTotal(128);
		cm.setDefaultMaxPerRoute(128);
		client = HttpClients.custom().setConnectionManager(cm).build();
	}

	public static String postParameters(String url, String parameterStr)
			throws ConnectTimeoutException, SocketTimeoutException, Exception {
		return post(url, parameterStr, "application/x-www-form-urlencoded", charset, connTimeout, readTimeout, null);
	}

	public static String postParameters(String url, String parameterStr, String charset, Integer connTimeout,
			Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
		return post(url, parameterStr, "application/x-www-form-urlencoded", charset, connTimeout, readTimeout, null);
	}

	public static String postByJson(String url, String parameterStr)
			throws ConnectTimeoutException, SocketTimeoutException, Exception {
		return post(url, parameterStr, "application/json", charset, connTimeout, readTimeout, null);
	}

	public static String postByJson(String url, String parameterStr, Map<String, String> headers, Integer connTimeout,
									Integer readTimeout)
			throws ConnectTimeoutException, SocketTimeoutException, Exception {
		return post(url, parameterStr, "application/json", charset, connTimeout, readTimeout, headers);
	}

	public static String postParameters(String url, Map<String, String> params)
			throws ConnectTimeoutException, SocketTimeoutException, Exception {
		return postForm(url, params, null, null, connTimeout, readTimeout);
	}

	public static String postFormByJson(String url, Map<String, String> params, Map<String, String> headers)
			throws ClientProtocolException, GeneralSecurityException, IOException {
		return postForm(url, params, headers, "application/json", connTimeout, readTimeout);
	}

	public static String postParameters(String url, Map<String, String> params, Integer connTimeout,
			Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
		return postForm(url, params, null, "application/json", connTimeout, readTimeout);
	}

	public static String get(String url, HttpServletRequest req)
			throws ClientProtocolException, GeneralSecurityException, IOException {
		Map<String, String> headers = new HashMap<>();
		headers.put("authority", req.getHeader("authority"));
		headers.put("ejc-token", req.getHeader("ejc-token"));
		return get(url, null, headers);
	}

	public static String get(String url, Map<String, ?> params, HttpServletRequest req)
			throws ClientProtocolException, GeneralSecurityException, IOException {
		Map<String, String> headers = new HashMap<>();
		headers.put("authority", req.getHeader("authority"));
		headers.put("ejc-token", req.getHeader("ejc-token"));
		return get(url, params, headers);
	}

	public static String get(String url, Map<String, ?> params, Map<String, String> headers)
			throws ClientProtocolException, GeneralSecurityException, IOException {
		return get(url, charset, connTimeout, readTimeout, params, headers);
	}

	public static String get(String url, Map<String, ?> params, Map<String, String> headers, int connTimeout, int readTimeout)
			throws ClientProtocolException, GeneralSecurityException, IOException {
		return get(url, charset, connTimeout, readTimeout, params, headers);
	}

	public static String getAndHeader(String url, Map<String, ?> params)
			throws ClientProtocolException, GeneralSecurityException, IOException {
		return get(url, charset, connTimeout, readTimeout, params, getHeaders());
	}

	public static Map<String, String> getHeaders() {
		Map<String, String> headers = new HashMap<>();
		return headers;
	}

	/**
	 * 发送一个 Post 请求, 使用指定的字符集编码.
	 * 
	 * @param url
	 * @param body
	 *            RequestBody
	 * @param mimeType
	 *            例如 application/xml "application/x-www-form-urlencoded"
	 *            a=1&b=2&c=3
	 * @param charset
	 *            编码
	 * @param connTimeout
	 *            建立链接超时时间,毫秒.
	 * @param readTimeout
	 *            响应超时时间,毫秒.
	 * @return ResponseBody, 使用指定的字符集编码.
	 * @throws ConnectTimeoutException
	 *             建立链接超时异常
	 * @throws SocketTimeoutException
	 *             响应超时
	 * @throws Exception
	 */
	public static String post(String url, String body, String mimeType, String charset, Integer connTimeout,
			Integer readTimeout, Map<String, String> headers) throws ConnectTimeoutException, SocketTimeoutException, Exception {
		HttpClient client = null;
		HttpPost post = new HttpPost(url);
		HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes())
				.getRequest();
		String result = "";
		try {
			if (StringUtils.isNotBlank(body)) {
				HttpEntity entity = new StringEntity(body, ContentType.create(mimeType, charset));
				post.setEntity(entity);
			}
			// 设置参数
			Builder customReqConf = RequestConfig.custom();
			if (connTimeout != null) {
				customReqConf.setConnectTimeout(connTimeout);
			}
			if (readTimeout != null) {
				customReqConf.setSocketTimeout(readTimeout);
			}
			post.setConfig(customReqConf.build());
			if(null != headers) {
				String key = null;
				for(Iterator<String> it = headers.keySet().iterator();it.hasNext();) {
					key = it.next();
					post.addHeader(key, headers.get(key));
				}
			} else {
				post.addHeader("authority", request.getHeader("authority"));
				post.addHeader("ejc-token", request.getHeader("ejc-token"));
			}

			HttpResponse res;
			if (url.startsWith("https")) {
				// 执行 Https 请求.
				client = createSSLInsecureClient();
				res = client.execute(post);
			} else {
				// 执行 Http 请求.
				client = HttpTookit.client;
				res = client.execute(post);
			}
			result = IOUtils.toString(res.getEntity().getContent(), charset);
		} finally {
			post.releaseConnection();
			if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
				((CloseableHttpClient) client).close();
			}
		}
		return result;
	}

	/**
	 * 提交form表单
	 * 
	 * @param url
	 * @param params
	 * @param connTimeout
	 * @param readTimeout
	 * @return
	 * @throws GeneralSecurityException
	 * @throws IOException
	 * @throws ClientProtocolException
	 * @throws ConnectTimeoutException
	 * @throws SocketTimeoutException
	 * @throws Exception
	 */
	public static String postForm(String url, Map<String, String> params, Map<String, String> headers,
			String contentType, Integer connTimeout, Integer readTimeout)
			throws GeneralSecurityException, ClientProtocolException, IOException {

		HttpClient client = null;
		HttpPost post = new HttpPost(url);
		try {
			if (params != null && !params.isEmpty()) {
				List<NameValuePair> formParams = new ArrayList<org.apache.http.NameValuePair>();
				Set<Entry<String, String>> entrySet = params.entrySet();
				for (Entry<String, String> entry : entrySet) {
					formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
				}
				UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
				if (contentType != null)
					entity.setContentType(contentType);
				post.setEntity(entity);
			}

			if (headers != null && !headers.isEmpty()) {
				for (Entry<String, String> entry : headers.entrySet()) {
					post.addHeader(entry.getKey(), entry.getValue());
				}
			}
			// 设置参数
			Builder customReqConf = RequestConfig.custom();
			if (connTimeout != null) {
				customReqConf.setConnectTimeout(connTimeout);
			}
			if (readTimeout != null) {
				customReqConf.setSocketTimeout(readTimeout);
			}
			post.setConfig(customReqConf.build());
			HttpResponse res = null;
			if (url.startsWith("https")) {
				// 执行 Https 请求.
				client = createSSLInsecureClient();
				res = client.execute(post);
			} else {
				// 执行 Http 请求.
				client = HttpTookit.client;
				res = client.execute(post);
			}
			if (res.getStatusLine().getStatusCode() == 200) {
				return IOUtils.toString(res.getEntity().getContent(), "UTF-8");
			} else if (res.getStatusLine().getStatusCode() == 404) {
				throw new BusinessException("404, 不能连接到目标服务器!");
			}

		} finally {
			post.releaseConnection();
			if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
				((CloseableHttpClient) client).close();
			}
		}
		return null;
	}

	/**
	 * 发送一个 GET 请求
	 * 
	 * @param url
	 * @param charset
	 * @param connTimeout
	 *            建立链接超时时间,毫秒.
	 * @param readTimeout
	 *            响应超时时间,毫秒.
	 * @return
	 * @throws IllegalStateException
	 * @throws GeneralSecurityException
	 * @throws IOException
	 * @throws ClientProtocolException
	 * @throws ConnectTimeoutException
	 *             建立链接超时
	 * @throws SocketTimeoutException
	 *             响应超时
	 * @throws Exception
	 */
	private static String get(String url, String charset2, Integer conntimeout, Integer readtimeout,
			Map<String, ?> params, Map<String, String> headers)
			throws IllegalStateException, IOException, GeneralSecurityException {

		HttpClient client = null;
		if (params != null && params.size() > 0) {
			String[] paramsArray = params.keySet().toArray(new String[0]);
			for (int i = 0; i < paramsArray.length; ++i) {
				if (params.get(paramsArray[i]) != null)
					url += (i == 0 ? "?" : "&") + paramsArray[i] + "="
							+ URLEncoder.encode(params.get(paramsArray[i]).toString(), "utf-8");
			}
		}
		HttpGet get = new HttpGet(url);
		String result = "";
		try {
			// 设置参数
			Builder customReqConf = RequestConfig.custom();
			if (conntimeout != null) {
				customReqConf.setConnectTimeout(connTimeout);
			}
			if (readtimeout != null) {
				customReqConf.setSocketTimeout(readTimeout);
			}
			get.setConfig(customReqConf.build());
			if(null != headers && !headers.isEmpty()) {
				for(String key : headers.keySet()) {
					get.addHeader(key, headers.get(key));
				}
			}
			HttpResponse res = null;

			if (url.startsWith("https")) {
				// 执行 Https 请求.
				client = createSSLInsecureClient();
				res = client.execute(get);
			} else {
				// 执行 Http 请求.
				client = HttpTookit.client;
				res = client.execute(get);
			}

			result = IOUtils.toString(res.getEntity().getContent(), charset);
		} finally {
			get.releaseConnection();
			if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
				((CloseableHttpClient) client).close();
			}
		}
		return result;
	}

	/**
	 * 从 response 里获取 charset
	 * 
	 * @param ressponse
	 * @return
	 */
	@SuppressWarnings("unused")
	private static String getCharsetFromResponse(HttpResponse ressponse) {
		// Content-Type:text/html; charset=GBK
		if (ressponse.getEntity() != null && ressponse.getEntity().getContentType() != null
				&& ressponse.getEntity().getContentType().getValue() != null) {
			String contentType = ressponse.getEntity().getContentType().getValue();
			if (contentType.contains("charset=")) {
				return contentType.substring(contentType.indexOf("charset=") + 8);
			}
		}
		return null;
	}

	/**
	 * 创建 SSL连接
	 * 
	 * @return
	 * @throws GeneralSecurityException
	 */
	public static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
		try {
			SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
				public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
					return true;
				}
			}).build();

			SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier() {

				@Override
				public boolean verify(String arg0, SSLSession arg1) {
					return true;
				}

				@Override
				public void verify(String host, SSLSocket ssl) throws IOException {
				}

				@Override
				public void verify(String host, X509Certificate cert) throws SSLException {
				}

				@Override
				public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
				}

			});

			return HttpClients.custom().setSSLSocketFactory(sslsf).build();

		} catch (GeneralSecurityException e) {
			throw e;
		}
	}

	public static void main(String[] args) {
		try {
			String str = post("https://localhost:443/ssl/test.shtml", "name=12&page=34",
					"application/x-www-form-urlencoded", "UTF-8", 10000, 10000, null);
			// String str=
			// get("https://localhost:443/ssl/test.shtml?name=12&page=34","GBK");
			/*
			 * Map<String,String> map = new HashMap<String,String>();
			 * map.put("name", "111"); map.put("page", "222"); String str=
			 * postForm("https://localhost:443/ssl/test.shtml",map,null, 10000,
			 * 10000);
			 */
			System.out.println(str);
		} catch (ConnectTimeoutException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SocketTimeoutException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}