/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.io;

import com.ejianc.framework.core.kit.io.FileUtil;
import com.ejianc.framework.core.kit.io.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class URLResourceUtil {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String URL_PROTOCOL_FILE = "file";

    public static File asFile(String generalPath) throws IOException {
        if (StringUtils.startsWith((CharSequence)generalPath, (CharSequence)CLASSPATH_PREFIX)) {
            String resourceName = StringUtils.substringAfter((String)generalPath, (String)CLASSPATH_PREFIX);
            return URLResourceUtil.getFileByURL(ResourceUtil.asUrl(resourceName));
        }
        try {
            return URLResourceUtil.getFileByURL(new URL(generalPath));
        }
        catch (MalformedURLException ex) {
            return new File(generalPath);
        }
    }

    public static InputStream asStream(String generalPath) throws IOException {
        if (StringUtils.startsWith((CharSequence)generalPath, (CharSequence)CLASSPATH_PREFIX)) {
            String resourceName = StringUtils.substringAfter((String)generalPath, (String)CLASSPATH_PREFIX);
            return ResourceUtil.asStream(resourceName);
        }
        try {
            return FileUtil.asInputStream(URLResourceUtil.getFileByURL(new URL(generalPath)));
        }
        catch (MalformedURLException ex) {
            return FileUtil.asInputStream(generalPath);
        }
    }

    private static File getFileByURL(URL fileUrl) throws FileNotFoundException {
        Validate.notNull((Object)fileUrl, (String)"Resource URL must not be null", (Object[])new Object[0]);
        if (!URL_PROTOCOL_FILE.equals(fileUrl.getProtocol())) {
            throw new FileNotFoundException("URL cannot be resolved to absolute file path because it does not reside in the file system: " + fileUrl);
        }
        try {
            return new File(URLResourceUtil.toURI(fileUrl.toString()).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(fileUrl.getFile());
        }
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
    }
}

