/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.number;

public enum SizeUnit {
    BYTES,
    KILOBYTES,
    MEGABYTES,
    GIGABYTES;

    private final double BYTES_PER_KILOBYTE = 1024.0;
    private final double KILOBYTES_PER_MEGABYTE = 1024.0;
    private final double MEGABYTES_PER_GIGABYTE = 1024.0;

    public double toBytes(long input) {
        double bytes;
        switch (this) {
            case BYTES: {
                bytes = input;
                break;
            }
            case KILOBYTES: {
                bytes = (double)input * 1024.0;
                break;
            }
            case MEGABYTES: {
                bytes = (double)input * 1024.0 * 1024.0;
                break;
            }
            case GIGABYTES: {
                bytes = (double)input * 1024.0 * 1024.0 * 1024.0;
                break;
            }
            default: {
                throw new RuntimeException("No value '" + (Object)((Object)this) + "' recognized for enum MemoryUnit.");
            }
        }
        return bytes;
    }

    public double toKiloBytes(long input) {
        double kilobytes;
        switch (this) {
            case BYTES: {
                kilobytes = (double)input / 1024.0;
                break;
            }
            case KILOBYTES: {
                kilobytes = input;
                break;
            }
            case MEGABYTES: {
                kilobytes = (double)input * 1024.0;
                break;
            }
            case GIGABYTES: {
                kilobytes = (double)input * 1024.0 * 1024.0;
                break;
            }
            default: {
                throw new RuntimeException("No value '" + (Object)((Object)this) + "' recognized for enum MemoryUnit.");
            }
        }
        return kilobytes;
    }

    public double toMegaBytes(long input) {
        double megabytes;
        switch (this) {
            case BYTES: {
                megabytes = (double)input / 1024.0 / 1024.0;
                break;
            }
            case KILOBYTES: {
                megabytes = (double)input / 1024.0;
                break;
            }
            case MEGABYTES: {
                megabytes = input;
                break;
            }
            case GIGABYTES: {
                megabytes = (double)input * 1024.0;
                break;
            }
            default: {
                throw new RuntimeException("No value '" + (Object)((Object)this) + "' recognized for enum MemoryUnit.");
            }
        }
        return megabytes;
    }

    public double toGigaBytes(long input) {
        double gigabytes;
        switch (this) {
            case BYTES: {
                gigabytes = (double)input / 1024.0 / 1024.0 / 1024.0;
                break;
            }
            case KILOBYTES: {
                gigabytes = (double)input / 1024.0 / 1024.0;
                break;
            }
            case MEGABYTES: {
                gigabytes = (double)input / 1024.0;
                break;
            }
            case GIGABYTES: {
                gigabytes = input;
                break;
            }
            default: {
                throw new RuntimeException("No value '" + (Object)((Object)this) + "' recognized for enum MemoryUnit.");
            }
        }
        return gigabytes;
    }
}

