/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.security;

import com.ejianc.framework.core.kit.base.ExceptionUtil;
import com.ejianc.framework.core.kit.number.RandomUtil;
import com.ejianc.framework.core.kit.text.Charsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_ALG = "AES/CBC/PKCS5Padding";
    private static final String HMACSHA1_ALG = "HmacSHA1";
    private static final int DEFAULT_HMACSHA1_KEYSIZE = 160;
    private static final int DEFAULT_AES_KEYSIZE = 128;
    private static final int DEFAULT_IVSIZE = 16;
    private static SecureRandom random = RandomUtil.secureRandom();

    public static byte[] hmacSha1(byte[] input, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, HMACSHA1_ALG);
            Mac mac = Mac.getInstance(HMACSHA1_ALG);
            mac.init(secretKey);
            return mac.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtil.unchecked(e);
        }
    }

    public static boolean isMacValid(byte[] expected, byte[] input, byte[] key) {
        byte[] actual = CryptoUtil.hmacSha1(input, key);
        return Arrays.equals(expected, actual);
    }

    public static byte[] generateHmacSha1Key() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(HMACSHA1_ALG);
            keyGenerator.init(160);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtil.unchecked(e);
        }
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key) {
        return CryptoUtil.aes(input, key, 1);
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, byte[] iv) {
        return CryptoUtil.aes(input, key, iv, 1);
    }

    public static String aesDecrypt(byte[] input, byte[] key) {
        byte[] decryptResult = CryptoUtil.aes(input, key, 2);
        return new String(decryptResult, Charsets.UTF_8);
    }

    public static String aesDecrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] decryptResult = CryptoUtil.aes(input, key, iv, 2);
        return new String(decryptResult, Charsets.UTF_8);
    }

    private static byte[] aes(byte[] input, byte[] key, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES_ALG);
            Cipher cipher = Cipher.getInstance(AES_ALG);
            cipher.init(mode, secretKey);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtil.unchecked(e);
        }
    }

    private static byte[] aes(byte[] input, byte[] key, byte[] iv, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES_ALG);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(AES_CBC_ALG);
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtil.unchecked(e);
        }
    }

    public static byte[] generateAesKey() {
        return CryptoUtil.generateAesKey(128);
    }

    public static byte[] generateAesKey(int keysize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES_ALG);
            keyGenerator.init(keysize);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtil.unchecked(e);
        }
    }

    public static byte[] generateIV() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }
}

