/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.time;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.time.FastDateFormat;

public class CachingDateFormatter {
    private FastDateFormat fastDateFormat;
    private AtomicReference<CachedTime> cachedTime;
    private boolean onSecond;

    public CachingDateFormatter(String pattern) {
        this(FastDateFormat.getInstance((String)pattern));
    }

    public CachingDateFormatter(FastDateFormat fastDateFormat) {
        this.fastDateFormat = fastDateFormat;
        this.onSecond = fastDateFormat.getPattern().indexOf("SSS") == -1;
        long current = System.currentTimeMillis();
        this.cachedTime = new AtomicReference<CachedTime>(new CachedTime(current, fastDateFormat.format(current)));
    }

    public String format(long timestampMillis) {
        long timestamp;
        CachedTime cached = this.cachedTime.get();
        long l = timestamp = this.onSecond ? timestampMillis / 1000L : timestampMillis;
        if (timestamp != cached.timestamp) {
            CachedTime newCachedTime = new CachedTime(timestamp, this.fastDateFormat.format(timestampMillis));
            this.cachedTime.compareAndSet(cached, newCachedTime);
            cached = newCachedTime;
        }
        return cached.formatted;
    }

    static final class CachedTime {
        public long timestamp;
        public String formatted;

        public CachedTime(long timestamp, String formatted) {
            this.timestamp = timestamp;
            this.formatted = formatted;
        }
    }
}

