/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.client.EjcConfigClientHealthProperties;
import org.springframework.cloud.config.client.EjcConfigClientProperties;
import org.springframework.cloud.config.client.EjcConfigClientWatch;
import org.springframework.cloud.config.client.EjcConfigServerHealthIndicator;
import org.springframework.cloud.config.client.EjcConfigServicePropertySourceLocator;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class EjcConfigClientAutoConfiguration {
    @Bean
    public EjcConfigClientProperties configClientProperties(Environment environment, ApplicationContext context) {
        if (context.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getParent(), EjcConfigClientProperties.class).length > 0) {
            return (EjcConfigClientProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)context.getParent(), EjcConfigClientProperties.class);
        }
        EjcConfigClientProperties client = new EjcConfigClientProperties(environment);
        return client;
    }

    @Bean
    public EjcConfigClientHealthProperties configClientHealthProperties() {
        return new EjcConfigClientHealthProperties();
    }

    @Configuration
    @ConditionalOnClass(value={ContextRefresher.class})
    @ConditionalOnBean(value={ContextRefresher.class})
    @ConditionalOnProperty(value={"spring.cloud.config.watch.enabled"})
    protected static class ConfigClientWatchConfiguration {
        protected ConfigClientWatchConfiguration() {
        }

        @Bean
        public EjcConfigClientWatch configClientWatch(ContextRefresher contextRefresher) {
            return new EjcConfigClientWatch(contextRefresher);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnBean(value={EjcConfigServicePropertySourceLocator.class})
    @ConditionalOnProperty(value={"health.config.enabled"}, matchIfMissing=true)
    protected static class ConfigServerHealthIndicatorConfiguration {
        protected ConfigServerHealthIndicatorConfiguration() {
        }

        @Bean
        public EjcConfigServerHealthIndicator clientConfigServerHealthIndicator(EjcConfigServicePropertySourceLocator locator, EjcConfigClientHealthProperties properties, Environment environment) {
            return new EjcConfigServerHealthIndicator(locator, environment, properties);
        }
    }
}

