/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.client.EjcConfigClientStateHolder;
import org.springframework.cloud.config.client.EjcConfigServicePropertySourceLocator;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.StringUtils;

public class EjcConfigClientWatch
implements Closeable,
EnvironmentAware {
    private static Log log = LogFactory.getLog(EjcConfigServicePropertySourceLocator.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ContextRefresher refresher;
    private Environment environment;

    public EjcConfigClientWatch(ContextRefresher refresher) {
        this.refresher = refresher;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    public void start() {
        this.running.compareAndSet(false, true);
    }

    @Scheduled(initialDelayString="${spring.cloud.config.watch.initialDelay:180000}", fixedDelayString="${spring.cloud.config.watch.delay:500}")
    public void watchConfigServer() {
        if (this.running.get()) {
            String newState = this.environment.getProperty("config.client.state");
            String oldState = EjcConfigClientStateHolder.getState();
            if (this.stateChanged(oldState, newState)) {
                EjcConfigClientStateHolder.setState(newState);
                this.refresher.refresh();
            }
        }
    }

    boolean stateChanged(String oldState, String newState) {
        return !StringUtils.hasText((String)oldState) && StringUtils.hasText((String)newState) || StringUtils.hasText((String)oldState) && !oldState.equals(newState);
    }

    @Override
    public void close() {
        this.running.compareAndSet(true, false);
    }
}

