/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.config.client.EjcConfigClientHealthProperties;
import org.springframework.cloud.config.client.EjcConfigServicePropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EjcConfigServerHealthIndicator
extends AbstractHealthIndicator {
    private EjcConfigServicePropertySourceLocator locator;
    private EjcConfigClientHealthProperties properties;
    private Environment environment;
    private long lastAccess = 0L;
    private PropertySource<?> cached;

    public EjcConfigServerHealthIndicator(EjcConfigServicePropertySourceLocator locator, Environment environment, EjcConfigClientHealthProperties properties) {
        this.environment = environment;
        this.locator = locator;
        this.properties = properties;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        PropertySource<?> propertySource = this.getPropertySource();
        builder.up();
        if (propertySource instanceof CompositePropertySource) {
            ArrayList<String> sources = new ArrayList<String>();
            for (PropertySource ps : ((CompositePropertySource)propertySource).getPropertySources()) {
                sources.add(ps.getName());
            }
            builder.withDetail("propertySources", sources);
        } else if (propertySource != null) {
            builder.withDetail("propertySources", (Object)propertySource.toString());
        } else {
            builder.unknown().withDetail("error", (Object)"no property sources located");
        }
    }

    private PropertySource<?> getPropertySource() {
        long accessTime = System.currentTimeMillis();
        if (this.isCacheStale(accessTime)) {
            this.lastAccess = accessTime;
            this.cached = this.locator.locate(this.environment);
        }
        return this.cached;
    }

    private boolean isCacheStale(long accessTime) {
        if (this.cached == null) {
            return true;
        }
        return accessTime - this.lastAccess >= this.properties.getTimeToLive();
    }
}

