/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.EjcConfigClientProperties;
import org.springframework.cloud.config.client.EjcConfigServicePropertySourceLocator;
import org.springframework.cloud.config.client.EjcRetryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;

@Configuration
@EnableConfigurationProperties
public class EjcConfigServiceBootstrapConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    public EjcConfigClientProperties configClientProperties() {
        EjcConfigClientProperties client = new EjcConfigClientProperties((Environment)this.environment);
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={EjcConfigServicePropertySourceLocator.class})
    @ConditionalOnProperty(value={"spring.cloud.config.enabled"}, matchIfMissing=true)
    public EjcConfigServicePropertySourceLocator configServicePropertySource(EjcConfigClientProperties properties) {
        EjcConfigServicePropertySourceLocator locator = new EjcConfigServicePropertySourceLocator(properties);
        return locator;
    }

    @ConditionalOnProperty(value={"spring.cloud.config.fail-fast"})
    @ConditionalOnClass(value={Retryable.class, Aspect.class, AopAutoConfiguration.class})
    @Configuration
    @EnableRetry(proxyTargetClass=true)
    @Import(value={AopAutoConfiguration.class})
    @EnableConfigurationProperties(value={EjcRetryProperties.class})
    protected static class RetryConfiguration {
        protected RetryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"configServerRetryInterceptor"})
        public RetryOperationsInterceptor configServerRetryInterceptor(EjcRetryProperties properties) {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().backOffOptions(properties.getInitialInterval(), properties.getMultiplier(), properties.getMaxInterval()).maxAttempts(properties.getMaxAttempts()).build();
        }
    }
}

