/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.http;

import com.ejianc.framework.core.http.Header;
import com.ejianc.framework.core.http.HttpConfig;
import com.ejianc.framework.core.http.HttpResponseHandler;
import com.ejianc.framework.core.http.NameValuePair;
import com.ejianc.framework.core.http.Util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private OkHttpClient client;
    private Map<String, Call> requestHandleMap = null;
    private CacheControl cacheControl = null;
    private HttpConfig httpConfig = new HttpConfig();

    private HttpClientUtils() {
        this.client = new OkHttpClient.Builder().connectTimeout((long)this.httpConfig.getConnectTimeout(), TimeUnit.SECONDS).writeTimeout((long)this.httpConfig.getWriteTimeout(), TimeUnit.SECONDS).readTimeout((long)this.httpConfig.getReadTimeout(), TimeUnit.SECONDS).build();
        this.requestHandleMap = Collections.synchronizedMap(new WeakHashMap());
        this.cacheControl = new CacheControl.Builder().noStore().noCache().build();
    }

    public static HttpClientUtils getInstance() {
        return HttpClientUtilsInstance.instance;
    }

    public void get(String url, HttpResponseHandler callback) {
        this.get(url, null, callback, true);
    }

    public void get(String url, Header[] header, HttpResponseHandler callback) {
        this.get(url, header, callback, true);
    }

    public void get(String url, Header[] header, HttpResponseHandler callback, boolean autoCancel) {
        this.add(url, this.getBuilder(url, header, callback), autoCancel);
    }

    private Call getBuilder(String url, Header[] header, HttpResponseHandler responseCallback) {
        url = Util.getMosaicParameter(url, this.httpConfig.getCommonField());
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.get();
        return this.execute(builder, header, responseCallback);
    }

    public String getSync(String url) {
        return this.getSync(url, null);
    }

    public String getSync(String url, Header[] header) {
        url = Util.getMosaicParameter(url, this.httpConfig.getCommonField());
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.get();
        byte[] bytes = this.execute(builder, header);
        try {
            String str = new String(bytes, "utf-8");
            return str;
        }
        catch (Exception e) {
            this.printLog("getSync HTTPCaller:" + e.toString());
            return null;
        }
    }

    public void post(String url, List<NameValuePair> params, HttpResponseHandler callback) {
        this.post(url, null, params, callback, true);
    }

    public void post(String url, Header[] header, List<NameValuePair> params, HttpResponseHandler callback) {
        this.post(url, header, params, callback, true);
    }

    public void post(String url, Header[] header, List<NameValuePair> params, HttpResponseHandler callback, boolean autoCancel) {
        this.add(url, this.postBuilder(url, header, params, callback), autoCancel);
    }

    public void postJson(String url, Header[] header, String jsonParam, HttpResponseHandler callback, boolean autoCancel) {
        this.add(url, this.postJsonBuilder(url, header, jsonParam, callback), autoCancel);
    }

    public String postSync(String url, List<NameValuePair> form) {
        return this.postSync(url, form, null);
    }

    public String postSync(String url, List<NameValuePair> form, Header[] header) {
        Request.Builder builder = this.getRequestBuild(url, form);
        byte[] bytes = this.execute(builder, header);
        try {
            String result = new String(bytes, "utf-8");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Call postJsonBuilder(String url, Header[] header, String jsonParam, HttpResponseHandler callback) {
        try {
            Request.Builder builder = this.getRequestJsonBuild(url, jsonParam);
            return this.execute(builder, header, callback);
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onFailure(-1, e.getMessage().getBytes());
            }
            return null;
        }
    }

    private Call postBuilder(String url, Header[] header, List<NameValuePair> form, HttpResponseHandler responseCallback) {
        try {
            Request.Builder builder = this.getRequestBuild(url, form);
            return this.execute(builder, header, responseCallback);
        }
        catch (Exception e) {
            if (responseCallback != null) {
                responseCallback.onFailure(-1, e.getMessage().getBytes());
            }
            return null;
        }
    }

    private Request.Builder getRequestJsonBuild(String url, String jsonParam) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)jsonParam);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.post(requestBody);
        return builder;
    }

    private Request.Builder getRequestBuild(String url, List<NameValuePair> form) {
        if (form == null) {
            form = new ArrayList<NameValuePair>();
        }
        form.addAll(this.httpConfig.getCommonField());
        FormBody.Builder formBuilder = new FormBody.Builder();
        for (NameValuePair item : form) {
            if (StringUtils.isBlank((CharSequence)item.getValue())) {
                this.printLog("\u5b57\u6bb5:" + item.getName() + "\u7684\u503c\u4e3anull");
                continue;
            }
            formBuilder.add(item.getName(), item.getValue());
        }
        FormBody requestBody = formBuilder.build();
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.post((RequestBody)requestBody);
        return builder;
    }

    private Call execute(Request.Builder builder, Header[] header, Callback responseCallback) {
        Call call = this.getCall(builder, header);
        if (call != null) {
            call.enqueue(responseCallback);
        }
        return call;
    }

    private byte[] execute(Request.Builder builder, Header[] header) {
        Call call = this.getCall(builder, header);
        byte[] body = "".getBytes();
        try {
            Response response = call.execute();
            body = response.body().bytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return body;
    }

    private Call getCall(Request.Builder builder, Header[] header) {
        boolean hasUa = false;
        if (header == null) {
            builder.header("Connection", "close");
            builder.header("Accept", "*/*");
        } else {
            for (Header h : header) {
                builder.header(h.getName(), h.getValue());
                if (hasUa || !h.getName().equals("User-Agent")) continue;
                hasUa = true;
            }
        }
        if (!hasUa && StringUtils.isNotBlank((CharSequence)this.httpConfig.getUserAgent())) {
            builder.header("User-Agent", this.httpConfig.getUserAgent());
        }
        Request request = builder.cacheControl(this.cacheControl).build();
        return this.client.newCall(request);
    }

    private void autoCancel(String function) {
        Call call = this.requestHandleMap.remove(function);
        if (call != null) {
            call.cancel();
        }
    }

    private void add(String url, Call call, boolean autoCancel) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            if (url.contains("?")) {
                url = url.substring(0, url.indexOf("?"));
            }
            if (autoCancel) {
                this.autoCancel(url);
            }
            this.requestHandleMap.put(url, call);
        }
    }

    private void printLog(String content) {
        if (this.httpConfig.isDebug()) {
            logger.debug(this.httpConfig.getTagName(), (Object)content);
        }
    }

    public void updateCommonField(String key, String value) {
        this.httpConfig.updateCommonField(key, value);
    }

    public void removeCommonField(String key) {
        this.httpConfig.removeCommonField(key);
    }

    public void addCommonField(String key, String value) {
        this.httpConfig.addCommonField(key, value);
    }

    private static class HttpClientUtilsInstance {
        private static final HttpClientUtils instance = new HttpClientUtils();

        private HttpClientUtilsInstance() {
        }
    }
}

