package com.ejianc.framework.core.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Map;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.core.io.ClassPathResource;

import net.sf.jxls.transformer.XLSTransformer;

public class ExcelExport {
	private ExcelExport() {
		System.out.println("============jxls导出===========");
	}

	private static ExcelExport excelExport = null;
	public synchronized static ExcelExport getInstance() {
		if (excelExport == null) {
			excelExport = new ExcelExport();
		}
		return excelExport;
	}

	/**
	 *            模板名称
	 * @param data
	 *            带导出的数据
	 * @param exitsName
	 *            导出excel的名称
	 * @throws InvalidFormatException
	 */
	public void export(String exitsName, Map<String, Object> data, HttpServletResponse response) {
		XLSTransformer transformer = new XLSTransformer();
		ServletOutputStream outputStream = null;
		try {
			SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatUtil.PATTERN_ISO_ON_DATE);
			SimpleDateFormat timeFormat = new SimpleDateFormat(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND);
			data.put("dateFormat",dateFormat);
			data.put("timeFormat",timeFormat);
			ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
			outputStream = response.getOutputStream();
			Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);
			workbook.write(outputStream);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {

			if (outputStream != null) {
				try {
					outputStream.flush();
					outputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
