/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.exception;

import com.ejianc.framework.core.exception.ErrorEnum;
import com.ejianc.framework.core.exception.IErrorEnum;
import com.ejianc.framework.core.exception.RootRuntimeException;

public class BusinessException
extends RootRuntimeException {
    private static final long serialVersionUID = 1L;
    private Integer errorCode;
    private String errorMsg;
    private Throwable cause;

    public BusinessException() {
    }

    public BusinessException(String message) {
        this(ErrorEnum.STATUS_COMMON_EXCEPTION.getErrorCode(), message);
    }

    public BusinessException(String message, Throwable cause) {
        this(ErrorEnum.STATUS_COMMON_EXCEPTION.getErrorCode(), message, cause);
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

    protected BusinessException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public BusinessException(Integer errorCode) {
        String errorMsg = ErrorEnum.getErrorMsgByCode(errorCode);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public BusinessException(Integer errorCode, String msgDetail) {
        this.errorCode = errorCode;
        this.errorMsg = msgDetail;
    }

    public BusinessException(IErrorEnum error) {
        this.errorCode = error.getErrorCode();
        this.errorMsg = error.getErrorMsg();
    }

    public BusinessException(Integer errorCode, Throwable cause) {
        String errorMsg = ErrorEnum.getErrorMsgByCode(errorCode);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.cause = cause;
    }

    public BusinessException(Integer errorCode, String errorMsg, Throwable cause) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.cause = cause;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        return null != this.errorMsg ? this.errorMsg : super.getMessage();
    }
}

