/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.base;

import com.ejianc.framework.core.kit.base.BooleanUtil;
import com.ejianc.framework.core.kit.number.NumberUtil;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class SystemPropertiesUtil {
    public static Boolean getBoolean(String name) {
        String stringResult = System.getProperty(name);
        return BooleanUtil.toBooleanObject(stringResult);
    }

    public static Boolean getBoolean(String name, Boolean defaultValue) {
        String stringResult = System.getProperty(name);
        return BooleanUtil.toBooleanObject(stringResult, defaultValue);
    }

    public static String getString(String name) {
        return System.getProperty(name);
    }

    public static String getString(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public static Integer getInteger(String name) {
        return Integer.getInteger(name);
    }

    public static Integer getInteger(String name, Integer defaultValue) {
        return Integer.getInteger(name, defaultValue);
    }

    public static Long getLong(String name) {
        return Long.getLong(name);
    }

    public static Long getLong(String name, Long defaultValue) {
        return Long.getLong(name, defaultValue);
    }

    public static Double getDouble(String propertyName) {
        return NumberUtil.toDoubleObject(System.getProperty(propertyName), null);
    }

    public static Double getDouble(String propertyName, Double defaultValue) {
        Double propertyValue = NumberUtil.toDoubleObject(System.getProperty(propertyName), null);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static String getString(String propertyName, String envName, String defaultValue) {
        SystemPropertiesUtil.checkEnvName(envName);
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = System.getenv(envName);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static Integer getInteger(String propertyName, String envName, Integer defaultValue) {
        SystemPropertiesUtil.checkEnvName(envName);
        Integer propertyValue = NumberUtil.toIntObject(System.getProperty(propertyName), null);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = NumberUtil.toIntObject(System.getenv(envName), null);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static Long getLong(String propertyName, String envName, Long defaultValue) {
        SystemPropertiesUtil.checkEnvName(envName);
        Long propertyValue = NumberUtil.toLongObject(System.getProperty(propertyName), null);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = NumberUtil.toLongObject(System.getenv(envName), null);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static Double getDouble(String propertyName, String envName, Double defaultValue) {
        SystemPropertiesUtil.checkEnvName(envName);
        Double propertyValue = NumberUtil.toDoubleObject(System.getProperty(propertyName), null);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = NumberUtil.toDoubleObject(System.getenv(envName), null);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static Boolean getBoolean(String propertyName, String envName, Boolean defaultValue) {
        SystemPropertiesUtil.checkEnvName(envName);
        Boolean propertyValue = BooleanUtil.toBooleanObject(System.getProperty(propertyName), null);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = BooleanUtil.toBooleanObject(System.getenv(envName), null);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    private static void checkEnvName(String envName) {
        if (envName == null || envName.indexOf(46) != -1) {
            throw new IllegalArgumentException("envName " + envName + "is null or has dot which is not valid");
        }
    }

    public static synchronized void registerSystemPropertiesListener(PropertiesListener listener) {
        Properties currentProperties = System.getProperties();
        if (!(currentProperties instanceof ListenableProperties)) {
            ListenableProperties newProperties = new ListenableProperties(currentProperties);
            System.setProperties(newProperties);
            currentProperties = newProperties;
        }
        ((ListenableProperties)currentProperties).register(listener);
    }

    public static abstract class PropertiesListener {
        protected String propertyName;

        public PropertiesListener(String propertyName) {
            this.propertyName = propertyName;
        }

        public abstract void onChange(String var1, String var2);
    }

    public static class ListenableProperties
    extends Properties {
        private static final long serialVersionUID = -8282465702074684324L;
        protected transient List<PropertiesListener> listeners = new CopyOnWriteArrayList<PropertiesListener>();

        public ListenableProperties(Properties properties) {
            super(properties);
        }

        public void register(PropertiesListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            Object result = this.put(key, value);
            for (PropertiesListener listener : this.listeners) {
                if (!listener.propertyName.equals(key)) continue;
                listener.onChange(key, value);
            }
            return result;
        }
    }
}

