/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.collection.type;

import com.ejianc.framework.core.kit.collection.type.primitive.IntObjectHashMap;
import com.ejianc.framework.core.kit.collection.type.primitive.LongObjectHashMap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.util.concurrent.AtomicLongMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class MoreMaps {
    public static <K, V> ConcurrentMap<K, V> createWeakKeyConcurrentMap(int initialCapacity, int concurrencyLevel) {
        return new MapMaker().weakKeys().initialCapacity(initialCapacity).concurrencyLevel(concurrencyLevel).makeMap();
    }

    public static <K, V> ConcurrentMap<K, V> createWeakValueConcurrentMap(int initialCapacity, int concurrencyLevel) {
        return new MapMaker().weakValues().initialCapacity(initialCapacity).concurrencyLevel(concurrencyLevel).makeMap();
    }

    public static <V> IntObjectHashMap<V> createPrimitiveIntKeyMap(int initialCapacity, float loadFactor) {
        return new IntObjectHashMap(initialCapacity, loadFactor);
    }

    public static <V> LongObjectHashMap<V> createPrimitiveLongKeyMap(int initialCapacity, float loadFactor) {
        return new LongObjectHashMap(initialCapacity, loadFactor);
    }

    public static <K> HashMap<K, MutableInt> createMutableIntValueMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    public static <K> HashMap<K, MutableLong> createMutableLongValueMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    public static <E> AtomicLongMap<E> createConcurrentCounterMap() {
        return AtomicLongMap.create();
    }

    public static <K, V> ArrayListMultimap<K, V> createListMultiValueMap(int expectedKeys, int expectedValuesPerKey) {
        return ArrayListMultimap.create((int)expectedKeys, (int)expectedValuesPerKey);
    }

    public static <K, V extends Comparable> SortedSetMultimap<K, V> createSortedSetMultiValueMap() {
        return MultimapBuilder.hashKeys().treeSetValues().build();
    }

    public static <K, V> SortedSetMultimap<K, V> createSortedSetMultiValueMap(Comparator<V> comparator) {
        return (SortedSetMultimap)MultimapBuilder.hashKeys().treeSetValues(comparator);
    }

    public static <K extends Comparable, V> TreeRangeMap<K, V> createRangeMap() {
        return TreeRangeMap.create();
    }
}

