/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentTools {
    public static final String CUSTOMER_CHANNEL = "customer_into_channel";
    public static final String DINGDING_CHANNEL = "dingding_channel";
    public static final String SELF_CHANNEL = "self_channel";
    public static final String WEIXINEE_CHANNEL = "weixinee_channel";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${ejc.metadata.web.serverName:null}")
    private String metaDataBaseUrl;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public String getBaseHost() {
        String customerChannel;
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (tenantid != null && tenantid > 0L && DINGDING_CHANNEL.equals(customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)tenantid))) {
            return Utils.getDingDingDomain() + "/";
        }
        return this.baseHost;
    }

    public String getMetaDataBaseUrl() {
        String customerChannel;
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (tenantid != null && tenantid > 0L && DINGDING_CHANNEL.equals(customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)tenantid))) {
            return Utils.getDingDingDomain() + "/";
        }
        return this.metaDataBaseUrl;
    }

    public String getBaseHost(Long tenantid) {
        String customerChannel;
        if (tenantid != null && tenantid > 0L && DINGDING_CHANNEL.equals(customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)tenantid))) {
            return Utils.getDingDingDomain() + "/";
        }
        return this.baseHost;
    }

    public String getMetaDataBaseUrl(Long tenantid) {
        String customerChannel;
        if (tenantid != null && tenantid > 0L && DINGDING_CHANNEL.equals(customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)tenantid))) {
            return Utils.getDingDingDomain() + "/";
        }
        return this.metaDataBaseUrl;
    }
}

