/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.Utils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentTools {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentTools.class);
    public static final String CUSTOMER_CHANNEL = "customer_into_channel";
    public static final String DINGDING_CHANNEL = "dingding_channel";
    public static final String SELF_CHANNEL = "self_channel";
    public static final String WEIXINEE_CHANNEL = "weixinee_channel";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${ejc.metadata.web.serverName:null}")
    private String metaDataBaseUrl;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public void clearCustomerChannel(String tenantId) {
        this.redisTemplate.opsForHash().delete((Object)CUSTOMER_CHANNEL, new Object[]{tenantId});
    }

    public void putCustomerChannel(Long tenantId, String channel) {
        String customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)(tenantId + ""));
        if (StringUtils.isBlank((CharSequence)customerChannel) && StringUtils.isNotBlank((CharSequence)channel)) {
            this.redisTemplate.opsForHash().put((Object)CUSTOMER_CHANNEL, (Object)(tenantId + ""), (Object)channel);
        }
    }

    public String getBaseHost() {
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (tenantid != null && tenantid > 0L) {
            try {
                String customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)(tenantid + ""));
                if (DINGDING_CHANNEL.equals(customerChannel)) {
                    return Utils.getDingDingDomain() + "/";
                }
            }
            catch (Exception e) {
                logger.info("redis connection exception");
            }
        }
        return this.baseHost;
    }

    public String getMetaDataBaseUrl() {
        Long tenantid = InvocationInfoProxy.getTenantid();
        if (tenantid != null && tenantid > 0L) {
            try {
                String customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)(tenantid + ""));
                if (DINGDING_CHANNEL.equals(customerChannel)) {
                    return Utils.getDingDingDomain() + "/";
                }
            }
            catch (Exception e) {
                logger.info("redis connection exception");
            }
        }
        return this.metaDataBaseUrl;
    }

    public String getBaseHost(Long tenantid) {
        if (tenantid != null && tenantid > 0L) {
            try {
                String customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)(tenantid + ""));
                if (DINGDING_CHANNEL.equals(customerChannel)) {
                    return Utils.getDingDingDomain() + "/";
                }
            }
            catch (Exception e) {
                logger.info("redis connection exception");
            }
        }
        return this.baseHost;
    }

    public String getMetaDataBaseUrl(Long tenantid) {
        if (tenantid != null && tenantid > 0L) {
            try {
                String customerChannel = (String)this.redisTemplate.opsForHash().get((Object)CUSTOMER_CHANNEL, (Object)(tenantid + ""));
                if (DINGDING_CHANNEL.equals(customerChannel)) {
                    return Utils.getDingDingDomain() + "/";
                }
            }
            catch (Exception e) {
                logger.info("redis connection exception");
            }
        }
        return this.metaDataBaseUrl;
    }
}

