/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;

public class ImgUtils {
    public static byte[] compressPic(String imgUrl, InputStream inputStream) {
        try {
            System.out.println("\u56fe\u7247\u538b\u7f29\u5f00\u59cb----\u6e90\u56fe\u7247\uff1a" + imgUrl + "\uff0cinputStream \uff1a" + inputStream);
            BufferedImage bim = null;
            if (StringUtils.isNotEmpty((CharSequence)imgUrl)) {
                bim = ImageIO.read(new URL(imgUrl));
            }
            if (inputStream != null) {
                bim = ImageIO.read(inputStream);
            }
            if (bim == null) {
                return null;
            }
            int srcWidth = bim.getWidth();
            int srcHeight = bim.getHeight();
            Thumbnails.Builder builder = inputStream != null ? Thumbnails.of((BufferedImage[])new BufferedImage[]{bim}).outputFormat("jpg") : Thumbnails.of((URL[])new URL[]{new URL(imgUrl)}).outputFormat("jpg");
            if (srcWidth > 4000 || srcHeight > 4000) {
                builder.size(4000, 4000);
            } else {
                builder.size(srcWidth, srcHeight);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            builder.toOutputStream((OutputStream)bos);
            byte[] bytes = ImgUtils.compressPicCycle(bos.toByteArray(), 3072L, 0.8);
            System.out.println("\u56fe\u7247\u538b\u7f29\u5b8c\u6210\uff01");
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] compressPic(String imgUrl, InputStream inputStream, Integer desMaxWidth, Integer desMaxHeight, Integer desFileSize) {
        if (desMaxWidth == null) {
            desMaxWidth = 4000;
        }
        if (desMaxHeight == null) {
            desMaxHeight = 4000;
        }
        if (desFileSize == null) {
            desFileSize = 3;
        }
        try {
            System.out.println("\u56fe\u7247\u538b\u7f29\u5f00\u59cb----\u6e90\u56fe\u7247\uff1a" + imgUrl + "\uff0cinputStream \uff1a" + inputStream);
            BufferedImage bim = null;
            if (StringUtils.isNotEmpty((CharSequence)imgUrl)) {
                bim = ImageIO.read(new URL(imgUrl));
            }
            if (inputStream != null) {
                bim = ImageIO.read(inputStream);
            }
            if (bim == null) {
                return null;
            }
            int srcWidth = bim.getWidth();
            int srcHeight = bim.getHeight();
            Thumbnails.Builder builder = inputStream != null ? Thumbnails.of((BufferedImage[])new BufferedImage[]{bim}).outputFormat("jpg") : Thumbnails.of((URL[])new URL[]{new URL(imgUrl)}).outputFormat("jpg");
            if (srcWidth > desMaxWidth || srcHeight > desMaxHeight) {
                builder.size(desMaxWidth.intValue(), desMaxHeight.intValue());
            } else {
                builder.size(srcWidth, srcHeight);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            builder.toOutputStream((OutputStream)bos);
            byte[] bytes = ImgUtils.compressPicCycle(bos.toByteArray(), (long)desFileSize.intValue() * 1024L, 0.8);
            System.out.println("\u56fe\u7247\u538b\u7f29\u5b8c\u6210\uff01");
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] compressPicCycle(byte[] bytes, long desFileSize, double accuracy) throws IOException {
        long srcFileSizeJPG = bytes.length;
        if (srcFileSizeJPG <= desFileSize * 1024L) {
            return bytes;
        }
        BufferedImage bim = ImageIO.read(new ByteArrayInputStream(bytes));
        int srcWidth = bim.getWidth();
        int srcHeight = bim.getHeight();
        int desWidth = new BigDecimal(srcWidth).multiply(new BigDecimal(accuracy)).intValue();
        int desHeight = new BigDecimal(srcHeight).multiply(new BigDecimal(accuracy)).intValue();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(bytes)}).size(desWidth, desHeight).outputQuality(accuracy).toOutputStream((OutputStream)bos);
        return ImgUtils.compressPicCycle(bos.toByteArray(), desFileSize, accuracy);
    }
}

