/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.ejianc.framework.core.util.DateFormater;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    RandomStringUtils randowms;
    public static final char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] chars_without_num = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] upper_chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] upper_chars_without_num = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] nums = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static long counter = 0L;
    private static final Pattern mailPattern = Pattern.compile("^[a-zA-Z0-9_\\-\\.]+@[a-zA-Z0-9\\-]+(\\.[a-zA-Z0-9\\-]+){0,2}\\.((com)|(cn)|(net))$");
    private static final Pattern mobilePattern = Pattern.compile("^[1-9][0-9]{10,12}$");
    private static final Pattern numPattern = Pattern.compile("^-{0,1}\\d+\\.{0,1}\\d*$");
    private static final Pattern positiveIntNumPattern = Pattern.compile("^[1-9][0-9]*$");

    public static <T> T deepCopy(T t) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(t);
            ObjectInputStream oi = new ObjectInputStream(new ByteArrayInputStream(bo.toByteArray()));
            return (T)oi.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0\u5e8f\u5217\u5316\u63a5\u53e3", e);
        }
    }

    public static String implode(List<?> dataList, String glue) {
        if (dataList == null || dataList.size() == 0) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer();
        for (Object obj : dataList) {
            if (obj == null) {
                strBuffer.append("");
            } else {
                strBuffer.append(obj.toString());
            }
            strBuffer.append(glue);
        }
        int len = strBuffer.length();
        return strBuffer.delete(len - glue.length(), len).toString();
    }

    public static String implode(List<?> dataList) {
        return Utils.implode(dataList, ",");
    }

    public static String implode(Object[] datas) {
        if (datas == null || datas.length == 0) {
            return "";
        }
        return Utils.implode(Arrays.asList(datas));
    }

    public static List<Object> asList(Object ... params) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (params != null) {
            for (Object p : params) {
                list.add(p);
            }
        }
        return list;
    }

    public static long phpTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean isEmail(String email) {
        return email != null && mailPattern.matcher(email).matches();
    }

    public static boolean isMobile(String mobile) {
        return mobile != null && mobilePattern.matcher(mobile).matches();
    }

    public static boolean isNum(String ch) {
        return ch != null && numPattern.matcher(ch.trim()).matches();
    }

    public static long ip2long(String ip) {
        String default_ip = "127.0.0.1";
        if (StringUtils.isEmpty((CharSequence)ip)) {
            ip = default_ip;
        }
        try {
            String[] splits = ip.trim().split("\\.");
            int segmentCount = splits.length;
            if (segmentCount == 4) {
                long ipnum = 0L;
                for (int i = segmentCount - 1; i >= 0; --i) {
                    ipnum += Long.parseLong(splits[i]) << (segmentCount - 1 - i) * 8;
                }
                return ipnum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Utils.ip2long(default_ip);
    }

    public static String ip2string(long ipnum) {
        StringBuffer ipBuffer = new StringBuffer();
        ipBuffer.append(String.valueOf(ipnum >>> 24)).append(".");
        ipBuffer.append(String.valueOf((ipnum & 0xFFFFFFL) >>> 16)).append(".");
        ipBuffer.append(String.valueOf((ipnum & 0xFFFFL) >>> 8)).append(".");
        ipBuffer.append(String.valueOf(ipnum & 0xFFL));
        return ipBuffer.toString();
    }

    public static List<String> listIp(String ipMode) {
        ArrayList<String> ipList = new ArrayList<String>();
        if (ipMode == null || ipMode.trim().length() == 0) {
            return ipList;
        }
        String[] splits = ipMode.trim().split("/");
        if (splits.length == 1) {
            ipList.add(splits[0]);
        } else if (splits.length == 2) {
            long ipCount = (long)Math.pow(2.0, 32 - Integer.parseInt(splits[1]));
            long initIP = Utils.ip2long(splits[0]);
            for (long i = 0L; i < ipCount; ++i) {
                ipList.add(Utils.ip2string(initIP + i));
            }
        }
        return ipList;
    }

    public static String randString(int length) {
        return Utils.randString(length, false);
    }

    public static String randString(int length, boolean onlyDigital) {
        if (onlyDigital) {
            return RandomStringUtils.random((int)length, (char[])nums);
        }
        return RandomStringUtils.random((int)length, (char[])chars);
    }

    public static String randString(int length, boolean withDigital, boolean caseSensitive) {
        String ret = null;
        ret = caseSensitive ? (withDigital ? RandomStringUtils.random((int)length, (char[])upper_chars) : RandomStringUtils.random((int)length, (char[])upper_chars)) : (withDigital ? RandomStringUtils.random((int)length, (char[])chars) : RandomStringUtils.random((int)length, (char[])chars_without_num));
        return ret;
    }

    public static String fill(String piece, int repeat) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < repeat; ++i) {
            builder.append(piece);
        }
        return builder.toString();
    }

    public static boolean isPositiveIntNum(String ch) {
        boolean matches;
        boolean bl = matches = ch != null && positiveIntNumPattern.matcher(ch.trim()).matches();
        if (matches) {
            try {
                return Integer.parseInt(ch.trim()) <= Integer.MAX_VALUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static <T> List<T> splitToList(String str, String separator, Class<T> clazz) {
        ArrayList<T> retList = new ArrayList<T>();
        try {
            String[] split;
            if (str == null || str.trim().length() == 0) {
                return retList;
            }
            for (String s : split = str.split(separator)) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                retList.add(clazz.getConstructor(String.class).newInstance(s.trim()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return retList;
    }

    public static String like(String val, boolean isHeadTail) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return "";
        }
        return isHeadTail ? "%" + val + "%" : val + "%";
    }

    public static List<DateFormater> listDate(DateFormater startDate, DateFormater endDate) {
        ArrayList<DateFormater> dates = new ArrayList<DateFormater>();
        DateFormater begin = startDate.getBegin();
        while (!begin.getDate().after(endDate.getDate())) {
            dates.add(begin);
            begin = begin.getOffset(1);
        }
        return dates;
    }

    public static String formatMoney(int amount, int fractionDigits) {
        return Utils.formatMoney(new BigDecimal((double)amount / 100.0), fractionDigits);
    }

    public static String formatMoney(long amount, int fractionDigits) {
        return Utils.formatMoney(new BigDecimal((double)amount / 100.0), fractionDigits);
    }

    public static String formatMoney(BigDecimal amount, int fractionDigits) {
        NumberFormat currencyInstance = NumberFormat.getCurrencyInstance();
        currencyInstance.setMaximumFractionDigits(fractionDigits);
        return currencyInstance.format(amount).substring(1);
    }

    public static String formatMoney(BigDecimal amount, Locale inLocale, int fractionDigits) {
        NumberFormat currencyInstance = NumberFormat.getCurrencyInstance(inLocale);
        currencyInstance.setMaximumFractionDigits(fractionDigits);
        return currencyInstance.format(amount);
    }

    public static synchronized long getCounter() {
        return counter++;
    }

    public static void main(String[] args) {
        System.out.println(Utils.randString(8));
    }

    public static String getDingDingDomain() {
        return "https://app120489.eapps.dingtalkcloud.com";
    }
}

