package com.ejianc.framework.core.util;


import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.math.BigDecimal;
import java.net.URL;

public class ImgUtils {

	/**
	 * 根据指定大小和指定精度压缩图片
	 *
	 * @param imgUrl       源图片地址
	 * @param inputStream  源图片inputStream
	 * @return 目标文件 byte[]
	 */
	public static byte[] compressPic(String imgUrl,InputStream inputStream) {
		try {
			//获取图片信息
			BufferedImage bim = null;
			if(StringUtils.isNotEmpty(imgUrl)){
				bim = ImageIO.read(new URL(imgUrl));
			}
			if(inputStream!=null){
				bim = ImageIO.read(inputStream);
			}
			if(bim == null){
				return null;
			}
			int srcWidth = bim.getWidth();
			int srcHeight = bim.getHeight();

			//先转换成jpg
			Thumbnails.Builder builder ;
			if(inputStream!=null){
				builder = Thumbnails.of(bim).outputFormat("jpg");
			}else {
				builder = Thumbnails.of(new URL(imgUrl)).outputFormat("jpg");
			}
			// 指定大小（宽或高超出会才会被缩放）
			if (srcWidth > 4000 || srcHeight > 4000) {
				builder.size(4000, 4000);
			} else {
				//宽高均小，指定原大小
				builder.size(srcWidth, srcHeight);
			}
			// 写入到内存
			ByteArrayOutputStream bos = new ByteArrayOutputStream(); //字节输出流（写入到内存）
			builder.toOutputStream(bos);

			// 递归压缩，直到目标文件大小小于desFileSize
			byte[] bytes = compressPicCycle(bos.toByteArray(), 3*1024L, 0.8);
			System.out.println("图片压缩完成！");
			bos.close();
			return bytes;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}finally {
			if(inputStream!=null){
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public static byte[] compressPicNew(String imgUrl,InputStream inputStream,Integer desMaxWidth,Integer desMaxHeight) {
		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		try {
			BufferedImage image = null;
			if(StringUtils.isNotEmpty(imgUrl)){
				image = ImageIO.read(new URL(imgUrl));
			}else if(inputStream != null){
				image = ImageIO.read(inputStream);
			}else {
				System.out.println("压缩图片失败!参数不能为空！！");
				throw new IOException("压缩图片失败!参数不能为空！");
			}
			BufferedImage thumbnailImg = new BufferedImage(desMaxWidth,desMaxHeight,BufferedImage.TYPE_INT_RGB);
			thumbnailImg.getGraphics().drawImage(image,0,0,desMaxWidth,desMaxHeight,null);
			ImageIO.write(thumbnailImg,"jpg",byteArrayOutputStream);
			return byteArrayOutputStream.toByteArray();
		} catch (IOException e) {
			e.printStackTrace();
			System.out.println("压缩图片失败！");
		}finally {
			if(inputStream != null){
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			try {
				byteArrayOutputStream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return null;
	}


	/**
	 * 根据指定大小和指定精度压缩图片
	 *
	 * @param imgUrl       源图片地址
	 * @param inputStream  源图片inputStream
	 * @param desFileSize  指定图片大小，单位kb（压缩到多大以内）  3 * 1024
	 * @param desMaxWidth  目标最大宽度                       4000
	 * @param desMaxHeight 目标最大高度                       4000
	 * @return 目标文件 byte[]
	 */
	public static byte[] compressPic(String imgUrl,InputStream inputStream,Integer desMaxWidth,Integer desMaxHeight,Integer desFileSize) {
		if(desMaxWidth == null){
			desMaxWidth = 4000;
		}
		if(desMaxHeight == null){
			desMaxHeight = 4000;
		}
		if(desFileSize == null){
			desFileSize = 3;
		}
		try {
			//获取图片信息
			BufferedImage bim = null;
			if(StringUtils.isNotEmpty(imgUrl)){
				bim = ImageIO.read(new URL(imgUrl));
			}
			if(inputStream!=null){
				bim = ImageIO.read(inputStream);
			}
			if(bim == null){
				return null;
			}
			int srcWidth = bim.getWidth();
			int srcHeight = bim.getHeight();

			//先转换成jpg
			Thumbnails.Builder builder ;
			if(inputStream!=null){
				builder = Thumbnails.of(bim).outputFormat("jpg");
			}else {
				builder = Thumbnails.of(new URL(imgUrl)).outputFormat("jpg");
			}
			// 指定大小（宽或高超出会才会被缩放）
			if (srcWidth > desMaxWidth || srcHeight > desMaxHeight) {
				builder.size(desMaxWidth, desMaxHeight);
			} else {
				//宽高均小，指定原大小
				builder.size(srcWidth, srcHeight);
			}
			// 写入到内存
			ByteArrayOutputStream bos = new ByteArrayOutputStream(); //字节输出流（写入到内存）
			builder.toOutputStream(bos);

			// 递归压缩，直到目标文件大小小于desFileSize
			byte[] bytes = compressPicCycle(bos.toByteArray(), desFileSize*1024L, 0.8);
			System.out.println("图片压缩完成！");
			bos.close();
			return bytes;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}finally {
			if(inputStream!=null){
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	private static byte[] compressPicCycle(byte[] bytes, long desFileSize, double accuracy) throws IOException {
		// File srcFileJPG = new File(desPath);
		long srcFileSizeJPG = bytes.length;
		// 2、判断大小，如果小于500kb，不压缩；如果大于等于500kb，压缩
		if (srcFileSizeJPG <= desFileSize * 1024) {
			return bytes;
		}
		// 计算宽高
		InputStream nextInputStream = new ByteArrayInputStream(bytes);
		BufferedImage bim = ImageIO.read(nextInputStream);
		int srcWidth = bim.getWidth();
		int srcHeight = bim.getHeight();
		int desWidth = new BigDecimal(srcWidth).multiply(new BigDecimal(accuracy)).intValue();
		int desHeight = new BigDecimal(srcHeight).multiply(new BigDecimal(accuracy)).intValue();

		ByteArrayOutputStream bos = new ByteArrayOutputStream(); //字节输出流（写入到内存）
		InputStream is = new ByteArrayInputStream(bytes);
		Thumbnails.of(is).size(desWidth, desHeight).outputQuality(accuracy).toOutputStream(bos);
		byte[] res = compressPicCycle(bos.toByteArray(), desFileSize, accuracy);
		try {
			nextInputStream.close();
			bos.close();
			is.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return res;
	}
}
